/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.dsmlv2.request;

import javax.naming.NamingException;
import org.apache.directory.shared.dsmlv2.ParserUtils;
import org.apache.directory.shared.dsmlv2.request.AbstractRequestDsml;
import org.apache.directory.shared.ldap.codec.MessageTypeEnum;
import org.apache.directory.shared.ldap.codec.add.AddRequestCodec;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.name.DN;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class AddRequestDsml
extends AbstractRequestDsml {
    public AddRequestDsml() {
        super(new AddRequestCodec());
    }

    public AddRequestDsml(AddRequestCodec ldapMessage) {
        super(ldapMessage);
    }

    public MessageTypeEnum getMessageType() {
        return this.instance.getMessageType();
    }

    public Element toDsml(Element root) {
        Entry entry;
        Element element = super.toDsml(root);
        AddRequestCodec request = (AddRequestCodec)this.instance;
        if (request.getEntry() != null) {
            element.addAttribute("dn", request.getEntry().getDn().getName());
        }
        if ((entry = request.getEntry()) != null) {
            for (EntryAttribute attribute : entry) {
                Element attributeElement = element.addElement("attr");
                attributeElement.addAttribute("name", attribute.getId());
                for (Value value : attribute) {
                    if (ParserUtils.needsBase64Encoding(value.get())) {
                        Namespace xsdNamespace = new Namespace("xsd", "http://www.w3c.org/2001/XMLSchema");
                        Namespace xsiNamespace = new Namespace("xsi", "http://www.w3c.org/2001/XMLSchema-instance");
                        attributeElement.getDocument().getRootElement().add(xsdNamespace);
                        attributeElement.getDocument().getRootElement().add(xsiNamespace);
                        Element valueElement = attributeElement.addElement("value").addText(ParserUtils.base64Encode(value.get()));
                        valueElement.addAttribute(new QName("type", xsiNamespace), "xsd:base64Binary");
                        continue;
                    }
                    attributeElement.addElement("value").addText(value.getString());
                }
            }
        }
        return element;
    }

    public void initEntry() {
        ((AddRequestCodec)this.instance).initEntry();
    }

    public Entry getEntry() {
        return ((AddRequestCodec)this.instance).getEntry();
    }

    public void addAttributeType(String type) throws NamingException {
        ((AddRequestCodec)this.instance).addAttributeType(type);
    }

    public void addAttributeValue(Object value) {
        if (value instanceof Value) {
            ((AddRequestCodec)this.instance).addAttributeValue((Value)value);
        } else if (value instanceof String) {
            ((AddRequestCodec)this.instance).addAttributeValue((String)value);
        } else if (value instanceof byte[]) {
            ((AddRequestCodec)this.instance).addAttributeValue((byte[])value);
        }
    }

    public DN getEntryDn() {
        return ((AddRequestCodec)this.instance).getEntryDn();
    }

    public void setEntryDn(DN entryDn) {
        ((AddRequestCodec)this.instance).setEntryDn(entryDn);
    }

    public void setEntry(Entry entry) {
        ((AddRequestCodec)this.instance).setEntry(entry);
    }

    public String getCurrentAttributeType() {
        return ((AddRequestCodec)this.instance).getCurrentAttributeType();
    }
}

