/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import java.util.Iterator;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.filter.LessEqNode;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.LdapComparator;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.SchemaManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LessEqEvaluator<T, ID>
implements Evaluator<LessEqNode<T>, ServerEntry, ID> {
    private final LessEqNode<T> node;
    private final Store<ServerEntry, ID> db;
    private final SchemaManager schemaManager;
    private final AttributeType type;
    private final Normalizer normalizer;
    private final LdapComparator<? super Object> ldapComparator;
    private final Index<T, ServerEntry, ID> idx;

    public LessEqEvaluator(LessEqNode<T> node, Store<ServerEntry, ID> db, SchemaManager schemaManager) throws Exception {
        this.db = db;
        this.node = node;
        this.schemaManager = schemaManager;
        this.type = schemaManager.lookupAttributeTypeRegistry(node.getAttribute());
        this.idx = db.hasIndexOn(node.getAttribute()) ? db.getIndex(node.getAttribute()) : null;
        MatchingRule mr = this.type.getOrdering();
        if (mr == null) {
            mr = this.type.getEquality();
        }
        if (mr == null) {
            throw new IllegalStateException(I18n.err(I18n.ERR_717, node));
        }
        this.normalizer = mr.getNormalizer();
        this.ldapComparator = mr.getLdapComparator();
    }

    @Override
    public LessEqNode<T> getExpression() {
        return this.node;
    }

    public AttributeType getAttributeType() {
        return this.type;
    }

    public Normalizer getNormalizer() {
        return this.normalizer;
    }

    public LdapComparator<? super Object> getLdapComparator() {
        return this.ldapComparator;
    }

    @Override
    public boolean evaluateId(ID id) throws Exception {
        if (this.idx != null) {
            return this.idx.reverseLessOrEq(id, this.node.getValue().get());
        }
        return this.evaluateEntry(this.db.lookup(id));
    }

    @Override
    public boolean evaluate(IndexEntry<?, ServerEntry, ID> indexEntry) throws Exception {
        if (this.idx != null) {
            return this.idx.reverseLessOrEq(indexEntry.getId(), this.node.getValue().get());
        }
        ServerEntry entry = indexEntry.getObject();
        if (null == entry) {
            entry = this.db.lookup(indexEntry.getId());
            indexEntry.setObject(entry);
        }
        if (null == entry) {
            return false;
        }
        ServerAttribute attr = (ServerAttribute)entry.get(this.type);
        if (attr != null && this.evaluate(indexEntry, attr)) {
            return true;
        }
        if (this.schemaManager.getAttributeTypeRegistry().hasDescendants(this.node.getAttribute())) {
            Iterator<AttributeType> descendants = this.schemaManager.getAttributeTypeRegistry().descendants(this.node.getAttribute());
            while (descendants.hasNext()) {
                AttributeType descendant = descendants.next();
                attr = (ServerAttribute)entry.get(descendant);
                if (attr == null || !this.evaluate(indexEntry, attr)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean evaluateEntry(ServerEntry entry) throws Exception {
        ServerAttribute attr = (ServerAttribute)entry.get(this.type);
        if (attr != null && this.evaluate(null, attr)) {
            return true;
        }
        if (this.schemaManager.getAttributeTypeRegistry().hasDescendants(this.node.getAttribute())) {
            Iterator<AttributeType> descendants = this.schemaManager.getAttributeTypeRegistry().descendants(this.node.getAttribute());
            while (descendants.hasNext()) {
                AttributeType descendant = descendants.next();
                attr = (ServerAttribute)entry.get(descendant);
                if (attr == null || !this.evaluate(null, attr)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean evaluate(IndexEntry<Object, ServerEntry, ID> indexEntry, ServerAttribute attribute) throws Exception {
        for (Value value : attribute) {
            value.normalize(this.normalizer);
            if (this.ldapComparator.compare(value.getNormalizedValue(), this.node.getValue().getNormalizedValue()) > 0) continue;
            if (indexEntry != null) {
                indexEntry.setValue(value.getNormalizedValue());
            }
            return true;
        }
        return false;
    }
}

