/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.xdbm.EmptyIndexCursor;
import org.apache.directory.server.xdbm.ForwardIndexEntry;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.SingletonIndexCursor;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.server.xdbm.search.Optimizer;
import org.apache.directory.server.xdbm.search.SearchEngine;
import org.apache.directory.server.xdbm.search.impl.CursorBuilder;
import org.apache.directory.server.xdbm.search.impl.EvaluatorBuilder;
import org.apache.directory.shared.ldap.filter.AndNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.ScopeNode;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.name.DN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSearchEngine<ID>
implements SearchEngine<ServerEntry, ID> {
    private final Optimizer optimizer;
    private final Store<ServerEntry, ID> db;
    private final CursorBuilder<ID> cursorBuilder;
    private final EvaluatorBuilder<ID> evaluatorBuilder;

    public DefaultSearchEngine(Store<ServerEntry, ID> db, CursorBuilder<ID> cursorBuilder, EvaluatorBuilder<ID> evaluatorBuilder, Optimizer optimizer) {
        this.db = db;
        this.optimizer = optimizer;
        this.cursorBuilder = cursorBuilder;
        this.evaluatorBuilder = evaluatorBuilder;
    }

    @Override
    public Optimizer getOptimizer() {
        return this.optimizer;
    }

    @Override
    public IndexCursor<ID, ServerEntry, ID> cursor(DN base, AliasDerefMode aliasDerefMode, ExprNode filter, SearchControls searchCtls) throws Exception {
        ID baseId = this.db.getEntryId(base.getNormName());
        if (baseId == null) {
            return new EmptyIndexCursor();
        }
        String aliasedBase = this.db.getAliasIndex().reverseLookup(baseId);
        DN effectiveBase = null == aliasedBase || !aliasDerefMode.isDerefFindingBase() ? base : new DN(aliasedBase);
        if (searchCtls.getSearchScope() == 0) {
            ID effectiveBaseId = baseId;
            if (effectiveBase != base) {
                effectiveBaseId = this.db.getEntryId(effectiveBase.toNormName());
            }
            ForwardIndexEntry indexEntry = new ForwardIndexEntry();
            indexEntry.setId(effectiveBaseId);
            this.optimizer.annotate(filter);
            Evaluator evaluator = this.evaluatorBuilder.build(filter);
            if (evaluator.evaluate(indexEntry)) {
                return new SingletonIndexCursor(indexEntry);
            }
            return new EmptyIndexCursor();
        }
        AndNode root = new AndNode();
        ScopeNode node = new ScopeNode(aliasDerefMode, effectiveBase.getNormName(), SearchScope.getSearchScope(searchCtls.getSearchScope()));
        root.getChildren().add(node);
        root.getChildren().add(filter);
        this.optimizer.annotate(root);
        return this.cursorBuilder.build(root);
    }

    @Override
    public Evaluator<? extends ExprNode, ServerEntry, ID> evaluator(ExprNode filter) throws Exception {
        return this.evaluatorBuilder.build(filter);
    }
}

