/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.replication.configuration;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.util.StringTools;

public class ReplicaId
implements Comparable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Pattern REPLICA_ID_PATTERN = Pattern.compile("[-_A-Z0-9]{1,16}");
    private String id;

    public ReplicaId(String id) {
        if (StringTools.isEmpty(id)) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_694, id));
        }
        String tmpId = id.trim().toUpperCase();
        if (!REPLICA_ID_PATTERN.matcher(tmpId).matches()) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_695, id));
        }
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof ReplicaId) {
            return this.id.equals(((ReplicaId)o).id);
        }
        return false;
    }

    public int compareTo(Object o) {
        return this.id.compareTo(((ReplicaId)o).id);
    }

    public String toString() {
        return this.id;
    }
}

