/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.bind;

import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.jndi.JndiUtils;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.message.control.Control;
import org.apache.directory.shared.ldap.message.internal.InternalBindRequest;
import org.apache.directory.shared.ldap.message.internal.InternalLdapResult;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.util.ExceptionUtils;
import org.apache.directory.shared.ldap.util.StringTools;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSaslCallbackHandler
implements CallbackHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSaslCallbackHandler.class);
    private static final Control[] EMPTY = new Control[0];
    private String username;
    private String realm;
    protected LdapSession ldapSession;
    protected CoreSession adminSession;
    protected final DirectoryService directoryService;
    protected final InternalBindRequest bindRequest;

    protected AbstractSaslCallbackHandler(DirectoryService directoryService, InternalBindRequest bindRequest) {
        this.directoryService = directoryService;
        this.bindRequest = bindRequest;
    }

    protected String getUsername() {
        return this.username;
    }

    protected String getRealm() {
        return this.realm;
    }

    protected abstract EntryAttribute lookupPassword(String var1, String var2);

    protected abstract void authorize(AuthorizeCallback var1) throws Exception;

    @Override
    public void handle(Callback[] callbacks) {
        for (int i = 0; i < callbacks.length; ++i) {
            Callback callback = callbacks[i];
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing callback {} of {}: {}" + callback.getClass(), i + 1, (Object)callbacks.length);
            }
            if (callback instanceof NameCallback) {
                NameCallback nameCB = (NameCallback)callback;
                LOG.debug("NameCallback default name:  {}", (Object)nameCB.getDefaultName());
                this.username = nameCB.getDefaultName();
                continue;
            }
            if (callback instanceof RealmCallback) {
                RealmCallback realmCB = (RealmCallback)callback;
                LOG.debug("RealmCallback default text:  {}", (Object)realmCB.getDefaultText());
                this.realm = realmCB.getDefaultText();
                continue;
            }
            if (callback instanceof PasswordCallback) {
                PasswordCallback passwordCB = (PasswordCallback)callback;
                EntryAttribute userPassword = this.lookupPassword(this.getUsername(), this.getRealm());
                if (userPassword == null) continue;
                byte[] password = userPassword.get().getBytes();
                String strPassword = StringTools.utf8ToString(password);
                passwordCB.setPassword(strPassword.toCharArray());
                continue;
            }
            if (!(callback instanceof AuthorizeCallback)) continue;
            AuthorizeCallback authorizeCB = (AuthorizeCallback)callback;
            LOG.debug("AuthorizeCallback authnID:  {}", (Object)authorizeCB.getAuthenticationID());
            LOG.debug("AuthorizeCallback authzID:  {}", (Object)authorizeCB.getAuthorizationID());
            LOG.debug("AuthorizeCallback authorizedID:  {}", (Object)authorizeCB.getAuthorizedID());
            LOG.debug("AuthorizeCallback isAuthorized:  {}", authorizeCB.isAuthorized());
            try {
                this.authorize(authorizeCB);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(I18n.err(I18n.ERR_677, new Object[0]), e);
            }
        }
    }

    protected LdapContext getContext(IoSession session, InternalBindRequest bindRequest, Hashtable<String, Object> env) {
        InternalLdapResult result = bindRequest.getResultResponse().getLdapResult();
        InitialLdapContext ctx = null;
        try {
            Control[] connCtls = bindRequest.getControls().values().toArray(EMPTY);
            env.put(DirectoryService.JNDI_KEY, this.directoryService);
            ctx = new InitialLdapContext(env, JndiUtils.toJndiControls(connCtls));
        }
        catch (NamingException e) {
            ResultCodeEnum code;
            if (e instanceof LdapException) {
                code = ((LdapException)((Object)e)).getResultCode();
                result.setResultCode(code);
            } else {
                code = ResultCodeEnum.getBestEstimate(e, bindRequest.getType());
                result.setResultCode(code);
            }
            String msg = "Bind failed: " + e.getLocalizedMessage();
            if (LOG.isDebugEnabled()) {
                msg = msg + ":\n" + ExceptionUtils.getStackTrace(e);
                msg = msg + "\n\nBindRequest = \n" + bindRequest.toString();
            }
            if (e.getResolvedName() != null && (code == ResultCodeEnum.NO_SUCH_OBJECT || code == ResultCodeEnum.ALIAS_PROBLEM || code == ResultCodeEnum.INVALID_DN_SYNTAX || code == ResultCodeEnum.ALIAS_DEREFERENCING_PROBLEM)) {
                result.setMatchedDn((DN)e.getResolvedName());
            }
            result.setErrorMessage(msg);
            session.write(bindRequest.getResultResponse());
            ctx = null;
        }
        return ctx;
    }

    protected Hashtable<String, Object> getEnvironment(IoSession session) {
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put("java.naming.provider.url", session.getAttribute("baseDn"));
        env.put("java.naming.factory.initial", "org.apache.directory.server.core.jndi.CoreContextFactory");
        env.put("java.naming.security.principal", "uid=admin,ou=system");
        env.put("java.naming.security.credentials", "secret");
        env.put("java.naming.security.authentication", AuthenticationLevel.SIMPLE.toString());
        return env;
    }
}

