/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.store;

import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.kerberos.shared.store.PrincipalStore;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.server.kerberos.shared.store.SingleBaseSearch;
import org.apache.directory.shared.ldap.name.DN;

public class DirectoryPrincipalStore
implements PrincipalStore {
    private final DirectoryService directoryService;
    private final DN searchBaseDn;

    public DirectoryPrincipalStore(DirectoryService directoryService, DN searchBaseDn) {
        this.directoryService = directoryService;
        this.searchBaseDn = searchBaseDn;
    }

    public String changePassword(KerberosPrincipal principal, String newPassword) throws Exception {
        SingleBaseSearch singleBaseSearch = new SingleBaseSearch(this.directoryService, this.searchBaseDn);
        return singleBaseSearch.changePassword(principal, newPassword);
    }

    public PrincipalStoreEntry getPrincipal(KerberosPrincipal principal) throws Exception {
        SingleBaseSearch singleBaseSearch = new SingleBaseSearch(this.directoryService, this.searchBaseDn);
        return singleBaseSearch.getPrincipal(principal);
    }
}

