/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.trigger;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.DefaultCoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.LdapPrincipal;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.NormalizerMappingResolver;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.normalizers.OidNormalizer;
import org.apache.directory.shared.ldap.trigger.TriggerSpecification;
import org.apache.directory.shared.ldap.trigger.TriggerSpecificationParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggerSpecCache {
    private static final String PRESCRIPTIVE_TRIGGER_ATTR = "prescriptiveTriggerSpecification";
    private static final Logger LOG = LoggerFactory.getLogger(TriggerSpecCache.class);
    private final Map<String, List<TriggerSpecification>> triggerSpecs = new HashMap<String, List<TriggerSpecification>>();
    private final PartitionNexus nexus;
    private final TriggerSpecificationParser triggerSpecParser;

    public TriggerSpecCache(DirectoryService directoryService) throws Exception {
        this.nexus = directoryService.getPartitionNexus();
        final SchemaManager schemaManager = directoryService.getSchemaManager();
        this.triggerSpecParser = new TriggerSpecificationParser(new NormalizerMappingResolver(){

            @Override
            public Map<String, OidNormalizer> getNormalizerMapping() throws Exception {
                return schemaManager.getNormalizerMapping();
            }
        });
        this.initialize(directoryService);
    }

    private void initialize(DirectoryService directoryService) throws Exception {
        Set<String> suffixes = this.nexus.listSuffixes(null);
        for (String suffix : suffixes) {
            DN baseDn = new DN(suffix);
            EqualityNode<String> filter = new EqualityNode<String>("objectClass", new ClientStringValue("triggerExecutionSubentry"));
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            DN adminDn = new DN("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
            adminDn.normalize(directoryService.getSchemaManager().getNormalizerMapping());
            DefaultCoreSession adminSession = new DefaultCoreSession(new LdapPrincipal(adminDn, AuthenticationLevel.STRONG), directoryService);
            SearchOperationContext searchOperationContext = new SearchOperationContext(adminSession, baseDn, filter, ctls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
            EntryFilteringCursor results = this.nexus.search(searchOperationContext);
            while (results.next()) {
                ClonedServerEntry resultEntry = (ClonedServerEntry)results.get();
                DN subentryDn = resultEntry.getDn();
                EntryAttribute triggerSpec = resultEntry.get(PRESCRIPTIVE_TRIGGER_ATTR);
                if (triggerSpec == null) {
                    LOG.warn("Found triggerExecutionSubentry '" + subentryDn + "' without any " + PRESCRIPTIVE_TRIGGER_ATTR);
                    continue;
                }
                DN normSubentryName = subentryDn.normalize(directoryService.getSchemaManager().getNormalizerMapping());
                this.subentryAdded(normSubentryName, resultEntry);
            }
            results.close();
        }
    }

    private boolean hasPrescriptiveTrigger(ServerEntry entry) throws Exception {
        EntryAttribute triggerSpec = entry.get(PRESCRIPTIVE_TRIGGER_ATTR);
        return triggerSpec != null;
    }

    public void subentryAdded(DN normName, ServerEntry entry) throws Exception {
        EntryAttribute triggerSpec = entry.get(PRESCRIPTIVE_TRIGGER_ATTR);
        if (triggerSpec == null) {
            return;
        }
        ArrayList<TriggerSpecification> subentryTriggerSpecs = new ArrayList<TriggerSpecification>();
        for (Value value : triggerSpec) {
            TriggerSpecification item = null;
            try {
                item = this.triggerSpecParser.parse(value.getString());
                subentryTriggerSpecs.add(item);
            }
            catch (ParseException e) {
                String msg = I18n.err(I18n.ERR_73, item);
                LOG.error(msg, e);
            }
        }
        this.triggerSpecs.put(normName.getNormName(), subentryTriggerSpecs);
    }

    public void subentryDeleted(DN normName, ServerEntry entry) throws Exception {
        if (!this.hasPrescriptiveTrigger(entry)) {
            return;
        }
        this.triggerSpecs.remove(normName.toString());
    }

    public void subentryModified(ModifyOperationContext opContext, ServerEntry entry) throws Exception {
        if (!this.hasPrescriptiveTrigger(entry)) {
            return;
        }
        DN normName = opContext.getDn();
        List<Modification> mods = opContext.getModItems();
        boolean isTriggerSpecModified = false;
        for (Modification mod : mods) {
            isTriggerSpecModified |= mod.getAttribute().contains(PRESCRIPTIVE_TRIGGER_ATTR);
        }
        if (isTriggerSpecModified) {
            this.subentryDeleted(normName, entry);
            this.subentryAdded(normName, entry);
        }
    }

    public List<TriggerSpecification> getSubentryTriggerSpecs(String subentryDn) {
        List<TriggerSpecification> subentryTriggerSpecs = this.triggerSpecs.get(subentryDn);
        if (subentryTriggerSpecs == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(subentryTriggerSpecs);
    }

    public void subentryRenamed(DN oldName, DN newName) {
        this.triggerSpecs.put(newName.getNormName(), this.triggerSpecs.remove(oldName.getNormName()));
    }
}

