/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.trigger;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.partition.ByPassConstants;
import org.apache.directory.server.core.trigger.AbstractStoredProcedureParameterInjector;
import org.apache.directory.server.core.trigger.StoredProcedureParameterInjector;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.trigger.StoredProcedureParameter;

public class ModifyStoredProcedureParameterInjector
extends AbstractStoredProcedureParameterInjector {
    private DN modifiedEntryName;
    private List<Modification> modifications;
    private ServerEntry oldEntry;
    StoredProcedureParameterInjector.MicroInjector $objectInjector = new StoredProcedureParameterInjector.MicroInjector(){

        public Object inject(OperationContext opContext, StoredProcedureParameter param) throws NamingException {
            return new DN(ModifyStoredProcedureParameterInjector.this.modifiedEntryName.getName());
        }
    };
    StoredProcedureParameterInjector.MicroInjector $modificationInjector = new StoredProcedureParameterInjector.MicroInjector(){

        public Object inject(OperationContext opContext, StoredProcedureParameter param) throws NamingException {
            ArrayList<Modification> newMods = new ArrayList<Modification>();
            for (Modification mod : ModifyStoredProcedureParameterInjector.this.modifications) {
                newMods.add(mod.clone());
            }
            return newMods;
        }
    };
    StoredProcedureParameterInjector.MicroInjector $oldEntryInjector = new StoredProcedureParameterInjector.MicroInjector(){

        public Object inject(OperationContext opContext, StoredProcedureParameter param) throws NamingException {
            return ModifyStoredProcedureParameterInjector.this.oldEntry;
        }
    };
    StoredProcedureParameterInjector.MicroInjector $newEntryInjector = new StoredProcedureParameterInjector.MicroInjector(){

        public Object inject(OperationContext opContext, StoredProcedureParameter param) throws Exception {
            return ModifyStoredProcedureParameterInjector.this.getEntry(opContext);
        }
    };

    public ModifyStoredProcedureParameterInjector(ModifyOperationContext opContext) throws Exception {
        super(opContext);
        this.modifiedEntryName = opContext.getDn();
        this.modifications = opContext.getModItems();
        this.oldEntry = this.getEntry(opContext);
        Map<Class<?>, StoredProcedureParameterInjector.MicroInjector> injectors = super.getInjectors();
        injectors.put(StoredProcedureParameter.Modify_OBJECT.class, this.$objectInjector);
        injectors.put(StoredProcedureParameter.Modify_MODIFICATION.class, this.$modificationInjector);
        injectors.put(StoredProcedureParameter.Modify_OLD_ENTRY.class, this.$oldEntryInjector);
        injectors.put(StoredProcedureParameter.Modify_NEW_ENTRY.class, this.$newEntryInjector);
    }

    private ClonedServerEntry getEntry(OperationContext opContext) throws Exception {
        return opContext.lookup(this.modifiedEntryName, ByPassConstants.LOOKUP_EXCLUDING_OPR_ATTRS_BYPASS);
    }
}

