/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.subtree;

import javax.naming.NamingException;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.schema.registries.OidRegistry;

public class RefinementLeafEvaluator {
    private final OidRegistry registry;

    public RefinementLeafEvaluator(OidRegistry registry) {
        this.registry = registry;
    }

    public boolean evaluate(SimpleNode node, EntryAttribute objectClasses) throws NamingException {
        if (node == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_295, new Object[0]));
        }
        if (!(node instanceof EqualityNode)) {
            throw new NamingException(I18n.err(I18n.ERR_301, node));
        }
        if (!node.getAttribute().equalsIgnoreCase("objectClass")) {
            throw new NamingException(I18n.err(I18n.ERR_302, node.getAttribute()));
        }
        if (null == objectClasses) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_303, new Object[0]));
        }
        if (!((ServerAttribute)objectClasses).instanceOf("objectClass")) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_304, new Object[0]));
        }
        String value = node.getValue().getString();
        if (objectClasses.contains(value)) {
            return true;
        }
        if (Character.isDigit(value.charAt(0))) {
            for (String objectClass : this.registry.getNameSet(value)) {
                if (!objectClasses.contains(objectClass)) continue;
                return true;
            }
        }
        return false;
    }
}

