/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.HashSet;
import javax.naming.NamingException;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.DefaultServerAttribute;
import org.apache.directory.server.core.entry.DefaultServerEntry;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.schema.SchemaPartition;
import org.apache.directory.server.core.schema.SchemaService;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.DITContentRule;
import org.apache.directory.shared.ldap.schema.DITStructureRule;
import org.apache.directory.shared.ldap.schema.LdapComparator;
import org.apache.directory.shared.ldap.schema.LdapSyntax;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.MatchingRuleUse;
import org.apache.directory.shared.ldap.schema.NameForm;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.SchemaUtils;
import org.apache.directory.shared.ldap.schema.SyntaxChecker;
import org.apache.directory.shared.ldap.schema.registries.NormalizerRegistry;

public class DefaultSchemaService
implements SchemaService {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private ServerEntry schemaSubentry;
    private final Object lock = new Object();
    private SchemaPartition schemaPartition;
    private DN schemaModificationAttributesDN;
    private Object schemaSubentrLock = new Object();

    public DefaultSchemaService() throws Exception {
        this.schemaPartition = new SchemaPartition();
    }

    public boolean isSchemaSubentry(String dnString) throws NamingException {
        if ("cn=schema".equalsIgnoreCase(dnString) || "2.5.4.3=schema".equalsIgnoreCase(dnString)) {
            return true;
        }
        DN dn = new DN(dnString).normalize(this.schemaPartition.getSchemaManager().getNormalizerMapping());
        return dn.getNormName().equals("2.5.4.3=schema");
    }

    public final SchemaManager getSchemaManager() {
        return this.schemaPartition.getSchemaManager();
    }

    public SchemaPartition getSchemaPartition() {
        return this.schemaPartition;
    }

    public void setSchemaPartition(SchemaPartition schemaPartition) {
        this.schemaPartition = schemaPartition;
    }

    private ServerAttribute generateComparators() throws NamingException {
        DefaultServerAttribute attr = new DefaultServerAttribute(this.getSchemaManager().lookupAttributeTypeRegistry("comparators"));
        for (LdapComparator comparator : this.getSchemaManager().getComparatorRegistry()) {
            attr.add(SchemaUtils.render(comparator));
        }
        return attr;
    }

    private ServerAttribute generateNormalizers() throws NamingException {
        DefaultServerAttribute attr = new DefaultServerAttribute(this.getSchemaManager().lookupAttributeTypeRegistry("normalizers"));
        NormalizerRegistry nr = this.getSchemaManager().getNormalizerRegistry();
        for (Normalizer normalizer : nr) {
            attr.add(SchemaUtils.render(normalizer));
        }
        return attr;
    }

    private ServerAttribute generateSyntaxCheckers() throws NamingException {
        DefaultServerAttribute attr = new DefaultServerAttribute(this.getSchemaManager().lookupAttributeTypeRegistry("syntaxCheckers"));
        for (SyntaxChecker syntaxChecker : this.getSchemaManager().getSyntaxCheckerRegistry()) {
            attr.add(SchemaUtils.render(syntaxChecker));
        }
        return attr;
    }

    private ServerAttribute generateObjectClasses() throws NamingException {
        DefaultServerAttribute attr = new DefaultServerAttribute(this.getSchemaManager().lookupAttributeTypeRegistry("objectClasses"));
        for (ObjectClass objectClass : this.getSchemaManager().getObjectClassRegistry()) {
            attr.add(SchemaUtils.render(objectClass).toString());
        }
        return attr;
    }

    private ServerAttribute generateAttributeTypes() throws NamingException {
        DefaultServerAttribute attr = new DefaultServerAttribute(this.getSchemaManager().lookupAttributeTypeRegistry("attributeTypes"));
        for (AttributeType attributeType : this.getSchemaManager().getAttributeTypeRegistry()) {
            attr.add(SchemaUtils.render(attributeType).toString());
        }
        return attr;
    }

    private ServerAttribute generateMatchingRules() throws NamingException {
        DefaultServerAttribute attr = new DefaultServerAttribute(this.getSchemaManager().lookupAttributeTypeRegistry("matchingRules"));
        for (MatchingRule matchingRule : this.getSchemaManager().getMatchingRuleRegistry()) {
            attr.add(SchemaUtils.render(matchingRule).toString());
        }
        return attr;
    }

    private ServerAttribute generateMatchingRuleUses() throws NamingException {
        DefaultServerAttribute attr = new DefaultServerAttribute(this.getSchemaManager().lookupAttributeTypeRegistry("matchingRuleUse"));
        for (MatchingRuleUse matchingRuleUse : this.getSchemaManager().getMatchingRuleUseRegistry()) {
            attr.add(SchemaUtils.render(matchingRuleUse).toString());
        }
        return attr;
    }

    private ServerAttribute generateSyntaxes() throws NamingException {
        DefaultServerAttribute attr = new DefaultServerAttribute(this.getSchemaManager().lookupAttributeTypeRegistry("ldapSyntaxes"));
        for (LdapSyntax syntax : this.getSchemaManager().getLdapSyntaxRegistry()) {
            attr.add(SchemaUtils.render(syntax).toString());
        }
        return attr;
    }

    private ServerAttribute generateDitContextRules() throws NamingException {
        DefaultServerAttribute attr = new DefaultServerAttribute(this.getSchemaManager().lookupAttributeTypeRegistry("ditContentRules"));
        for (DITContentRule ditContentRule : this.getSchemaManager().getDITContentRuleRegistry()) {
            attr.add(SchemaUtils.render(ditContentRule).toString());
        }
        return attr;
    }

    private ServerAttribute generateDitStructureRules() throws NamingException {
        DefaultServerAttribute attr = new DefaultServerAttribute(this.getSchemaManager().lookupAttributeTypeRegistry("ditStructureRules"));
        for (DITStructureRule ditStructureRule : this.getSchemaManager().getDITStructureRuleRegistry()) {
            attr.add(SchemaUtils.render(ditStructureRule).toString());
        }
        return attr;
    }

    private ServerAttribute generateNameForms() throws NamingException {
        DefaultServerAttribute attr = new DefaultServerAttribute(this.getSchemaManager().lookupAttributeTypeRegistry("nameForms"));
        for (NameForm nameForm : this.getSchemaManager().getNameFormRegistry()) {
            attr.add(SchemaUtils.render(nameForm).toString());
        }
        return attr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateSchemaSubentry(ServerEntry mods) throws NamingException {
        DefaultServerEntry attrs = new DefaultServerEntry(this.getSchemaManager(), mods.getDn());
        attrs.put("objectClass", "top", "subschema", "subentry", "apacheSubschema");
        attrs.put("cn", "schema");
        attrs.put(this.generateComparators());
        attrs.put(this.generateNormalizers());
        attrs.put(this.generateSyntaxCheckers());
        attrs.put(this.generateObjectClasses());
        attrs.put(this.generateAttributeTypes());
        attrs.put(this.generateMatchingRules());
        attrs.put(this.generateMatchingRuleUses());
        attrs.put(this.generateSyntaxes());
        attrs.put(this.generateDitContextRules());
        attrs.put(this.generateDitStructureRules());
        attrs.put(this.generateNameForms());
        attrs.put("subtreeSpecification", "{}");
        EntryAttribute createTimestamp = mods.get("createTimestamp");
        attrs.put("createTimestamp", createTimestamp.get());
        attrs.put("creatorsName", "uid=admin,ou=system");
        EntryAttribute schemaModifyTimestamp = mods.get("schemaModifyTimestamp");
        attrs.put("modifyTimestamp", schemaModifyTimestamp.get());
        EntryAttribute schemaModifiersName = mods.get("schemaModifiersName");
        attrs.put("modifiersName", schemaModifiersName.get());
        Object object = this.lock;
        synchronized (object) {
            this.schemaSubentry = attrs;
        }
    }

    private void addAttribute(ServerEntry attrs, String id) throws NamingException {
        EntryAttribute attr = this.schemaSubentry.get(id);
        if (attr != null) {
            attrs.put(attr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerEntry getSubschemaEntryImmutable() throws Exception {
        Object object = this.schemaSubentrLock;
        synchronized (object) {
            if (this.schemaSubentry == null) {
                this.generateSchemaSubentry(this.schemaPartition.lookup(new LookupOperationContext(null, this.schemaModificationAttributesDN)));
            }
            return (ServerEntry)this.schemaSubentry.clone();
        }
    }

    public void initialize() throws Exception {
        try {
            this.schemaModificationAttributesDN = new DN("cn=schemaModifications,ou=schema");
            this.schemaModificationAttributesDN.normalize(this.getSchemaManager().getNormalizerMapping());
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public ServerEntry getSubschemaEntryCloned() throws Exception {
        if (this.schemaSubentry == null) {
            this.generateSchemaSubentry(this.schemaPartition.lookup(new LookupOperationContext(null, this.schemaModificationAttributesDN)));
        }
        return (ServerEntry)this.schemaSubentry.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerEntry getSubschemaEntry(String[] ids) throws Exception {
        if (ids == null) {
            ids = EMPTY_STRING_ARRAY;
        }
        HashSet<String> setOids = new HashSet<String>();
        DefaultServerEntry attrs = new DefaultServerEntry(this.getSchemaManager(), DN.EMPTY_DN);
        boolean returnAllOperationalAttributes = false;
        Object object = this.lock;
        synchronized (object) {
            ClonedServerEntry mods = this.schemaPartition.lookup(new LookupOperationContext(null, this.schemaModificationAttributesDN));
            this.generateSchemaSubentry(mods);
            for (String id : ids) {
                if ("+".equals(id)) {
                    returnAllOperationalAttributes = true;
                    continue;
                }
                if ("*".equals(id)) {
                    setOids.add(id);
                    continue;
                }
                setOids.add(this.getSchemaManager().getAttributeTypeRegistry().getOidByName(id));
            }
            if (returnAllOperationalAttributes || setOids.contains("1.3.6.1.4.1.18060.0.4.1.2.32")) {
                this.addAttribute(attrs, "comparators");
            }
            if (returnAllOperationalAttributes || setOids.contains("1.3.6.1.4.1.18060.0.4.1.2.33")) {
                this.addAttribute(attrs, "normalizers");
            }
            if (returnAllOperationalAttributes || setOids.contains("1.3.6.1.4.1.18060.0.4.1.2.34")) {
                this.addAttribute(attrs, "syntaxCheckers");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.21.6")) {
                this.addAttribute(attrs, "objectClasses");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.21.5")) {
                this.addAttribute(attrs, "attributeTypes");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.21.4")) {
                this.addAttribute(attrs, "matchingRules");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.21.8")) {
                this.addAttribute(attrs, "matchingRuleUse");
            }
            if (returnAllOperationalAttributes || setOids.contains("1.3.6.1.4.1.1466.101.120.16")) {
                this.addAttribute(attrs, "ldapSyntaxes");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.21.2")) {
                this.addAttribute(attrs, "ditContentRules");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.21.1")) {
                this.addAttribute(attrs, "ditStructureRules");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.21.7")) {
                this.addAttribute(attrs, "nameForms");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.18.6")) {
                this.addAttribute(attrs, "subtreeSpecification");
            }
            int minSetSize = 0;
            if (setOids.contains("+")) {
                ++minSetSize;
            }
            if (setOids.contains("*")) {
                ++minSetSize;
            }
            if (setOids.contains("2.16.840.1.113730.3.1.34")) {
                ++minSetSize;
            }
            if (setOids.contains("*") || setOids.contains("2.5.4.0") || setOids.size() == minSetSize) {
                this.addAttribute(attrs, "objectClass");
            }
            if (setOids.contains("*") || setOids.contains("2.5.4.3") || setOids.size() == minSetSize) {
                this.addAttribute(attrs, "cn");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.18.1")) {
                this.addAttribute(attrs, "createTimestamp");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.18.3")) {
                this.addAttribute(attrs, "creatorsName");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.18.2")) {
                this.addAttribute(attrs, "modifyTimestamp");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.18.4")) {
                this.addAttribute(attrs, "modifiersName");
            }
        }
        return attrs;
    }
}

