/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.ldif;

import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.DefaultServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.avl.AvlPartition;
import org.apache.directory.server.core.partition.impl.btree.BTreePartition;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.shared.ldap.csn.CsnFactory;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.ldif.LdifEntry;
import org.apache.directory.shared.ldap.ldif.LdifReader;
import org.apache.directory.shared.ldap.ldif.LdifUtils;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.util.StringTools;
import org.apache.directory.shared.ldap.util.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdifPartition
extends BTreePartition<Long> {
    private static Logger LOG = LoggerFactory.getLogger(LdifPartition.class);
    private String workingDirectory;
    private File suffixDirectory;
    private ServerEntry contextEntry;
    private static final boolean CREATE = Boolean.TRUE;
    private static final boolean DELETE = Boolean.FALSE;
    private int ldifScanInterval;
    private FileFilter dirFilter = new FileFilter(){

        public boolean accept(File dir) {
            return dir.isDirectory();
        }
    };
    private FileFilter entryFilter = new FileFilter(){

        public boolean accept(File dir) {
            if (dir.getName().endsWith(LdifPartition.CONF_FILE_EXTN)) {
                return dir.isFile();
            }
            return false;
        }
    };
    private static final String CONF_FILE_EXTN = ".ldif";
    private AvlPartition wrappedPartition = new AvlPartition();
    private static CsnFactory defaultCSNFactory;

    @Override
    public void initialize() throws Exception {
        this.wrappedPartition.setId(this.id);
        this.wrappedPartition.setSuffix(this.suffix.getName());
        this.wrappedPartition.setSchemaManager(this.schemaManager);
        this.wrappedPartition.initialize();
        defaultCSNFactory = new CsnFactory(0);
        this.searchEngine = this.wrappedPartition.getSearchEngine();
        LOG.debug("id is : {}", (Object)this.wrappedPartition.getId());
        if (this.suffix == null || this.suffix.isEmpty()) {
            String msg = I18n.err(I18n.ERR_150, new Object[0]);
            LOG.error(msg);
            throw new InvalidNameException(msg);
        }
        if (!this.suffix.isNormalized()) {
            this.suffix.normalize(this.schemaManager.getNormalizerMapping());
        }
        String suffixDirName = this.getFileName(this.suffix);
        this.suffixDirectory = new File(this.workingDirectory, suffixDirName);
        if (this.suffixDirectory.exists()) {
            this.loadEntries(new File(this.workingDirectory));
        } else {
            try {
                this.suffixDirectory.mkdir();
            }
            catch (SecurityException se) {
                String msg = I18n.err(I18n.ERR_151, this.suffixDirectory.getAbsolutePath(), se.getLocalizedMessage());
                LOG.error(msg);
                throw se;
            }
            File contextEntryFile = new File(this.suffixDirectory + CONF_FILE_EXTN);
            LOG.info("ldif file doesn't exist {}, creating it.", (Object)contextEntryFile.getAbsolutePath());
            if (this.contextEntry == null) {
                if (contextEntryFile.exists()) {
                    LdifReader reader = new LdifReader(contextEntryFile);
                    this.contextEntry = new DefaultServerEntry(this.schemaManager, reader.next().getEntry());
                    reader.close();
                } else {
                    throw new NamingException(I18n.err(I18n.ERR_632, new Object[0]));
                }
            }
            if (this.contextEntry.get("entryCSN") == null) {
                this.contextEntry.add("entryCSN", defaultCSNFactory.newInstance().toString());
            }
            if (this.contextEntry.get("entryUUID") == null) {
                String uuid = UUID.randomUUID().toString();
                this.contextEntry.add("entryUUID", uuid);
            }
            FileWriter fw = new FileWriter(contextEntryFile);
            fw.write(LdifUtils.convertEntryToLdif(this.contextEntry));
            fw.close();
            this.wrappedPartition.getStore().add(this.contextEntry);
        }
    }

    @Override
    public void add(AddOperationContext addContext) throws Exception {
        this.wrappedPartition.add(addContext);
        this.add(addContext.getEntry());
    }

    @Override
    public void bind(BindOperationContext bindContext) throws Exception {
        this.wrappedPartition.bind(bindContext);
    }

    @Override
    public void delete(Long id) throws Exception {
        ClonedServerEntry entry = this.lookup(id);
        this.wrappedPartition.delete(id);
        if (entry != null) {
            File ldifFile = this.getFile(entry.getDn(), DELETE);
            boolean deleted = this.deleteFile(ldifFile);
            LOG.debug("deleted file {} {}", ldifFile.getAbsoluteFile(), (Object)deleted);
            File parentFile = ldifFile.getParentFile();
            if (parentFile.listFiles().length == 0) {
                this.deleteFile(parentFile);
                LOG.debug("deleted file {} {}", parentFile.getAbsoluteFile(), (Object)deleted);
            }
        }
    }

    @Override
    public void modify(ModifyOperationContext modifyContext) throws Exception {
        Long id = this.getEntryId(modifyContext.getDn().getNormName());
        this.wrappedPartition.modify(id, modifyContext.getModItems());
        ClonedServerEntry modifiedEntry = this.lookup(id);
        modifyContext.setAlteredEntry(modifiedEntry);
        DN dn = modifyContext.getDn();
        FileWriter fw = new FileWriter(this.getFile(dn, DELETE));
        fw.write(LdifUtils.convertEntryToLdif(modifiedEntry));
        fw.close();
    }

    @Override
    public void move(MoveOperationContext moveContext) throws Exception {
        DN oldDn = moveContext.getDn();
        Long id = this.getEntryId(oldDn.getNormName());
        this.wrappedPartition.move(moveContext);
        ClonedServerEntry modifiedEntry = this.lookup(id);
        this.entryMoved(oldDn, modifiedEntry, id, true);
    }

    @Override
    public void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws Exception {
        DN oldDn = moveAndRenameContext.getDn();
        Long id = this.getEntryId(oldDn.getNormName());
        this.wrappedPartition.moveAndRename(moveAndRenameContext);
        ClonedServerEntry modifiedEntry = this.lookup(id);
        moveAndRenameContext.setAlteredEntry(modifiedEntry);
        this.entryMoved(oldDn, modifiedEntry, id, moveAndRenameContext.getDelOldDn());
    }

    @Override
    public void rename(RenameOperationContext renameContext) throws Exception {
        DN oldDn = renameContext.getDn();
        Long id = this.getEntryId(oldDn.getNormName());
        this.wrappedPartition.rename(renameContext);
        ClonedServerEntry modifiedEntry = this.lookup(id);
        renameContext.setAlteredEntry(modifiedEntry);
        this.entryMoved(oldDn, modifiedEntry, id, renameContext.getDelOldDn());
    }

    private void entryMoved(DN oldEntryDn, Entry modifiedEntry, Long entryIdOld, boolean deleteOldEntry) throws Exception {
        this.add(modifiedEntry);
        IndexCursor<Long, ServerEntry, Long> cursor = this.getSubLevelIndex().forwardCursor(entryIdOld);
        while (cursor.next()) {
            IndexEntry entry = (IndexEntry)cursor.get();
            if (entry.getId() == entryIdOld) continue;
            this.add(this.wrappedPartition.lookup(entry.getId()));
        }
        cursor.close();
        if (deleteOldEntry) {
            File file = this.getFile(oldEntryDn, DELETE);
            boolean deleted = this.deleteFile(file);
            LOG.warn("move operation: deleted file {} {}", file.getAbsoluteFile(), (Object)deleted);
            String dirName = file.getAbsolutePath();
            dirName = dirName.substring(0, dirName.indexOf(CONF_FILE_EXTN));
            deleted = this.deleteFile(new File(dirName));
            LOG.warn("move operation: deleted dir {} {}", (Object)dirName, (Object)deleted);
        }
    }

    private void loadEntries(File entryDir) throws Exception {
        LOG.debug("Processing dir {}", (Object)entryDir.getName());
        File[] entries = entryDir.listFiles(this.entryFilter);
        if (entries != null && entries.length != 0) {
            LdifReader ldifReader = new LdifReader();
            for (File entry : entries) {
                LOG.debug("parsing ldif file {}", (Object)entry.getName());
                List<LdifEntry> ldifEntries = ldifReader.parseLdifFile(entry.getAbsolutePath());
                ldifReader.close();
                if (ldifEntries == null || ldifEntries.isEmpty()) continue;
                LdifEntry ldifEntry = ldifEntries.get(0);
                LOG.debug("Adding entry {}", ldifEntry);
                DefaultServerEntry serverEntry = new DefaultServerEntry(this.schemaManager, ldifEntry.getEntry());
                if (!serverEntry.containsAttribute("entryCSN")) {
                    serverEntry.put("entryCSN", defaultCSNFactory.newInstance().toString());
                }
                if (!serverEntry.containsAttribute("entryUUID")) {
                    serverEntry.put("entryUUID", UUID.randomUUID().toString());
                }
                this.wrappedPartition.getStore().add(serverEntry);
            }
        } else {
            return;
        }
        File[] dirs = entryDir.listFiles(this.dirFilter);
        if (dirs != null && dirs.length != 0) {
            for (File f : dirs) {
                this.loadEntries(f);
            }
        }
    }

    private File getFile(DN entryDn, boolean create) throws NamingException {
        File ldifFile;
        StringBuilder filePath = new StringBuilder();
        filePath.append(this.suffixDirectory).append(File.separator);
        DN baseDn = (DN)entryDn.getSuffix(this.suffix.size());
        for (int i = 0; i < baseDn.size() - 1; ++i) {
            String rdnFileName = this.getFileName(baseDn.getRdn(i));
            filePath.append(rdnFileName).append(File.separator);
        }
        String rdnFileName = this.getFileName(entryDn.getRdn()) + CONF_FILE_EXTN;
        String parentDir = filePath.toString();
        File dir = new File(parentDir);
        if (!dir.exists() && create) {
            dir.mkdir();
        }
        if ((ldifFile = new File(parentDir + rdnFileName)).exists() && create) {
            throw new NamingException(I18n.err(I18n.ERR_633, new Object[0]));
        }
        return ldifFile;
    }

    private String getFileName(RDN rdn) throws NamingException {
        String normAT = rdn.getAtav().getNormType();
        AttributeType at = this.schemaManager.lookupAttributeTypeRegistry(normAT);
        String atName = at.getName();
        String normValue = rdn.getAtav().getNormValue().getString();
        String fileName = atName + "=" + normValue;
        return this.getOSFileName(fileName);
    }

    private String getFileName(DN dn) throws NamingException {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (RDN rdn : dn.getRdns()) {
            String normAT = rdn.getAtav().getNormType();
            AttributeType at = this.schemaManager.lookupAttributeTypeRegistry(normAT);
            String atName = at.getName();
            String normValue = rdn.getAtav().getNormValue().getString();
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(",");
            }
            sb.append(atName).append("=").append(normValue);
        }
        return this.getOSFileName(sb.toString());
    }

    private String getOSFileName(String fileName) {
        if (SystemUtils.IS_OS_WINDOWS) {
            StringBuilder sb = new StringBuilder();
            block8: for (char c : fileName.toCharArray()) {
                switch (c) {
                    case '\u0000': 
                    case '\u0001': 
                    case '\u0002': 
                    case '\u0003': 
                    case '\u0004': 
                    case '\u0005': 
                    case '\u0006': 
                    case '\u0007': 
                    case '\b': 
                    case '\t': 
                    case '\n': 
                    case '\u000b': 
                    case '\f': 
                    case '\r': 
                    case '\u000e': 
                    case '\u000f': 
                    case '\u0010': 
                    case '\u0011': 
                    case '\u0012': 
                    case '\u0013': 
                    case '\u0014': 
                    case '\u0015': 
                    case '\u0016': 
                    case '\u0017': 
                    case '\u0018': 
                    case '\u0019': 
                    case '\u001a': 
                    case '\u001b': 
                    case '\u001c': 
                    case '\u001d': 
                    case '\u001e': 
                    case '\u001f': {
                        sb.append("\\").append(StringTools.dumpHex((byte)(c >> 4))).append(StringTools.dumpHex((byte)(c & 4)));
                        continue block8;
                    }
                    case ' ': 
                    case '\"': 
                    case '*': 
                    case '+': 
                    case '/': 
                    case ':': 
                    case '<': 
                    case '>': 
                    case '?': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '|': {
                        sb.append('\\').append(c);
                        continue block8;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            return sb.toString().toLowerCase();
        }
        StringBuilder sb = new StringBuilder();
        block9: for (char c : fileName.toCharArray()) {
            switch (c) {
                case '/': {
                    sb.append("\\/");
                    continue block9;
                }
                case '\u0000': {
                    sb.append("\\00");
                    continue block9;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString().toLowerCase();
    }

    private void add(Entry entry) throws Exception {
        FileWriter fw = new FileWriter(this.getFile(entry.getDn(), CREATE));
        fw.write(LdifUtils.convertEntryToLdif(entry));
        fw.close();
    }

    private boolean deleteFile(File file) {
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                this.deleteFile(f);
            }
            return file.delete();
        }
        return file.delete();
    }

    @Override
    public void addIndexOn(Index<? extends Object, ServerEntry, Long> index) throws Exception {
        this.wrappedPartition.addIndexOn(index);
    }

    @Override
    public int count() throws Exception {
        return this.wrappedPartition.count();
    }

    @Override
    public void destroy() throws Exception {
        this.wrappedPartition.destroy();
    }

    @Override
    public Index<String, ServerEntry, Long> getAliasIndex() {
        return this.wrappedPartition.getAliasIndex();
    }

    @Override
    public int getChildCount(Long id) throws Exception {
        return this.wrappedPartition.getChildCount(id);
    }

    @Override
    public String getEntryDn(Long id) throws Exception {
        return this.wrappedPartition.getEntryDn(id);
    }

    @Override
    public Long getEntryId(String dn) throws Exception {
        return (Long)this.wrappedPartition.getEntryId(dn);
    }

    @Override
    public String getEntryUpdn(Long id) throws Exception {
        return this.wrappedPartition.getEntryUpdn(id);
    }

    @Override
    public String getEntryUpdn(String dn) throws Exception {
        return this.wrappedPartition.getEntryUpdn(dn);
    }

    @Override
    public Index<String, ServerEntry, Long> getNdnIndex() {
        return this.wrappedPartition.getNdnIndex();
    }

    @Override
    public Index<Long, ServerEntry, Long> getOneAliasIndex() {
        return this.wrappedPartition.getOneAliasIndex();
    }

    @Override
    public Index<Long, ServerEntry, Long> getOneLevelIndex() {
        return this.wrappedPartition.getOneLevelIndex();
    }

    @Override
    public Long getParentId(Long childId) throws Exception {
        return this.wrappedPartition.getParentId(childId);
    }

    @Override
    public Long getParentId(String dn) throws Exception {
        return (Long)((Object)this.wrappedPartition.getParentId(dn));
    }

    @Override
    public Index<String, ServerEntry, Long> getPresenceIndex() {
        return this.wrappedPartition.getPresenceIndex();
    }

    @Override
    public String getProperty(String propertyName) throws Exception {
        return this.wrappedPartition.getProperty(propertyName);
    }

    @Override
    public Index<Long, ServerEntry, Long> getSubAliasIndex() {
        return this.wrappedPartition.getSubAliasIndex();
    }

    @Override
    public Index<Long, ServerEntry, Long> getSubLevelIndex() {
        return this.wrappedPartition.getSubLevelIndex();
    }

    @Override
    public Index<?, ServerEntry, Long> getSystemIndex(String id) throws Exception {
        return this.wrappedPartition.getSystemIndex(id);
    }

    @Override
    public Iterator<String> getSystemIndices() {
        return this.wrappedPartition.getSystemIndices();
    }

    @Override
    public Index<String, ServerEntry, Long> getUpdnIndex() {
        return this.wrappedPartition.getUpdnIndex();
    }

    @Override
    public Index<? extends Object, ServerEntry, Long> getUserIndex(String id) throws Exception {
        return this.wrappedPartition.getUserIndex(id);
    }

    @Override
    public Iterator<String> getUserIndices() {
        return this.wrappedPartition.getUserIndices();
    }

    @Override
    public boolean hasSystemIndexOn(String id) throws Exception {
        return this.wrappedPartition.hasSystemIndexOn(id);
    }

    @Override
    public boolean hasUserIndexOn(String id) throws Exception {
        return this.wrappedPartition.hasUserIndexOn(id);
    }

    @Override
    public boolean isInitialized() {
        return this.wrappedPartition != null && this.wrappedPartition.isInitialized();
    }

    @Override
    public IndexCursor<Long, ServerEntry, Long> list(Long id) throws Exception {
        return this.wrappedPartition.list(id);
    }

    @Override
    public ClonedServerEntry lookup(Long id) throws Exception {
        return this.wrappedPartition.lookup(id);
    }

    @Override
    public void setAliasIndexOn(Index<String, ServerEntry, Long> index) throws Exception {
        this.wrappedPartition.setAliasIndexOn(index);
    }

    @Override
    public void setNdnIndexOn(Index<String, ServerEntry, Long> index) throws Exception {
        this.wrappedPartition.setNdnIndexOn(index);
    }

    @Override
    public void setOneAliasIndexOn(Index<Long, ServerEntry, Long> index) throws Exception {
        this.wrappedPartition.setOneAliasIndexOn(index);
    }

    @Override
    public void setOneLevelIndexOn(Index<Long, ServerEntry, Long> index) throws Exception {
        this.wrappedPartition.setOneLevelIndexOn(index);
    }

    @Override
    public void setPresenceIndexOn(Index<String, ServerEntry, Long> index) throws Exception {
        this.wrappedPartition.setPresenceIndexOn(index);
    }

    @Override
    public void setProperty(String propertyName, String propertyValue) throws Exception {
        this.wrappedPartition.setProperty(propertyName, propertyValue);
    }

    @Override
    public void setSchemaManager(SchemaManager schemaManager) {
        super.setSchemaManager(schemaManager);
    }

    @Override
    public void setSubAliasIndexOn(Index<Long, ServerEntry, Long> index) throws Exception {
        this.wrappedPartition.setSubAliasIndexOn(index);
    }

    @Override
    public void setUpdnIndexOn(Index<String, ServerEntry, Long> index) throws Exception {
        this.wrappedPartition.setUpdnIndexOn(index);
    }

    @Override
    public void sync() throws Exception {
        this.wrappedPartition.sync();
    }

    @Override
    public void unbind(UnbindOperationContext unbindContext) throws Exception {
        this.wrappedPartition.unbind(unbindContext);
    }

    @Override
    public String getId() {
        return super.getId();
    }

    @Override
    public void setId(String id) {
        super.setId(id);
        this.wrappedPartition.setId(id);
    }

    @Override
    public void setSuffix(String suffix) throws InvalidNameException {
        super.setSuffix(suffix);
        this.wrappedPartition.setSuffix(suffix);
    }

    public void setLdifScanInterval(int ldifScanInterval) {
        this.ldifScanInterval = ldifScanInterval;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public Entry getContextEntry() {
        return this.contextEntry;
    }

    public void setContextEntry(String contextEntry) throws NamingException {
        LdifReader ldifReader = new LdifReader();
        List<LdifEntry> entries = ldifReader.parseLdif(contextEntry);
        try {
            ldifReader.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        this.contextEntry = new DefaultServerEntry(this.schemaManager, entries.get(0).getEntry());
    }

    public Partition getWrappedPartition() {
        return this.wrappedPartition;
    }

    public void setWrappedPartition(AvlPartition wrappedPartition) {
        this.wrappedPartition = wrappedPartition;
    }
}

