/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import jdbm.RecordManager;
import jdbm.helper.MRU;
import jdbm.recman.BaseRecordManager;
import jdbm.recman.CacheRecordManager;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmIndex;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmMasterTable;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.IndexNotFoundException;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.shared.ldap.MultiException;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapNameNotFoundException;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.AVA;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.util.NamespaceTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbmStore<E>
implements Store<E, Long> {
    private static final Logger LOG = LoggerFactory.getLogger(JdbmStore.class);
    static final int DEFAULT_CACHE_SIZE = 10000;
    private RecordManager recMan;
    private DN normSuffix;
    private DN upSuffix;
    private File workingDirectory;
    private JdbmMasterTable<ServerEntry> master;
    private Map<String, Index<?, E, Long>> userIndices = new HashMap();
    private Map<String, Index<?, E, Long>> systemIndices = new HashMap();
    private boolean initialized;
    private boolean isSyncOnWrite = true;
    private JdbmIndex<String, E> ndnIdx;
    private JdbmIndex<String, E> updnIdx;
    private JdbmIndex<String, E> presenceIdx;
    private JdbmIndex<String, E> aliasIdx;
    private JdbmIndex<Long, E> subLevelIdx;
    private JdbmIndex<Long, E> oneLevelIdx;
    private JdbmIndex<Long, E> oneAliasIdx;
    private JdbmIndex<Long, E> subAliasIdx;
    private JdbmIndex<String, E> objectClassIdx;
    private JdbmIndex<String, E> entryCsnIdx;
    private JdbmIndex<String, E> entryUuidIdx;
    private static AttributeType OBJECT_CLASS_AT;
    private static AttributeType ENTRY_CSN_AT;
    private static AttributeType ENTRY_UUID_AT;
    private static AttributeType ALIASED_OBJECT_NAME_AT;
    private SchemaManager schemaManager;
    private String suffixDn;
    private int cacheSize = 10000;
    private String name;

    private void protect(String property) {
        if (this.initialized) {
            throw new IllegalStateException(I18n.err(I18n.ERR_576, property));
        }
    }

    @Override
    public void setWorkingDirectory(File workingDirectory) {
        this.protect("workingDirectory");
        this.workingDirectory = workingDirectory;
    }

    @Override
    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public void setSuffixDn(String suffixDn) {
        this.protect("suffixDn");
        this.suffixDn = suffixDn;
    }

    @Override
    public String getSuffixDn() {
        return this.suffixDn;
    }

    @Override
    public void setSyncOnWrite(boolean isSyncOnWrite) {
        this.protect("syncOnWrite");
        this.isSyncOnWrite = isSyncOnWrite;
    }

    @Override
    public boolean isSyncOnWrite() {
        return this.isSyncOnWrite;
    }

    @Override
    public void setCacheSize(int cacheSize) {
        this.protect("cacheSize");
        this.cacheSize = cacheSize;
    }

    @Override
    public int getCacheSize() {
        return this.cacheSize;
    }

    @Override
    public void setName(String name) {
        this.protect("name");
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Long getDefaultId() {
        return 1L;
    }

    @Override
    public synchronized void init(SchemaManager schemaManager) throws Exception {
        this.schemaManager = schemaManager;
        OBJECT_CLASS_AT = schemaManager.lookupAttributeTypeRegistry("objectClass");
        ALIASED_OBJECT_NAME_AT = schemaManager.lookupAttributeTypeRegistry("aliasedObjectName");
        ENTRY_CSN_AT = schemaManager.lookupAttributeTypeRegistry("entryCSN");
        ENTRY_UUID_AT = schemaManager.lookupAttributeTypeRegistry("entryUUID");
        this.upSuffix = new DN(this.suffixDn);
        this.normSuffix = DN.normalize(this.upSuffix, schemaManager.getNormalizerMapping());
        this.workingDirectory.mkdirs();
        String path = this.workingDirectory.getPath() + File.separator + "master";
        BaseRecordManager base = new BaseRecordManager(path);
        base.disableTransactions();
        if (this.cacheSize < 0) {
            this.cacheSize = 10000;
            LOG.debug("Using the default entry cache size of {} for {} partition", this.cacheSize, (Object)this.name);
        } else {
            LOG.debug("Using the custom configured cache size of {} for {} partition", this.cacheSize, (Object)this.name);
        }
        this.recMan = new CacheRecordManager(base, new MRU(this.cacheSize));
        this.master = new JdbmMasterTable(this.recMan, schemaManager);
        this.setupSystemIndices();
        this.setupUserIndices();
        this.initialized = true;
    }

    private void setupSystemIndices() throws Exception {
        if (this.systemIndices.size() > 0) {
            HashMap tmp = new HashMap();
            for (Index<?, E, Long> index : this.systemIndices.values()) {
                String oid = this.schemaManager.getAttributeTypeRegistry().getOidByName(index.getAttributeId());
                tmp.put(oid, index);
                ((JdbmIndex)index).init(this.schemaManager, this.schemaManager.lookupAttributeTypeRegistry(oid), this.workingDirectory);
            }
            this.systemIndices = tmp;
        }
        if (this.ndnIdx == null) {
            this.ndnIdx = new JdbmIndex();
            this.ndnIdx.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.1");
            this.systemIndices.put("1.3.6.1.4.1.18060.0.4.1.2.1", this.ndnIdx);
            this.ndnIdx.init(this.schemaManager, this.schemaManager.lookupAttributeTypeRegistry("1.3.6.1.4.1.18060.0.4.1.2.1"), this.workingDirectory);
        }
        if (this.updnIdx == null) {
            this.updnIdx = new JdbmIndex();
            this.updnIdx.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.2");
            this.systemIndices.put("1.3.6.1.4.1.18060.0.4.1.2.2", this.updnIdx);
            this.updnIdx.init(this.schemaManager, this.schemaManager.lookupAttributeTypeRegistry("1.3.6.1.4.1.18060.0.4.1.2.2"), this.workingDirectory);
        }
        if (this.presenceIdx == null) {
            this.presenceIdx = new JdbmIndex();
            this.presenceIdx.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.3");
            this.systemIndices.put("1.3.6.1.4.1.18060.0.4.1.2.3", this.presenceIdx);
            this.presenceIdx.init(this.schemaManager, this.schemaManager.lookupAttributeTypeRegistry("1.3.6.1.4.1.18060.0.4.1.2.3"), this.workingDirectory);
        }
        if (this.oneLevelIdx == null) {
            this.oneLevelIdx = new JdbmIndex();
            this.oneLevelIdx.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.4");
            this.systemIndices.put("1.3.6.1.4.1.18060.0.4.1.2.4", this.oneLevelIdx);
            this.oneLevelIdx.init(this.schemaManager, this.schemaManager.lookupAttributeTypeRegistry("1.3.6.1.4.1.18060.0.4.1.2.4"), this.workingDirectory);
        }
        if (this.oneAliasIdx == null) {
            this.oneAliasIdx = new JdbmIndex();
            this.oneAliasIdx.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.5");
            this.systemIndices.put("1.3.6.1.4.1.18060.0.4.1.2.5", this.oneAliasIdx);
            this.oneAliasIdx.init(this.schemaManager, this.schemaManager.lookupAttributeTypeRegistry("1.3.6.1.4.1.18060.0.4.1.2.5"), this.workingDirectory);
        }
        if (this.subAliasIdx == null) {
            this.subAliasIdx = new JdbmIndex();
            this.subAliasIdx.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.6");
            this.systemIndices.put("1.3.6.1.4.1.18060.0.4.1.2.6", this.subAliasIdx);
            this.subAliasIdx.init(this.schemaManager, this.schemaManager.lookupAttributeTypeRegistry("1.3.6.1.4.1.18060.0.4.1.2.6"), this.workingDirectory);
        }
        if (this.aliasIdx == null) {
            this.aliasIdx = new JdbmIndex();
            this.aliasIdx.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.7");
            this.systemIndices.put("1.3.6.1.4.1.18060.0.4.1.2.7", this.aliasIdx);
            this.aliasIdx.init(this.schemaManager, this.schemaManager.lookupAttributeTypeRegistry("1.3.6.1.4.1.18060.0.4.1.2.7"), this.workingDirectory);
        }
        if (this.subLevelIdx == null) {
            this.subLevelIdx = new JdbmIndex();
            this.subLevelIdx.setAttributeId("1.3.6.1.4.1.18060.0.4.1.2.43");
            this.systemIndices.put("1.3.6.1.4.1.18060.0.4.1.2.43", this.subLevelIdx);
            this.subLevelIdx.init(this.schemaManager, this.schemaManager.lookupAttributeTypeRegistry("1.3.6.1.4.1.18060.0.4.1.2.43"), this.workingDirectory);
        }
        if (this.entryCsnIdx == null) {
            this.entryCsnIdx = new JdbmIndex();
            this.entryCsnIdx.setAttributeId("1.3.6.1.4.1.4203.666.1.7");
            this.systemIndices.put("1.3.6.1.4.1.4203.666.1.7", this.entryCsnIdx);
            this.entryCsnIdx.init(this.schemaManager, this.schemaManager.lookupAttributeTypeRegistry("1.3.6.1.4.1.4203.666.1.7"), this.workingDirectory);
        }
        if (this.entryUuidIdx == null) {
            this.entryUuidIdx = new JdbmIndex();
            this.entryUuidIdx.setAttributeId("1.3.6.1.1.16.4");
            this.systemIndices.put("1.3.6.1.1.16.4", this.entryUuidIdx);
            this.entryUuidIdx.init(this.schemaManager, this.schemaManager.lookupAttributeTypeRegistry("1.3.6.1.1.16.4"), this.workingDirectory);
        }
        if (this.objectClassIdx == null) {
            this.objectClassIdx = new JdbmIndex();
            this.objectClassIdx.setAttributeId("2.5.4.0");
            this.systemIndices.put("2.5.4.0", this.objectClassIdx);
            this.objectClassIdx.init(this.schemaManager, this.schemaManager.lookupAttributeTypeRegistry("2.5.4.0"), this.workingDirectory);
        }
    }

    private void setupUserIndices() throws Exception {
        if (this.userIndices != null && this.userIndices.size() > 0) {
            HashMap tmp = new HashMap();
            for (Index<?, E, Long> index : this.userIndices.values()) {
                String oid = this.schemaManager.getAttributeTypeRegistry().getOidByName(index.getAttributeId());
                if (this.systemIndices.containsKey(oid)) continue;
                AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(oid);
                MatchingRule mr = attributeType.getEquality();
                if (mr != null) {
                    ((JdbmIndex)index).init(this.schemaManager, this.schemaManager.lookupAttributeTypeRegistry(oid), this.workingDirectory);
                    tmp.put(oid, index);
                    continue;
                }
                LOG.error(I18n.err(I18n.ERR_4, attributeType.getName()));
            }
            this.userIndices = tmp;
        } else {
            this.userIndices = new HashMap();
        }
    }

    @Override
    public synchronized void destroy() throws Exception {
        LOG.debug("destroy() called on store for {}", (Object)this.suffixDn);
        if (!this.initialized) {
            return;
        }
        ArrayList array = new ArrayList();
        array.addAll(this.userIndices.values());
        array.addAll(this.systemIndices.values());
        MultiException errors = new MultiException(I18n.err(I18n.ERR_577, new Object[0]));
        for (Index index : array) {
            try {
                index.close();
                LOG.debug("Closed {} index for {} partition.", (Object)index.getAttributeId(), (Object)this.suffixDn);
            }
            catch (Throwable t) {
                LOG.error(I18n.err(I18n.ERR_124, new Object[0]), t);
                errors.addThrowable(t);
            }
        }
        try {
            this.master.close();
            LOG.debug(I18n.err(I18n.ERR_125, this.suffixDn));
        }
        catch (Throwable t) {
            LOG.error(I18n.err(I18n.ERR_126, new Object[0]), t);
            errors.addThrowable(t);
        }
        try {
            this.recMan.close();
            LOG.debug("Closed record manager for {} partition.", (Object)this.suffixDn);
        }
        catch (Throwable t) {
            LOG.error(I18n.err(I18n.ERR_127, new Object[0]), t);
            errors.addThrowable(t);
        }
        if (errors.size() > 0) {
            throw errors;
        }
        this.initialized = false;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public synchronized void sync() throws Exception {
        if (!this.initialized) {
            return;
        }
        ArrayList<Index<Object, Object, Long>> array = new ArrayList<Index<Object, Object, Long>>();
        array.addAll(this.userIndices.values());
        array.add(this.ndnIdx);
        array.add(this.updnIdx);
        array.add(this.aliasIdx);
        array.add(this.oneAliasIdx);
        array.add(this.subAliasIdx);
        array.add(this.oneLevelIdx);
        array.add(this.presenceIdx);
        array.add(this.subLevelIdx);
        array.add(this.entryCsnIdx);
        array.add(this.entryUuidIdx);
        array.add(this.objectClassIdx);
        for (Index index : array) {
            index.sync();
        }
        this.master.sync();
        this.recMan.commit();
    }

    private <K> JdbmIndex<K, E> convertIndex(Index<K, E, Long> index) {
        if (index instanceof JdbmIndex) {
            return (JdbmIndex)index;
        }
        LOG.warn("Supplied index {} is not a JdbmIndex.  Will create new JdbmIndex using copied configuration parameters.", index);
        JdbmIndex jdbmIndex = new JdbmIndex(index.getAttributeId());
        jdbmIndex.setCacheSize(index.getCacheSize());
        jdbmIndex.setNumDupLimit(512);
        jdbmIndex.setWkDirPath(index.getWkDirPath());
        return jdbmIndex;
    }

    @Override
    public void setUserIndices(Set<Index<?, E, Long>> userIndices) {
        this.protect("userIndices");
        for (Index<?, E, Long> index : userIndices) {
            this.userIndices.put(index.getAttributeId(), this.convertIndex(index));
        }
    }

    @Override
    public Set<Index<?, E, Long>> getUserIndices() {
        return new HashSet(this.userIndices.values());
    }

    @Override
    public void addIndex(Index<?, E, Long> index) throws Exception {
        this.userIndices.put(index.getAttributeId(), this.convertIndex(index));
    }

    @Override
    public Index<String, E, Long> getPresenceIndex() {
        return this.presenceIdx;
    }

    @Override
    public void setPresenceIndex(Index<String, E, Long> index) throws Exception {
        this.protect("presenceIndex");
        this.presenceIdx = this.convertIndex(index);
        this.systemIndices.put(index.getAttributeId(), this.presenceIdx);
    }

    @Override
    public Index<Long, E, Long> getOneLevelIndex() {
        return this.oneLevelIdx;
    }

    @Override
    public void setOneLevelIndex(Index<Long, E, Long> index) throws Exception {
        this.protect("hierarchyIndex");
        this.oneLevelIdx = this.convertIndex(index);
        this.systemIndices.put(index.getAttributeId(), this.oneLevelIdx);
    }

    @Override
    public Index<String, E, Long> getAliasIndex() {
        return this.aliasIdx;
    }

    @Override
    public void setAliasIndex(Index<String, E, Long> index) throws NamingException {
        this.protect("aliasIndex");
        this.aliasIdx = this.convertIndex(index);
        this.systemIndices.put(index.getAttributeId(), this.aliasIdx);
    }

    @Override
    public Index<Long, E, Long> getOneAliasIndex() {
        return this.oneAliasIdx;
    }

    @Override
    public void setOneAliasIndex(Index<Long, E, Long> index) throws NamingException {
        this.protect("oneAliasIndex");
        this.oneAliasIdx = this.convertIndex(index);
        this.systemIndices.put(index.getAttributeId(), this.oneAliasIdx);
    }

    @Override
    public Index<Long, E, Long> getSubAliasIndex() {
        return this.subAliasIdx;
    }

    @Override
    public void setSubAliasIndex(Index<Long, E, Long> index) throws NamingException {
        this.protect("subAliasIndex");
        this.subAliasIdx = this.convertIndex(index);
        this.systemIndices.put(index.getAttributeId(), this.subAliasIdx);
    }

    @Override
    public Index<String, E, Long> getUpdnIndex() {
        return this.updnIdx;
    }

    @Override
    public void setUpdnIndex(Index<String, E, Long> index) throws NamingException {
        this.protect("updnIndex");
        this.updnIdx = this.convertIndex(index);
        this.systemIndices.put(index.getAttributeId(), this.updnIdx);
    }

    @Override
    public Index<String, E, Long> getNdnIndex() {
        return this.ndnIdx;
    }

    @Override
    public void setNdnIndex(Index<String, E, Long> index) throws NamingException {
        this.protect("ndnIndex");
        this.ndnIdx = this.convertIndex(index);
        this.systemIndices.put(index.getAttributeId(), this.ndnIdx);
    }

    @Override
    public Index<Long, E, Long> getSubLevelIndex() {
        return this.subLevelIdx;
    }

    @Override
    public void setSubLevelIndex(Index<Long, E, Long> index) throws NamingException {
        this.protect("subLevelIndex");
        this.subLevelIdx = this.convertIndex(index);
        this.systemIndices.put(index.getAttributeId(), this.subLevelIdx);
    }

    @Override
    public Index<String, E, Long> getObjectClassIndex() {
        return this.objectClassIdx;
    }

    @Override
    public void setObjectClassIndex(Index<String, E, Long> index) throws NamingException {
        this.protect("objectClassIndex");
        this.objectClassIdx = this.convertIndex(index);
        this.systemIndices.put(index.getAttributeId(), this.objectClassIdx);
    }

    @Override
    public Index<String, E, Long> getEntryUuidIndex() {
        return this.entryUuidIdx;
    }

    @Override
    public void setEntryUuidIndex(Index<String, E, Long> index) throws NamingException {
        this.protect("entryUuidIndex");
        this.entryUuidIdx = this.convertIndex(index);
        this.systemIndices.put(index.getAttributeId(), this.entryUuidIdx);
    }

    @Override
    public Index<String, E, Long> getEntryCsnIndex() {
        return this.entryCsnIdx;
    }

    @Override
    public void setEntryCsnIndex(Index<String, E, Long> index) throws NamingException {
        this.protect("entryCsnIndex");
        this.entryCsnIdx = this.convertIndex(index);
        this.systemIndices.put(index.getAttributeId(), this.entryCsnIdx);
    }

    @Override
    public Iterator<String> userIndices() {
        return this.userIndices.keySet().iterator();
    }

    @Override
    public Iterator<String> systemIndices() {
        return this.systemIndices.keySet().iterator();
    }

    @Override
    public boolean hasIndexOn(String id) throws NamingException {
        return this.hasUserIndexOn(id) || this.hasSystemIndexOn(id);
    }

    @Override
    public boolean hasUserIndexOn(String id) throws NamingException {
        return this.userIndices.containsKey(this.schemaManager.getAttributeTypeRegistry().getOidByName(id));
    }

    @Override
    public boolean hasSystemIndexOn(String id) throws NamingException {
        return this.systemIndices.containsKey(this.schemaManager.getAttributeTypeRegistry().getOidByName(id));
    }

    @Override
    public Index<?, E, Long> getIndex(String id) throws IndexNotFoundException {
        try {
            id = this.schemaManager.getAttributeTypeRegistry().getOidByName(id);
        }
        catch (NamingException e) {
            String msg = I18n.err(I18n.ERR_128, id);
            LOG.error(msg, e);
            throw new IndexNotFoundException(msg, id, e);
        }
        if (this.userIndices.containsKey(id)) {
            return this.userIndices.get(id);
        }
        if (this.systemIndices.containsKey(id)) {
            return this.systemIndices.get(id);
        }
        throw new IndexNotFoundException(I18n.err(I18n.ERR_3, id, this.name));
    }

    @Override
    public Index<?, E, Long> getUserIndex(String id) throws IndexNotFoundException {
        try {
            id = this.schemaManager.getAttributeTypeRegistry().getOidByName(id);
        }
        catch (NamingException e) {
            String msg = I18n.err(I18n.ERR_128, id);
            LOG.error(msg, e);
            throw new IndexNotFoundException(msg, id, e);
        }
        if (this.userIndices.containsKey(id)) {
            return this.userIndices.get(id);
        }
        throw new IndexNotFoundException(I18n.err(I18n.ERR_3, id, this.name));
    }

    @Override
    public Index<?, E, Long> getSystemIndex(String id) throws IndexNotFoundException {
        try {
            id = this.schemaManager.getAttributeTypeRegistry().getOidByName(id);
        }
        catch (NamingException e) {
            String msg = I18n.err(I18n.ERR_128, id);
            LOG.error(msg, e);
            throw new IndexNotFoundException(msg, id, e);
        }
        if (this.systemIndices.containsKey(id)) {
            return this.systemIndices.get(id);
        }
        throw new IndexNotFoundException(I18n.err(I18n.ERR_2, id, this.name));
    }

    @Override
    public Long getEntryId(String dn) throws Exception {
        return this.ndnIdx.forwardLookup((Object)dn);
    }

    @Override
    public String getEntryDn(Long id) throws Exception {
        return this.ndnIdx.reverseLookup(id);
    }

    @Override
    public Long getParentId(String dn) throws Exception {
        Object childId = this.ndnIdx.forwardLookup((Object)dn);
        return this.oneLevelIdx.reverseLookup((Long)childId);
    }

    @Override
    public Long getParentId(Long childId) throws Exception {
        return this.oneLevelIdx.reverseLookup(childId);
    }

    @Override
    public String getEntryUpdn(Long id) throws Exception {
        return this.updnIdx.reverseLookup(id);
    }

    @Override
    public String getEntryUpdn(String dn) throws Exception {
        Object id = this.ndnIdx.forwardLookup((Object)dn);
        return this.updnIdx.reverseLookup((Long)id);
    }

    @Override
    public int count() throws Exception {
        return this.master.count();
    }

    private void dropAliasIndices(Long aliasId) throws Exception {
        String targetDn = this.aliasIdx.reverseLookup(aliasId);
        Long targetId = this.getEntryId(targetDn);
        String aliasDn = this.getEntryDn(aliasId);
        DN aliasDN = new DN(aliasDn);
        DN ancestorDn = (DN)aliasDN.clone();
        ancestorDn.remove(aliasDN.size() - 1);
        Long ancestorId = this.getEntryId(ancestorDn.toNormName());
        this.oneAliasIdx.drop(ancestorId, targetId);
        this.subAliasIdx.drop(ancestorId, targetId);
        while (!ancestorDn.equals(this.normSuffix) && ancestorDn.size() > this.normSuffix.size()) {
            ancestorDn = (DN)ancestorDn.getPrefix(ancestorDn.size() - 1);
            ancestorId = this.getEntryId(ancestorDn.toNormName());
            this.subAliasIdx.drop(ancestorId, targetId);
        }
        this.aliasIdx.drop(aliasId);
    }

    private void addAliasIndices(Long aliasId, DN aliasDn, String aliasTarget) throws Exception {
        DN normalizedAliasTargetDn = new DN(aliasTarget);
        normalizedAliasTargetDn.normalize(this.schemaManager.getNormalizerMapping());
        if (aliasDn.startsWith(normalizedAliasTargetDn)) {
            if (aliasDn.equals(normalizedAliasTargetDn)) {
                String msg = I18n.err(I18n.ERR_223, new Object[0]);
                ResultCodeEnum rc = ResultCodeEnum.ALIAS_DEREFERENCING_PROBLEM;
                LdapNamingException e = new LdapNamingException(msg, rc);
                e.setResolvedName(aliasDn);
                throw e;
            }
            String msg = I18n.err(I18n.ERR_224, aliasTarget, aliasDn);
            ResultCodeEnum rc = ResultCodeEnum.ALIAS_DEREFERENCING_PROBLEM;
            LdapNamingException e = new LdapNamingException(msg, rc);
            e.setResolvedName(aliasDn);
            throw e;
        }
        if (!normalizedAliasTargetDn.startsWith(this.normSuffix)) {
            String msg = I18n.err(I18n.ERR_225, this.upSuffix.getName());
            ResultCodeEnum rc = ResultCodeEnum.ALIAS_DEREFERENCING_PROBLEM;
            LdapNamingException e = new LdapNamingException(msg, rc);
            e.setResolvedName(aliasDn);
            throw e;
        }
        Object targetId = this.ndnIdx.forwardLookup((Object)normalizedAliasTargetDn.toNormName());
        if (null == targetId) {
            String msg = I18n.err(I18n.ERR_581, aliasDn.getName(), aliasTarget);
            ResultCodeEnum rc = ResultCodeEnum.ALIAS_PROBLEM;
            LdapNamingException e = new LdapNamingException(msg, rc);
            e.setResolvedName(aliasDn);
            throw e;
        }
        if (null != this.aliasIdx.reverseLookup((Long)targetId)) {
            String msg = I18n.err(I18n.ERR_227, new Object[0]);
            ResultCodeEnum rc = ResultCodeEnum.ALIAS_DEREFERENCING_PROBLEM;
            LdapNamingException e = new LdapNamingException(msg, rc);
            e.setResolvedName(aliasDn);
            throw e;
        }
        this.aliasIdx.add(normalizedAliasTargetDn.getNormName(), aliasId);
        DN ancestorDn = (DN)aliasDn.clone();
        ancestorDn.remove(aliasDn.size() - 1);
        Long ancestorId = this.getEntryId(ancestorDn.toNormName());
        DN normalizedAliasTargetParentDn = (DN)normalizedAliasTargetDn.clone();
        normalizedAliasTargetParentDn.remove(normalizedAliasTargetDn.size() - 1);
        if (!aliasDn.startsWith(normalizedAliasTargetParentDn)) {
            this.oneAliasIdx.add(ancestorId, (Long)targetId);
        }
        while (!ancestorDn.equals(this.normSuffix) && null != ancestorId) {
            if (!NamespaceTools.isDescendant(ancestorDn, normalizedAliasTargetDn)) {
                this.subAliasIdx.add(ancestorId, (Long)targetId);
            }
            ancestorDn.remove(ancestorDn.size() - 1);
            ancestorId = this.getEntryId(ancestorDn.toNormName());
        }
    }

    @Override
    public synchronized void add(ServerEntry entry) throws Exception {
        Long parentId;
        if (entry instanceof ClonedServerEntry) {
            throw new Exception(I18n.err(I18n.ERR_215, new Object[0]));
        }
        Long id = this.master.getNextId();
        DN entryDn = entry.getDn();
        DN parentDn = null;
        if (entryDn.getNormName().equals(this.normSuffix.getNormName())) {
            parentId = 0L;
        } else {
            parentDn = (DN)entryDn.clone();
            parentDn.remove(parentDn.size() - 1);
            parentId = this.getEntryId(parentDn.getNormName());
        }
        if (parentId == null) {
            throw new LdapNameNotFoundException(I18n.err(I18n.ERR_216, parentDn));
        }
        EntryAttribute objectClass = entry.get(OBJECT_CLASS_AT);
        if (objectClass == null) {
            String msg = I18n.err(I18n.ERR_217, entryDn.getName(), entry);
            ResultCodeEnum rc = ResultCodeEnum.OBJECT_CLASS_VIOLATION;
            LdapSchemaViolationException e = new LdapSchemaViolationException(msg, rc);
            e.setResolvedName(entryDn);
            throw e;
        }
        for (Value value : objectClass) {
            this.objectClassIdx.add(value.getString(), id);
        }
        if (objectClass.contains("alias")) {
            EntryAttribute aliasAttr = entry.get(ALIASED_OBJECT_NAME_AT);
            this.addAliasIndices(id, entryDn, aliasAttr.getString());
        }
        if (!Character.isDigit(entryDn.toNormName().charAt(0))) {
            throw new IllegalStateException(I18n.err(I18n.ERR_218, entryDn.toNormName()));
        }
        this.ndnIdx.add(entryDn.toNormName(), id);
        this.updnIdx.add(entryDn.getName(), id);
        this.oneLevelIdx.add(parentId, id);
        EntryAttribute entryCsn = entry.get(ENTRY_CSN_AT);
        if (entryCsn == null) {
            String msg = I18n.err(I18n.ERR_219, entryDn.getName(), entry);
            throw new LdapSchemaViolationException(msg, ResultCodeEnum.OBJECT_CLASS_VIOLATION);
        }
        this.entryCsnIdx.add(entryCsn.getString(), id);
        EntryAttribute entryUuid = entry.get(ENTRY_UUID_AT);
        if (entryUuid == null) {
            String msg = I18n.err(I18n.ERR_220, entryDn.getName(), entry);
            throw new LdapSchemaViolationException(msg, ResultCodeEnum.OBJECT_CLASS_VIOLATION);
        }
        this.entryUuidIdx.add(entryUuid.getString(), id);
        Long tempId = parentId;
        while (tempId != null && tempId != 0L && tempId != 1L) {
            this.subLevelIdx.add(tempId, id);
            tempId = this.getParentId(tempId);
        }
        this.subLevelIdx.add(id, id);
        for (EntryAttribute attribute : entry) {
            String attributeOid = ((ServerAttribute)attribute).getAttributeType().getOid();
            if (!this.hasUserIndexOn(attributeOid)) continue;
            Index<?, E, Long> idx = this.getUserIndex(attributeOid);
            for (Value value : attribute) {
                idx.add(value.get(), id);
            }
            this.presenceIdx.add(attributeOid, id);
        }
        this.master.put(id, entry);
        if (this.isSyncOnWrite) {
            this.sync();
        }
    }

    @Override
    public ServerEntry lookup(Long id) throws Exception {
        return this.master.get(id);
    }

    @Override
    public synchronized void delete(Long id) throws Exception {
        ServerEntry entry = this.lookup(id);
        Long parentId = this.getParentId(id);
        EntryAttribute objectClass = entry.get(OBJECT_CLASS_AT);
        if (objectClass.contains("alias")) {
            this.dropAliasIndices(id);
        }
        for (Value value : objectClass) {
            this.objectClassIdx.drop(value.getString(), id);
        }
        this.ndnIdx.drop(id);
        this.updnIdx.drop(id);
        this.oneLevelIdx.drop(id);
        this.entryCsnIdx.drop(id);
        this.entryUuidIdx.drop(id);
        if (id != 1L) {
            this.subLevelIdx.drop(id);
        }
        if (!parentId.equals(0L)) {
            this.oneLevelIdx.drop(parentId, id);
        }
        for (EntryAttribute attribute : entry) {
            String attributeOid = ((ServerAttribute)attribute).getAttributeType().getOid();
            if (!this.hasUserIndexOn(attributeOid)) continue;
            Index<?, E, Long> index = this.getUserIndex(attributeOid);
            for (Value value : attribute) {
                ((JdbmIndex)index).drop(value.get(), id);
            }
            this.presenceIdx.drop(attributeOid, id);
        }
        this.master.delete(id);
        if (this.isSyncOnWrite) {
            this.sync();
        }
    }

    @Override
    public IndexCursor<Long, E, Long> list(Long id) throws Exception {
        IndexCursor<Long, E, Long> cursor = this.oneLevelIdx.forwardCursor(id);
        cursor.beforeValue(id, null);
        return cursor;
    }

    @Override
    public int getChildCount(Long id) throws Exception {
        return this.oneLevelIdx.count(id);
    }

    @Override
    public DN getSuffix() {
        return this.normSuffix;
    }

    @Override
    public DN getUpSuffix() {
        return this.upSuffix;
    }

    @Override
    public void setProperty(String propertyName, String propertyValue) throws Exception {
        this.master.setProperty(propertyName, propertyValue);
    }

    @Override
    public String getProperty(String propertyName) throws Exception {
        return this.master.getProperty(propertyName);
    }

    private void add(Long id, ServerEntry entry, EntryAttribute mods) throws Exception {
        if (entry instanceof ClonedServerEntry) {
            throw new Exception(I18n.err(I18n.ERR_215, new Object[0]));
        }
        String modsOid = this.schemaManager.getAttributeTypeRegistry().getOidByName(mods.getId());
        if (modsOid.equals("2.5.4.0")) {
            for (Value value : mods) {
                this.objectClassIdx.drop(value.getString(), id);
            }
        } else if (this.hasUserIndexOn(modsOid)) {
            Index<?, E, Long> index = this.getUserIndex(modsOid);
            for (Value value : mods) {
                ((JdbmIndex)index).add(value.get(), id);
            }
            if (!this.presenceIdx.forward(modsOid, id)) {
                this.presenceIdx.add(modsOid, id);
            }
        }
        AttributeType type = this.schemaManager.lookupAttributeTypeRegistry(modsOid);
        for (Value value : mods) {
            entry.add(type, value);
        }
        if (modsOid.equals("2.5.4.1")) {
            String ndnStr = this.ndnIdx.reverseLookup(id);
            this.addAliasIndices(id, new DN(ndnStr), mods.getString());
        }
    }

    private void remove(Long id, ServerEntry entry, EntryAttribute mods) throws Exception {
        if (entry instanceof ClonedServerEntry) {
            throw new Exception(I18n.err(I18n.ERR_215, new Object[0]));
        }
        String modsOid = this.schemaManager.getAttributeTypeRegistry().getOidByName(mods.getId());
        if (modsOid.equals("2.5.4.0")) {
            for (Value value : mods) {
                this.objectClassIdx.drop(value.getString(), id);
            }
        } else if (this.hasUserIndexOn(modsOid)) {
            Index<?, E, Long> index = this.getUserIndex(modsOid);
            for (Value value : mods) {
                ((JdbmIndex)index).drop(value.get(), id);
            }
            if (null == index.reverseLookup(id)) {
                this.presenceIdx.drop(modsOid, id);
            }
        }
        AttributeType attrType = this.schemaManager.lookupAttributeTypeRegistry(modsOid);
        if (mods.size() == 0) {
            entry.removeAttributes(attrType);
        } else {
            EntryAttribute entryAttr = entry.get(attrType);
            for (Value value : mods) {
                entryAttr.remove(value);
            }
            if (entryAttr.size() == 0) {
                entry.removeAttributes(entryAttr.getId());
            }
        }
        if (modsOid.equals("2.5.4.1")) {
            this.dropAliasIndices(id);
        }
    }

    private void replace(Long id, ServerEntry entry, EntryAttribute mods) throws Exception {
        String aliasAttributeOid;
        if (entry instanceof ClonedServerEntry) {
            throw new Exception(I18n.err(I18n.ERR_215, new Object[0]));
        }
        String modsOid = this.schemaManager.getAttributeTypeRegistry().getOidByName(mods.getId());
        if (modsOid.equals("2.5.4.0")) {
            if (this.objectClassIdx.reverse(id)) {
                this.objectClassIdx.drop(id);
            }
            for (Value value : mods) {
                this.objectClassIdx.add(value.getString(), id);
            }
        } else if (this.hasUserIndexOn(modsOid)) {
            Index<?, E, Long> index = this.getUserIndex(modsOid);
            if (index.reverse(id)) {
                ((JdbmIndex)index).drop(id);
            }
            for (Value value : mods) {
                ((JdbmIndex)index).add(value.get(), id);
            }
            if (null == index.reverseLookup(id)) {
                this.presenceIdx.drop(modsOid, id);
            }
        }
        if (modsOid.equals(aliasAttributeOid = this.schemaManager.getAttributeTypeRegistry().getOidByName("aliasedObjectName"))) {
            this.dropAliasIndices(id);
        }
        if (mods.size() > 0) {
            entry.put(mods);
        } else {
            entry.remove(mods);
        }
        if (modsOid.equals(aliasAttributeOid) && mods.size() > 0) {
            String ndnStr = this.ndnIdx.reverseLookup(id);
            this.addAliasIndices(id, new DN(ndnStr), mods.getString());
        }
    }

    @Override
    public void modify(DN dn, ModificationOperation modOp, ServerEntry mods) throws Exception {
        if (mods instanceof ClonedServerEntry) {
            throw new Exception(I18n.err(I18n.ERR_215, new Object[0]));
        }
        Long id = this.getEntryId(dn.getNormName());
        ServerEntry entry = this.master.get(id);
        block5: for (AttributeType attributeType : mods.getAttributeTypes()) {
            EntryAttribute attr = mods.get(attributeType);
            switch (modOp) {
                case ADD_ATTRIBUTE: {
                    this.add(id, entry, attr);
                    continue block5;
                }
                case REMOVE_ATTRIBUTE: {
                    this.remove(id, entry, attr);
                    continue block5;
                }
                case REPLACE_ATTRIBUTE: {
                    this.replace(id, entry, attr);
                    continue block5;
                }
            }
            throw new NamingException(I18n.err(I18n.ERR_221, new Object[0]));
        }
        this.master.put(id, entry);
        if (this.isSyncOnWrite) {
            this.sync();
        }
    }

    @Override
    public void modify(DN dn, List<Modification> mods) throws Exception {
        Long id = this.getEntryId(dn.getNormName());
        ServerEntry entry = this.master.get(id);
        block5: for (Modification mod : mods) {
            ServerAttribute attrMods = (ServerAttribute)mod.getAttribute();
            switch (mod.getOperation()) {
                case ADD_ATTRIBUTE: {
                    this.add(id, entry, attrMods);
                    continue block5;
                }
                case REMOVE_ATTRIBUTE: {
                    this.remove(id, entry, attrMods);
                    continue block5;
                }
                case REPLACE_ATTRIBUTE: {
                    this.replace(id, entry, attrMods);
                    continue block5;
                }
            }
            throw new NamingException(I18n.err(I18n.ERR_221, new Object[0]));
        }
        this.master.put(id, entry);
        if (this.isSyncOnWrite) {
            this.sync();
        }
    }

    @Override
    public void rename(DN dn, RDN newRdn, boolean deleteOldRdn) throws Exception {
        Long id = this.getEntryId(dn.getNormName());
        ServerEntry entry = this.lookup(id);
        DN updn = entry.getDn();
        for (AVA newAtav : newRdn) {
            String newNormType = newAtav.getNormType();
            Object newNormValue = newAtav.getNormValue().get();
            AttributeType newRdnAttrType = this.schemaManager.lookupAttributeTypeRegistry(newNormType);
            entry.add(newRdnAttrType, newAtav.getUpValue());
            if (!this.hasUserIndexOn(newNormType)) continue;
            Index<?, E, Long> index = this.getUserIndex(newNormType);
            ((JdbmIndex)index).add(newNormValue, id);
            if (this.presenceIdx.forward(newNormType, id)) continue;
            this.presenceIdx.add(newNormType, id);
        }
        if (deleteOldRdn) {
            RDN oldRdn = updn.getRdn();
            for (AVA oldAtav : oldRdn) {
                boolean mustRemove = true;
                for (AVA newAtav : newRdn) {
                    if (!oldAtav.equals(newAtav)) continue;
                    mustRemove = false;
                    break;
                }
                if (!mustRemove) continue;
                String oldNormType = oldAtav.getNormType();
                String oldNormValue = oldAtav.getNormValue().getString();
                AttributeType oldRdnAttrType = this.schemaManager.lookupAttributeTypeRegistry(oldNormType);
                entry.remove(oldRdnAttrType, oldNormValue);
                if (!this.hasUserIndexOn(oldNormType)) continue;
                Index<?, E, Long> index = this.getUserIndex(oldNormType);
                ((JdbmIndex)index).drop(oldNormValue, id);
                if (null != index.reverseLookup(id)) continue;
                this.presenceIdx.drop(oldNormType, id);
            }
        }
        DN newUpdn = (DN)updn.clone();
        newUpdn.remove(newUpdn.size() - 1);
        newUpdn.add(newRdn.getUpName());
        newUpdn.normalize(this.schemaManager.getNormalizerMapping());
        this.modifyDn(id, newUpdn, false);
        entry.setDn(newUpdn);
        this.master.put(id, entry);
        if (this.isSyncOnWrite) {
            this.sync();
        }
    }

    private void modifyDn(Long id, DN updn, boolean isMove) throws Exception {
        String aliasTarget;
        this.ndnIdx.drop(id);
        if (!updn.isNormalized()) {
            updn.normalize(this.schemaManager.getNormalizerMapping());
        }
        this.ndnIdx.add(updn.toNormName(), id);
        this.updnIdx.drop(id);
        this.updnIdx.add(updn.getName(), id);
        if (isMove && null != (aliasTarget = this.aliasIdx.reverseLookup(id))) {
            this.addAliasIndices(id, new DN(this.getEntryDn(id)), aliasTarget);
        }
        IndexCursor<Long, E, Long> children = this.list(id);
        while (children.next()) {
            IndexEntry rec = (IndexEntry)children.get();
            Long childId = (Long)rec.getId();
            DN childUpdn = (DN)updn.clone();
            DN oldUpdn = new DN(this.getEntryUpdn(childId));
            String rdn = oldUpdn.get(oldUpdn.size() - 1);
            DN rdnDN = new DN(rdn);
            rdnDN.normalize(this.schemaManager.getNormalizerMapping());
            childUpdn.add(rdnDN.getRdn());
            ServerEntry entry = this.lookup(childId);
            entry.setDn(childUpdn);
            this.master.put(childId, entry);
            this.modifyDn(childId, childUpdn, isMove);
        }
        children.close();
    }

    @Override
    public void move(DN oldChildDn, DN newParentDn, RDN newRdn, boolean deleteOldRdn) throws Exception {
        Long childId = this.getEntryId(oldChildDn.getNormName());
        this.rename(oldChildDn, newRdn, deleteOldRdn);
        DN newUpdn = this.move(oldChildDn, childId, newParentDn);
        ServerEntry entry = this.lookup(childId);
        entry.setDn(newUpdn);
        this.master.put(childId, entry);
        if (this.isSyncOnWrite) {
            this.sync();
        }
    }

    @Override
    public void move(DN oldChildDn, DN newParentDn) throws Exception {
        Long childId = this.getEntryId(oldChildDn.getNormName());
        DN newUpdn = this.move(oldChildDn, childId, newParentDn);
        ServerEntry entry = this.lookup(childId);
        entry.setDn(newUpdn);
        this.master.put(childId, entry);
        if (this.isSyncOnWrite) {
            this.sync();
        }
    }

    private DN move(DN oldChildDn, Long childId, DN newParentDn) throws Exception {
        Long newParentId = this.getEntryId(newParentDn.getNormName());
        Long oldParentId = this.getParentId(childId);
        this.dropMovedAliasIndices(oldChildDn);
        this.oneLevelIdx.drop(oldParentId, childId);
        this.oneLevelIdx.add(newParentId, childId);
        this.updateSubLevelIndex(childId, oldParentId, newParentId);
        DN childUpdn = new DN(this.getEntryUpdn(childId));
        String childRdn = childUpdn.get(childUpdn.size() - 1);
        DN newUpdn = new DN(this.getEntryUpdn(newParentId));
        newUpdn.add(newUpdn.size(), childRdn);
        this.modifyDn(childId, newUpdn, true);
        return newUpdn;
    }

    private void updateSubLevelIndex(Long childId, Long oldParentId, Long newParentId) throws Exception {
        Long tempId = oldParentId;
        ArrayList<Long> parentIds = new ArrayList<Long>();
        while (tempId != 0L && tempId != 1L && tempId != null) {
            parentIds.add(tempId);
            tempId = this.getParentId(tempId);
        }
        IndexCursor<Long, E, Long> cursor = this.subLevelIdx.forwardCursor(childId);
        ArrayList<Long> childIds = new ArrayList<Long>();
        childIds.add(childId);
        while (cursor.next()) {
            childIds.add((Long)((IndexEntry)cursor.get()).getId());
        }
        for (Long pid : parentIds) {
            for (Long cid : childIds) {
                this.subLevelIdx.drop(pid, cid);
            }
        }
        parentIds.clear();
        tempId = newParentId;
        while (tempId != 0L && tempId != 1L && tempId != null) {
            parentIds.add(tempId);
            tempId = this.getParentId(tempId);
        }
        for (Long id : parentIds) {
            for (Long cid : childIds) {
                this.subLevelIdx.add(id, cid);
            }
        }
    }

    private void dropMovedAliasIndices(DN movedBase) throws Exception {
        Long movedBaseId = this.getEntryId(movedBase.getNormName());
        if (this.aliasIdx.reverseLookup(movedBaseId) != null) {
            this.dropAliasIndices(movedBaseId, movedBase);
        }
    }

    private void dropAliasIndices(Long aliasId, DN movedBase) throws Exception {
        String targetDn = this.aliasIdx.reverseLookup(aliasId);
        Long targetId = this.getEntryId(targetDn);
        String aliasDn = this.getEntryDn(aliasId);
        DN ancestorDn = (DN)movedBase.getPrefix(1);
        Long ancestorId = this.getEntryId(ancestorDn.getNormName());
        if (aliasDn.equals(movedBase.toString())) {
            this.oneAliasIdx.drop(ancestorId, targetId);
        }
        this.subAliasIdx.drop(ancestorId, targetId);
        while (!ancestorDn.equals(this.upSuffix)) {
            ancestorDn = (DN)ancestorDn.getPrefix(1);
            ancestorId = this.getEntryId(ancestorDn.getNormName());
            this.subAliasIdx.drop(ancestorId, targetId);
        }
    }

    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }
}

