/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.gui;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributesTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 3256443603340310841L;
    public static final String KEY_COL = "Keys";
    public static final String VAL_COL = "Values";
    private final transient ArrayList<Object> keyList;
    private final transient ArrayList<Object> valList;
    private final ServerEntry entry;
    private final Long id;
    private final String dn;
    private boolean isMutable = true;

    public AttributesTableModel(ServerEntry entry, Long id, String dn, boolean isMutable) {
        this.dn = dn;
        this.id = id;
        this.entry = entry;
        this.isMutable = isMutable;
        int rowCount = 0;
        for (EntryAttribute attribute : entry) {
            String attrId = attribute.getId();
            rowCount += entry.get(attrId).size();
        }
        this.keyList = new ArrayList(rowCount);
        this.valList = new ArrayList(rowCount);
        for (EntryAttribute attribute : entry) {
            String key = attribute.getId();
            for (Value value : attribute) {
                this.keyList.add(attribute.getId());
                this.valList.add(value.get());
            }
        }
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return KEY_COL;
        }
        if (col == 1) {
            return VAL_COL;
        }
        throw new RuntimeException(I18n.err(I18n.ERR_728, new Object[0]));
    }

    @Override
    public int getRowCount() {
        return this.keyList.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    public Class<String> getColumnClass(int c) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return this.isMutable;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.keyList.size()) {
            return "NULL";
        }
        if (this.getColumnName(col).equals(KEY_COL)) {
            return this.keyList.get(row);
        }
        if (this.getColumnName(col).equals(VAL_COL)) {
            return this.valList.get(row);
        }
        throw new RuntimeException(I18n.err(I18n.ERR_729, new Object[0]));
    }

    public void setValue(Object val, int row, int col) {
        ArrayList<Object> list = null;
        if (col > 1 || col < 0) {
            return;
        }
        list = col == 0 ? this.keyList : this.valList;
        if (row >= this.keyList.size()) {
            return;
        }
        list.set(row, val);
        this.fireTableCellUpdated(row, col);
    }

    public String getEntryDn() {
        return this.dn;
    }

    public Long getEntryId() {
        return this.id;
    }

    public void delete(int row) {
        if (row >= this.keyList.size() || row < 0) {
            return;
        }
        this.keyList.remove(row);
        this.valList.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public void insert(int row, Object key, Object val) {
        if (row >= this.keyList.size() || row < 0) {
            return;
        }
        this.keyList.add(row, key);
        this.valList.add(row, val);
        this.fireTableRowsInserted(row, row);
    }
}

