/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.normalization;

import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.filtering.BaseEntryFilteringCursor;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddContextPartitionOperationContext;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.GetMatchedNameOperationContext;
import org.apache.directory.server.core.interceptor.context.GetSuffixOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RemoveContextPartitionOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.normalization.FilterNormalizingVisitor;
import org.apache.directory.shared.ldap.cursor.EmptyCursor;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.name.AVA;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.normalizers.ConcreteNameComponentNormalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NormalizationInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(NormalizationInterceptor.class);
    private FilterNormalizingVisitor normVisitor;
    private SchemaManager schemaManager;

    public void init(DirectoryService directoryService) throws Exception {
        LOG.debug("Initialiazing the NormalizationInterceptor");
        this.schemaManager = directoryService.getSchemaManager();
        ConcreteNameComponentNormalizer ncn = new ConcreteNameComponentNormalizer(this.schemaManager);
        this.normVisitor = new FilterNormalizingVisitor(ncn, this.schemaManager);
    }

    public void destroy() {
    }

    public void add(NextInterceptor nextInterceptor, AddOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.schemaManager.getNormalizerMapping());
        opContext.getEntry().getDn().normalize(this.schemaManager.getNormalizerMapping());
        this.addRdnAttributesToEntry(opContext.getDn(), opContext.getEntry());
        nextInterceptor.add(opContext);
    }

    public void delete(NextInterceptor nextInterceptor, DeleteOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.schemaManager.getNormalizerMapping());
        nextInterceptor.delete(opContext);
    }

    public void modify(NextInterceptor nextInterceptor, ModifyOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.schemaManager.getNormalizerMapping());
        nextInterceptor.modify(opContext);
    }

    public void rename(NextInterceptor nextInterceptor, RenameOperationContext opContext) throws Exception {
        opContext.getNewRdn().normalize(this.schemaManager.getNormalizerMapping());
        opContext.getDn().normalize(this.schemaManager.getNormalizerMapping());
        opContext.getNewDn().normalize(this.schemaManager.getNormalizerMapping());
        nextInterceptor.rename(opContext);
    }

    public void move(NextInterceptor nextInterceptor, MoveOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.schemaManager.getNormalizerMapping());
        opContext.getParent().normalize(this.schemaManager.getNormalizerMapping());
        nextInterceptor.move(opContext);
    }

    public void moveAndRename(NextInterceptor nextInterceptor, MoveAndRenameOperationContext opContext) throws Exception {
        DN rdn = new DN();
        rdn.add(opContext.getNewRdn());
        rdn.normalize(this.schemaManager.getNormalizerMapping());
        opContext.setNewRdn(rdn.getRdn());
        opContext.getDn().normalize(this.schemaManager.getNormalizerMapping());
        opContext.getParent().normalize(this.schemaManager.getNormalizerMapping());
        nextInterceptor.moveAndRename(opContext);
    }

    public EntryFilteringCursor search(NextInterceptor nextInterceptor, SearchOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.schemaManager.getNormalizerMapping());
        ExprNode filter = opContext.getFilter();
        ExprNode result = (ExprNode)filter.accept(this.normVisitor);
        if (result == null) {
            LOG.warn("undefined filter based on undefined attributeType not evaluted at all.  Returning empty enumeration.");
            return new BaseEntryFilteringCursor(new EmptyCursor<ServerEntry>(), opContext);
        }
        opContext.setFilter(result);
        return nextInterceptor.search(opContext);
    }

    public boolean hasEntry(NextInterceptor nextInterceptor, EntryOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.schemaManager.getNormalizerMapping());
        return nextInterceptor.hasEntry(opContext);
    }

    public EntryFilteringCursor list(NextInterceptor nextInterceptor, ListOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.schemaManager.getNormalizerMapping());
        return nextInterceptor.list(opContext);
    }

    private String[] normalizeAttrsId(String[] attrIds) throws Exception {
        if (attrIds == null) {
            return attrIds;
        }
        String[] normalizedAttrIds = new String[attrIds.length];
        int pos = 0;
        for (String id : attrIds) {
            String oid = this.schemaManager.lookupAttributeTypeRegistry(id).getOid();
            normalizedAttrIds[pos++] = oid;
        }
        return normalizedAttrIds;
    }

    public ClonedServerEntry lookup(NextInterceptor nextInterceptor, LookupOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.schemaManager.getNormalizerMapping());
        if (opContext.getAttrsId() != null) {
            opContext.setAttrsId(this.normalizeAttrsId(opContext.getAttrsIdArray()));
        }
        return nextInterceptor.lookup(opContext);
    }

    public DN getMatchedName(NextInterceptor nextInterceptor, GetMatchedNameOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.schemaManager.getNormalizerMapping());
        return nextInterceptor.getMatchedName(opContext);
    }

    public DN getSuffix(NextInterceptor nextInterceptor, GetSuffixOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.schemaManager.getNormalizerMapping());
        return nextInterceptor.getSuffix(opContext);
    }

    public boolean compare(NextInterceptor next, CompareOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.schemaManager.getNormalizerMapping());
        AttributeType at = opContext.getSession().getDirectoryService().getSchemaManager().lookupAttributeTypeRegistry(opContext.getOid());
        if (at.getSyntax().isHumanReadable() && opContext.getValue().isBinary()) {
            String value = opContext.getValue().getString();
            opContext.setValue(new ClientStringValue(value));
        }
        return next.compare(opContext);
    }

    public void bind(NextInterceptor next, BindOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.schemaManager.getNormalizerMapping());
        next.bind(opContext);
    }

    public void addContextPartition(NextInterceptor next, AddContextPartitionOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.schemaManager.getNormalizerMapping());
        next.addContextPartition(opContext);
    }

    public void removeContextPartition(NextInterceptor next, RemoveContextPartitionOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.schemaManager.getNormalizerMapping());
        next.removeContextPartition(opContext);
    }

    private void addRdnAttributesToEntry(DN dn, ServerEntry entry) throws Exception {
        if (dn == null || entry == null) {
            return;
        }
        RDN rdn = dn.getRdn();
        for (AVA ava : rdn) {
            Value<?> value = ava.getNormValue();
            Value<?> upValue = ava.getUpValue();
            String upId = ava.getUpType();
            if (entry.contains(upId, value)) continue;
            String message = "The RDN '" + upId + "=" + upValue + "' is not present in the entry";
            LOG.warn(message);
            if (!entry.containsAttribute(upId)) {
                entry.add(upId, upValue);
                continue;
            }
            AttributeType at = this.schemaManager.lookupAttributeTypeRegistry(upId);
            if (at.isSingleValued()) {
                entry.removeAttributes(upId);
                entry.add(upId, upValue);
                continue;
            }
            entry.add(upId, upValue);
        }
    }
}

