/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.event;

import javax.naming.NamingException;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.event.Evaluator;
import org.apache.directory.server.core.event.ScopeEvaluator;
import org.apache.directory.server.core.event.SubstringEvaluator;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.filter.ApproximateNode;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.ExtensibleNode;
import org.apache.directory.shared.ldap.filter.GreaterEqNode;
import org.apache.directory.shared.ldap.filter.LessEqNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.ScopeNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.filter.SubstringNode;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.LdapComparator;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.SchemaManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeafEvaluator
implements Evaluator {
    private static final int EQUALITY_MATCH = 0;
    private static final int ORDERING_MATCH = 1;
    private static final int SUBSTRING_MATCH = 3;
    private SchemaManager schemaManager;
    private SubstringEvaluator substringEvaluator;
    private ScopeEvaluator scopeEvaluator;
    private static final boolean COMPARE_GREATER = true;
    private static final boolean COMPARE_LESSER = false;

    public LeafEvaluator(SchemaManager schemaManager, SubstringEvaluator substringEvaluator) {
        this.schemaManager = schemaManager;
        this.scopeEvaluator = new ScopeEvaluator();
        this.substringEvaluator = substringEvaluator;
    }

    public ScopeEvaluator getScopeEvaluator() {
        return this.scopeEvaluator;
    }

    public SubstringEvaluator getSubstringEvaluator() {
        return this.substringEvaluator;
    }

    @Override
    public boolean evaluate(ExprNode node, String dn, ServerEntry entry) throws NamingException {
        if (node instanceof ScopeNode) {
            return this.scopeEvaluator.evaluate(node, dn, entry);
        }
        if (node instanceof PresenceNode) {
            String attrId = ((PresenceNode)node).getAttribute();
            return this.evalPresence(attrId, entry);
        }
        if (node instanceof EqualityNode || node instanceof ApproximateNode) {
            return this.evalEquality((EqualityNode)node, entry);
        }
        if (node instanceof GreaterEqNode) {
            return this.evalGreaterOrLesser((GreaterEqNode)node, entry, true);
        }
        if (node instanceof LessEqNode) {
            return this.evalGreaterOrLesser((LessEqNode)node, entry, false);
        }
        if (node instanceof SubstringNode) {
            return this.substringEvaluator.evaluate(node, dn, entry);
        }
        if (node instanceof ExtensibleNode) {
            throw new NotImplementedException();
        }
        throw new NamingException(I18n.err(I18n.ERR_245, node));
    }

    private boolean evalGreaterOrLesser(SimpleNode<?> node, ServerEntry entry, boolean isGreaterOrLesser) throws NamingException {
        String attrId = node.getAttribute();
        AttributeType type = this.schemaManager.lookupAttributeTypeRegistry(attrId);
        EntryAttribute attr = entry.get(type);
        if (null == attr) {
            return false;
        }
        Normalizer normalizer = this.getNormalizer(attrId);
        LdapComparator<? super Object> comparator = this.getComparator(attrId);
        Value<?> filterValue = normalizer.normalize(node.getValue());
        if (isGreaterOrLesser) {
            for (Value value : attr) {
                Value<?> normValue = normalizer.normalize(value);
                if (0 < comparator.compare(normValue, filterValue)) continue;
                return true;
            }
        } else {
            for (Value value : attr) {
                Value<?> normValue = normalizer.normalize(value);
                if (0 > comparator.compare(normValue, filterValue)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean evalPresence(String attrId, ServerEntry entry) throws NamingException {
        if (entry == null) {
            return false;
        }
        return null != entry.get(attrId);
    }

    private boolean evalEquality(EqualityNode<?> node, ServerEntry entry) throws NamingException {
        Normalizer normalizer = this.getNormalizer(node.getAttribute());
        LdapComparator<? super Object> comparator = this.getComparator(node.getAttribute());
        EntryAttribute attr = entry.get(node.getAttribute());
        if (null == attr) {
            return false;
        }
        AttributeType at = this.schemaManager.lookupAttributeTypeRegistry(node.getAttribute());
        Value<String> value = null;
        value = at.getSyntax().isHumanReadable() ? (node.getValue().isBinary() ? new ClientStringValue(node.getValue().getString()) : node.getValue()) : node.getValue();
        if (attr.contains(value)) {
            return true;
        }
        Value<?> filterValue = normalizer.normalize(value);
        if (attr.contains(filterValue)) {
            return true;
        }
        for (Value val : attr) {
            Value<?> normValue = normalizer.normalize(val);
            if (0 != comparator.compare(normValue.get(), filterValue.get())) continue;
            return true;
        }
        return false;
    }

    private LdapComparator<? super Object> getComparator(String attrId) throws NamingException {
        MatchingRule mrule = this.getMatchingRule(attrId, 0);
        return mrule.getLdapComparator();
    }

    private Normalizer getNormalizer(String attrId) throws NamingException {
        MatchingRule mrule = this.getMatchingRule(attrId, 0);
        return mrule.getNormalizer();
    }

    private MatchingRule getMatchingRule(String attrId, int matchType) throws NamingException {
        MatchingRule mrule = null;
        AttributeType type = this.schemaManager.lookupAttributeTypeRegistry(attrId);
        switch (matchType) {
            case 0: {
                mrule = type.getEquality();
                break;
            }
            case 3: {
                mrule = type.getSubstring();
                break;
            }
            case 1: {
                mrule = type.getOrdering();
                break;
            }
            default: {
                throw new NamingException(I18n.err(I18n.ERR_246, matchType));
            }
        }
        if (mrule == null && matchType != 0) {
            mrule = type.getEquality();
        }
        return mrule;
    }
}

