/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.entry;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.naming.NamingException;
import javax.naming.directory.InvalidAttributeValueException;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerBinaryValue;
import org.apache.directory.server.core.entry.ServerStringValue;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.ldap.entry.AbstractValue;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientBinaryValue;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.entry.client.DefaultClientAttribute;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultServerAttribute
extends DefaultClientAttribute
implements ServerAttribute {
    public static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultServerAttribute.class);
    private AttributeType attributeType;

    private String getUpId(AttributeType at) {
        String atUpId = at.getName();
        if (atUpId == null) {
            atUpId = at.getOid();
        }
        return atUpId;
    }

    public DefaultServerAttribute(AttributeType attributeType, EntryAttribute attribute) {
        this.attributeType = attributeType;
        this.id = attribute.getId();
        this.upId = attribute.getUpId();
        if (attribute instanceof ServerAttribute) {
            this.isHR = attribute.isHR();
            for (Value value : attribute) {
                this.add(value.clone());
            }
        } else {
            this.isHR = attributeType.getSyntax().isHumanReadable();
            for (Value clientValue : attribute) {
                AbstractValue serverValue = null;
                if (clientValue instanceof ClientStringValue) {
                    serverValue = this.isHR.booleanValue() ? new ServerStringValue(attributeType, clientValue.getString()) : new ServerBinaryValue(attributeType, clientValue.getBytes());
                } else if (clientValue instanceof ClientBinaryValue) {
                    serverValue = this.isHR != false ? new ServerStringValue(attributeType, clientValue.getString()) : new ServerBinaryValue(attributeType, clientValue.getBytes());
                }
                this.add(serverValue);
            }
        }
    }

    public DefaultServerAttribute(AttributeType attributeType) {
        if (attributeType == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_92, new Object[0]));
        }
        this.setAttributeType(attributeType);
    }

    public DefaultServerAttribute(String upId, AttributeType attributeType) {
        if (attributeType == null) {
            String message = I18n.err(I18n.ERR_92, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        this.setAttributeType(attributeType);
        this.setUpId(upId);
    }

    public DefaultServerAttribute(AttributeType attributeType, Value<?> ... vals) {
        this(null, attributeType, vals);
    }

    public DefaultServerAttribute(String upId, AttributeType attributeType, Value<?> ... vals) {
        if (attributeType == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_92, new Object[0]));
        }
        this.setAttributeType(attributeType);
        this.setUpId(upId, attributeType);
        this.add(vals);
    }

    public DefaultServerAttribute(AttributeType attributeType, String ... vals) {
        this(null, attributeType, vals);
    }

    public DefaultServerAttribute(String upId, AttributeType attributeType, String ... vals) {
        if (attributeType == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_92, new Object[0]));
        }
        this.setAttributeType(attributeType);
        this.add(vals);
        this.setUpId(upId, attributeType);
    }

    public DefaultServerAttribute(AttributeType attributeType, byte[] ... vals) {
        this(null, attributeType, vals);
    }

    public DefaultServerAttribute(String upId, AttributeType attributeType, byte[] ... vals) {
        if (attributeType == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_92, new Object[0]));
        }
        this.setAttributeType(attributeType);
        this.add(vals);
        this.setUpId(upId, attributeType);
    }

    @Override
    public int add(byte[] ... vals) {
        if (!this.isHR.booleanValue()) {
            int nbAdded = 0;
            for (byte[] val : vals) {
                ServerBinaryValue value = new ServerBinaryValue(this.attributeType, val);
                try {
                    value.normalize();
                }
                catch (NamingException ne) {
                    LOG.error(I18n.err(I18n.ERR_93, new Object[]{val}));
                    return 0;
                }
                if (this.add(value) != 0) {
                    ++nbAdded;
                    continue;
                }
                LOG.error(I18n.err(I18n.ERR_94, new Object[]{val}));
            }
            return nbAdded;
        }
        return 0;
    }

    @Override
    public int add(String ... vals) {
        if (this.isHR.booleanValue()) {
            int nbAdded = 0;
            for (String val : vals) {
                ServerStringValue newValue = new ServerStringValue(this.attributeType, val);
                if (this.contains(newValue)) continue;
                if (this.add(newValue) != 0) {
                    ++nbAdded;
                    continue;
                }
                LOG.error(I18n.err(I18n.ERR_94, val));
            }
            return nbAdded;
        }
        return 0;
    }

    @Override
    public int add(Value<?> ... vals) {
        int nbAdded = 0;
        for (Value<?> val : vals) {
            String message;
            AbstractValue nullSV;
            if (this.attributeType.getSyntax().isHumanReadable()) {
                if (val == null || val.isNull()) {
                    nullSV = new ServerStringValue(this.attributeType, null);
                    if (this.values.contains(nullSV)) continue;
                    this.values.add(nullSV);
                    ++nbAdded;
                    continue;
                }
                if (val instanceof ServerStringValue) {
                    if (this.values.contains(val) || !this.values.add(val)) continue;
                    ++nbAdded;
                    continue;
                }
                if (val instanceof ClientStringValue) {
                    ServerStringValue serverStringValue = new ServerStringValue(this.attributeType, val.getString());
                    if (this.values.contains(serverStringValue) || !this.values.add(serverStringValue)) continue;
                    ++nbAdded;
                    continue;
                }
                message = I18n.err(I18n.ERR_95, new Object[0]);
                LOG.error(message);
                continue;
            }
            if (val == null) {
                nullSV = new ServerBinaryValue(this.attributeType, null);
                if (this.values.contains(nullSV)) continue;
                this.values.add(nullSV);
                ++nbAdded;
                continue;
            }
            if (val instanceof ClientBinaryValue) {
                ServerBinaryValue serverBinaryValue = new ServerBinaryValue(this.attributeType, val.getBytes());
                if (this.values.contains(serverBinaryValue) || !this.values.add(serverBinaryValue)) continue;
                ++nbAdded;
                continue;
            }
            if (val instanceof ServerBinaryValue) {
                if (this.values.contains(val) || !this.values.add(val)) continue;
                ++nbAdded;
                continue;
            }
            message = I18n.err(I18n.ERR_96, new Object[0]);
            LOG.error(message);
        }
        return nbAdded;
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public boolean contains(byte[] ... vals) {
        if (!this.isHR.booleanValue()) {
            for (byte[] val : vals) {
                ServerBinaryValue value = new ServerBinaryValue(this.attributeType, val);
                try {
                    value.normalize();
                }
                catch (NamingException ne) {
                    return false;
                }
                if (this.values.contains(value)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(String ... vals) {
        if (this.isHR.booleanValue()) {
            for (String val : vals) {
                ServerStringValue value = new ServerStringValue(this.attributeType, val);
                if (this.values.contains(value)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Value<?> ... vals) {
        if (this.isHR.booleanValue()) {
            for (Value<?> val : vals) {
                if (val instanceof ServerStringValue) {
                    if (this.values.contains(val)) continue;
                    return false;
                }
                if (val instanceof ClientStringValue) {
                    ServerStringValue serverValue = new ServerStringValue(this.attributeType, val.isNull() ? (String)null : val.getString());
                    if (this.values.contains(serverValue)) continue;
                    return false;
                }
                return false;
            }
        } else {
            for (Value<?> val : vals) {
                if (val instanceof ClientBinaryValue) {
                    if (this.values.contains(val)) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    @Override
    public boolean instanceOf(String attributeId) throws InvalidAttributeValueException {
        String trimmedId = StringTools.trim(attributeId);
        if (StringTools.isEmpty(trimmedId)) {
            return false;
        }
        String normId = StringTools.lowerCaseAscii(trimmedId);
        for (String name : this.attributeType.getNames()) {
            if (!normId.equalsIgnoreCase(name)) continue;
            return true;
        }
        return normId.equalsIgnoreCase(this.attributeType.getOid());
    }

    @Override
    public boolean isValid() throws NamingException {
        if (this.attributeType.isSingleValued() && this.values.size() > 1) {
            return false;
        }
        if (this.values.size() == 0) {
            return this.attributeType.getSyntax().getSyntaxChecker().isValidSyntax(null);
        }
        for (Value value : this.values) {
            if (value.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean remove(byte[] ... vals) {
        if (this.isHR.booleanValue()) {
            return false;
        }
        boolean removed = true;
        for (byte[] val : vals) {
            ServerBinaryValue value = new ServerBinaryValue(this.attributeType, val);
            removed &= this.values.remove(value);
        }
        return removed;
    }

    @Override
    public boolean remove(String ... vals) {
        if (!this.isHR.booleanValue()) {
            return false;
        }
        boolean removed = true;
        for (String val : vals) {
            ServerStringValue value = new ServerStringValue(this.attributeType, val);
            removed &= this.values.remove(value);
        }
        return removed;
    }

    @Override
    public boolean remove(Value<?> ... vals) {
        boolean removed = true;
        if (this.isHR.booleanValue()) {
            for (Value<?> val : vals) {
                if (val instanceof ClientStringValue) {
                    ServerStringValue ssv = new ServerStringValue(this.attributeType, (String)val.get());
                    removed &= this.values.remove(ssv);
                    continue;
                }
                if (val instanceof ServerStringValue) {
                    removed &= this.values.remove(val);
                    continue;
                }
                removed = false;
            }
        } else {
            for (Value<?> val : vals) {
                if (val instanceof ClientBinaryValue) {
                    ServerBinaryValue sbv = new ServerBinaryValue(this.attributeType, (byte[])val.get());
                    removed &= this.values.remove(sbv);
                    continue;
                }
                if (val instanceof ServerBinaryValue) {
                    removed &= this.values.remove(val);
                    continue;
                }
                removed = false;
            }
        }
        return removed;
    }

    @Override
    public void setAttributeType(AttributeType attributeType) {
        if (attributeType == null) {
            throw new IllegalArgumentException("The AttributeType parameter should not be null");
        }
        this.attributeType = attributeType;
        this.setUpId(null, attributeType);
        this.isHR = attributeType.getSyntax().isHumanReadable() ? Boolean.valueOf(true) : Boolean.valueOf(false);
    }

    @Override
    public void setHR(boolean isHR) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setId(String id) {
        if (StringTools.isEmpty(StringTools.trim(id))) throw new IllegalArgumentException(I18n.err(I18n.ERR_459, new Object[0]));
        if (this.attributeType.getName() == null) {
            if (!OID.isOID(id) || !this.attributeType.getOid().equals(id)) return;
            super.setId(id);
            return;
        } else {
            String normId = StringTools.lowerCaseAscii(StringTools.trim(id));
            for (String atName : this.attributeType.getNames()) {
                if (!atName.equalsIgnoreCase(normId)) continue;
                super.setId(normId);
                return;
            }
            if (!OID.isOID(normId) || !this.attributeType.getOid().equals(normId)) throw new IllegalArgumentException(I18n.err(I18n.ERR_458, id, this.attributeType.getName()));
            super.setUpId(normId);
        }
    }

    @Override
    public void setUpId(String upId) {
        if (!StringTools.isEmpty(StringTools.trim(upId))) {
            if (this.attributeType.getName() == null) {
                if (OID.isOID(upId) && this.attributeType.getOid().equals(upId)) {
                    super.setUpId(upId);
                }
            } else {
                String normUpId = StringTools.lowerCaseAscii(StringTools.trim(upId));
                for (String atId : this.attributeType.getNames()) {
                    if (!atId.equalsIgnoreCase(normUpId)) continue;
                    super.setUpId(upId);
                    return;
                }
                if (OID.isOID(normUpId) && this.attributeType.getOid().equals(normUpId)) {
                    super.setUpId(upId);
                }
            }
        }
    }

    @Override
    public void setUpId(String upId, AttributeType attributeType) {
        if (StringTools.isEmpty(StringTools.trim(upId))) {
            super.setUpId(this.getUpId(attributeType));
            this.attributeType = attributeType;
        } else {
            String name = attributeType.getName();
            if (name == null) {
                if (OID.isOID(upId) && attributeType.getOid().equals(upId)) {
                    super.setUpId(upId);
                    this.attributeType = attributeType;
                } else {
                    LOG.warn("The upID ({}) is not an OID or is different from the AttributeType OID({})", (Object)upId, (Object)attributeType.getOid());
                    super.setUpId(attributeType.getOid());
                    this.attributeType = attributeType;
                }
            } else {
                String normUpId = StringTools.lowerCaseAscii(StringTools.trim(upId));
                for (String atId : attributeType.getNames()) {
                    if (!atId.equalsIgnoreCase(normUpId)) continue;
                    super.setUpId(upId);
                    this.attributeType = attributeType;
                    return;
                }
                if (OID.isOID(normUpId) && attributeType.getOid().equals(normUpId)) {
                    super.setUpId(upId);
                    this.attributeType = attributeType;
                } else {
                    String message = I18n.err(I18n.ERR_97, upId, attributeType.getOid());
                    LOG.error(message);
                    throw new IllegalArgumentException(message);
                }
            }
        }
    }

    @Override
    public EntryAttribute toClientAttribute() {
        DefaultClientAttribute clientAttribute = new DefaultClientAttribute(this.upId);
        for (Value<?> value : this) {
            AbstractValue clientValue = null;
            clientValue = value instanceof ServerStringValue ? new ClientStringValue(value.getString()) : new ClientBinaryValue(value.getBytes());
            clientAttribute.add(clientValue);
        }
        return clientAttribute;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        throw new IllegalStateException(I18n.err(I18n.ERR_455, new Object[0]));
    }

    public void serialize(ObjectOutput out) throws IOException {
        out.writeUTF(this.upId);
        if (this.isHR != null) {
            out.writeBoolean(true);
            out.writeBoolean(this.isHR);
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.size());
        if (this.size() > 0) {
            for (Value value : this.values) {
                if (value instanceof ServerStringValue) {
                    ((ServerStringValue)value).serialize(out);
                    continue;
                }
                ((ServerBinaryValue)value).serialize(out);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new IllegalStateException(I18n.err(I18n.ERR_455, new Object[0]));
    }

    public void deserialize(ObjectInput in) throws IOException, ClassNotFoundException {
        int nbValues;
        this.upId = in.readUTF();
        this.setUpId(this.upId);
        if (in.readBoolean()) {
            this.isHR = in.readBoolean();
        }
        if ((nbValues = in.readInt()) > 0) {
            for (int i = 0; i < nbValues; ++i) {
                AbstractValue value = null;
                if (this.isHR.booleanValue()) {
                    value = new ServerStringValue(this.attributeType);
                    ((ServerStringValue)value).deserialize(in);
                } else {
                    value = new ServerBinaryValue(this.attributeType);
                    ((ServerBinaryValue)value).deserialize(in);
                }
                try {
                    value.normalize();
                }
                catch (NamingException ne) {
                    // empty catch block
                }
                this.values.add(value);
            }
        }
    }

    @Override
    public ServerAttribute clone() {
        ServerAttribute clone = (ServerAttribute)super.clone();
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ServerAttribute)) {
            return false;
        }
        ServerAttribute other = (ServerAttribute)obj;
        if (!this.attributeType.equals(other.getAttributeType())) {
            return false;
        }
        if (this.values.size() != other.size()) {
            return false;
        }
        for (Value val : this.values) {
            if (other.contains(val)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h = super.hashCode();
        if (this.attributeType != null) {
            h = h * 17 + this.attributeType.hashCode();
        }
        return h;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.values != null && this.values.size() != 0) {
            for (Value value : this.values) {
                sb.append("    ").append(this.upId).append(": ");
                if (value.isNull()) {
                    sb.append("''");
                } else {
                    sb.append(value);
                }
                sb.append('\n');
            }
        } else {
            sb.append("    ").append(this.upId).append(": (null)\n");
        }
        return sb.toString();
    }
}

