/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class JoinIterator
implements Iterator {
    private final Iterator[] iterators;
    private int index;

    public JoinIterator(Iterator[] iterators) {
        if (iterators == null || iterators.length < 2) {
            throw new IllegalArgumentException("Iterator[] arg must not be null, empty or composed of less than two Iterators");
        }
        if (iterators != null) {
            this.iterators = new Iterator[iterators.length];
            System.arraycopy(iterators, 0, this.iterators, 0, iterators.length);
        } else {
            this.iterators = null;
        }
        this.index = 0;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean hasNext() {
        while (this.index < this.iterators.length) {
            if (this.iterators[this.index].hasNext()) {
                return true;
            }
            ++this.index;
        }
        return false;
    }

    public Object next() {
        while (this.index < this.iterators.length) {
            if (this.iterators[this.index].hasNext()) {
                return this.iterators[this.index].next();
            }
            ++this.index;
        }
        throw new NoSuchElementException();
    }
}

