/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.subtree;

import java.util.Collections;
import java.util.Set;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.subtree.BaseSubtreeSpecification;
import org.apache.directory.shared.ldap.subtree.SubtreeSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubtreeSpecificationModifier {
    private LdapDN base = new LdapDN();
    private Set<LdapDN> chopBefore = Collections.EMPTY_SET;
    private Set<LdapDN> chopAfter = Collections.EMPTY_SET;
    private int minBaseDistance = 0;
    private int maxBaseDistance = -1;
    private ExprNode refinement = null;

    public SubtreeSpecification getSubtreeSpecification() {
        return new BaseSubtreeSpecification(this.base, this.minBaseDistance, this.maxBaseDistance, this.chopAfter, this.chopBefore, this.refinement);
    }

    public void setBase(LdapDN base) {
        this.base = base;
    }

    public void setChopBeforeExclusions(Set<LdapDN> chopBefore) {
        this.chopBefore = chopBefore;
    }

    public void setChopAfterExclusions(Set<LdapDN> chopAfter) {
        this.chopAfter = chopAfter;
    }

    public void setMinBaseDistance(int minBaseDistance) {
        if (minBaseDistance < 0) {
            throw new IllegalArgumentException("A negative minimum base distance is undefined!");
        }
        this.minBaseDistance = minBaseDistance;
    }

    public void setMaxBaseDistance(int maxBaseDistance) {
        this.maxBaseDistance = maxBaseDistance < 0 ? -1 : maxBaseDistance;
    }

    public void setRefinement(ExprNode refinement) {
        this.refinement = refinement;
    }
}

