/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.syntax;

import org.apache.directory.shared.ldap.schema.syntax.AbstractSyntaxChecker;
import org.apache.directory.shared.ldap.util.StringTools;

public class AttributeTypeUsageSyntaxChecker
extends AbstractSyntaxChecker {
    private static final String SC_OID = "1.3.6.1.4.1.18060.0.4.0.0.3";

    public AttributeTypeUsageSyntaxChecker() {
        super(SC_OID);
    }

    protected AttributeTypeUsageSyntaxChecker(String oid) {
        super(oid);
    }

    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? StringTools.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() < "userApplications".length() || strValue.length() > "userApplications".length()) {
            return false;
        }
        char ch = strValue.charAt(0);
        switch (ch) {
            case 'd': {
                return "dSAOperation".equals(strValue) || "directoryOperation".equals(strValue) || "distributedOperation".equals(strValue);
            }
            case 'u': {
                return "userApplications".equals(strValue);
            }
        }
        return false;
    }
}

