/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message.spi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.directory.shared.ldap.message.spi.BinaryAttributeDetector;
import org.apache.directory.shared.ldap.message.spi.ProviderDecoder;
import org.apache.directory.shared.ldap.message.spi.ProviderEncoder;
import org.apache.directory.shared.ldap.message.spi.ProviderException;
import org.apache.directory.shared.ldap.message.spi.ProviderMonitor;
import org.apache.directory.shared.ldap.message.spi.TransformerSpi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Provider {
    public static final String DEFAULT_PROVIDER = "org.apache.directory.shared.ldap.codec.TwixProvider";
    public static final String BERLIB_PROVIDER = "asn.1.berlib.provider";
    public static final String BERLIB_PROPFILE = "berlib.properties";
    public static final String PROVIDER_MONITOR_KEY = "asn.1.berlib.provider.monitor";
    public static final String USING_DEFAULTS_MSG = "Could not find the ASN.1 berlib provider properties file: berlib.properties.\nFile is not present on the classpath or in $JAVA_HOME/lib:\n\tjava.home = " + System.getProperty("java.home") + "\n\tjava.class.path = " + System.getProperty("java.class.path");
    private static ProviderMonitor monitor;
    private final String name;
    private final String vendor;

    private static void findMonitor(Properties props) {
        String fqcn;
        if (props.containsKey(PROVIDER_MONITOR_KEY) && (fqcn = System.getProperties().getProperty(PROVIDER_MONITOR_KEY)) != null) {
            try {
                Class<?> mc = Class.forName(fqcn);
                monitor = (ProviderMonitor)mc.newInstance();
            }
            catch (ClassNotFoundException e) {
                System.err.println("provider monitor class " + fqcn + " not found");
            }
            catch (IllegalAccessException e) {
                System.err.println("provider monitor class " + fqcn + " does not expose a public default constructor");
            }
            catch (InstantiationException e) {
                System.err.println("provider monitor class " + fqcn + " failed during instantiation");
            }
        }
        if (monitor == null) {
            monitor = ProviderMonitor.NOOP_MONITOR;
        }
    }

    protected Provider(String name, String vendor) {
        this.name = name;
        this.vendor = vendor;
    }

    public final String getName() {
        return this.name;
    }

    public final String getVendor() {
        return this.vendor;
    }

    public abstract ProviderEncoder getEncoder() throws ProviderException;

    public abstract ProviderDecoder getDecoder(BinaryAttributeDetector var1) throws ProviderException;

    public abstract TransformerSpi getTransformer() throws ProviderException;

    public static Provider getProvider() throws ProviderException {
        return Provider.getProvider(Provider.getEnvironment());
    }

    public static Provider getProvider(Hashtable<Object, Object> env) throws ProviderException {
        Provider provider;
        String className = (String)env.get(BERLIB_PROVIDER);
        if (className == null || className.trim().equals("")) {
            throw new ProviderException(null, "Could not instantiate provider - environment does not specify asn.1.berlib.provider property!");
        }
        try {
            Class<?> clazz = Class.forName(className);
            Method method = clazz.getMethod("getProvider", null);
            provider = (Provider)method.invoke(null, (Object[])null);
        }
        catch (ClassNotFoundException cnfe) {
            ProviderException pe = new ProviderException(null, "Count not find the Provider class " + className);
            pe.addThrowable(cnfe);
            throw pe;
        }
        catch (NoSuchMethodException nsme) {
            ProviderException pe = new ProviderException(null, "Count not invoke the Provider's factory method: " + className + ".getProvider() - it may not exist!");
            pe.addThrowable(nsme);
            throw pe;
        }
        catch (IllegalAccessException iae) {
            ProviderException pe = new ProviderException(null, "Count not invoke the Provider's factory method: " + className + ".getProvider() - it does seem to be a public method!");
            pe.addThrowable(iae);
            throw pe;
        }
        catch (InvocationTargetException ite) {
            ProviderException pe = new ProviderException(null, "Call to Provider's factory method: " + className + ".getProvider() threw the following exception:\n" + ite.getTargetException());
            pe.addThrowable(ite.getTargetException());
            throw pe;
        }
        return provider;
    }

    public static Properties getEnvironment() {
        Properties env = new Properties();
        env.setProperty(BERLIB_PROVIDER, DEFAULT_PROVIDER);
        monitor.usingDefaults(USING_DEFAULTS_MSG, env);
        return env;
    }

    static {
        Provider.findMonitor(System.getProperties());
    }
}

