/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.filter;

import javax.naming.directory.SearchControls;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SearchScope {
    OBJECT(0, "base"),
    ONELEVEL(1, "one"),
    SUBTREE(2, "sub");

    private final int jndiScope;
    private final String ldapUrlValue;

    private SearchScope(int jndiScope, String ldapUrlValue) {
        this.jndiScope = jndiScope;
        this.ldapUrlValue = ldapUrlValue;
    }

    public String getLdapUrlValue() {
        return this.ldapUrlValue;
    }

    public int getJndiScope() {
        return this.jndiScope;
    }

    public static SearchScope getSearchScope(SearchControls searchControls) {
        return SearchScope.getSearchScope(searchControls.getSearchScope());
    }

    public static SearchScope getSearchScope(int jndiScope) {
        switch (jndiScope) {
            case 0: {
                return OBJECT;
            }
            case 1: {
                return ONELEVEL;
            }
            case 2: {
                return SUBTREE;
            }
        }
        throw new IllegalArgumentException("Unknown JNDI scope constant value: " + jndiScope);
    }
}

