/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.filter;

import java.text.ParseException;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.filter.AndNode;
import org.apache.directory.shared.ldap.filter.ApproximateNode;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.ExtensibleNode;
import org.apache.directory.shared.ldap.filter.FilterParserMonitor;
import org.apache.directory.shared.ldap.filter.GreaterEqNode;
import org.apache.directory.shared.ldap.filter.LessEqNode;
import org.apache.directory.shared.ldap.filter.NotNode;
import org.apache.directory.shared.ldap.filter.OrNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.filter.SubstringNode;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.Position;
import org.apache.directory.shared.ldap.util.StringTools;

public class FilterParser {
    private static ExprNode parseExtensible(String attr, String filter, Position pos) throws ParseException {
        ExtensibleNode node = new ExtensibleNode(attr);
        if (attr != null) {
            if (StringTools.areEquals(filter, pos.start, "dn")) {
                node.setDnAttributes(true);
                pos.start += 2;
            } else {
                --pos.start;
            }
            if (StringTools.charAt(filter, pos.start) == ':') {
                ++pos.start;
                int start = pos.start;
                if (StringTools.charAt(filter, pos.start) == '=') {
                    ++pos.start;
                    node.setValue(FilterParser.parseAssertionValue(filter, pos));
                    return node;
                }
                AttributeUtils.parseAttribute(filter, pos, false);
                node.setMatchingRuleId(filter.substring(start, pos.start));
                if (StringTools.areEquals(filter, pos.start, ":=")) {
                    pos.start += 2;
                    node.setValue(FilterParser.parseAssertionValue(filter, pos));
                    return node;
                }
                throw new ParseException("AssertionValue expected", pos.start);
            }
            throw new ParseException("Expected MatchingRule or assertionValue", pos.start);
        }
        boolean oidRequested = false;
        if (StringTools.areEquals(filter, pos.start, ":dn")) {
            node.setDnAttributes(true);
            pos.start += 3;
        } else {
            oidRequested = true;
        }
        if (StringTools.charAt(filter, pos.start) == ':') {
            ++pos.start;
            int start = pos.start;
            if (StringTools.charAt(filter, pos.start) == '=') {
                if (oidRequested) {
                    throw new ParseException("MatchingRule expected", pos.start);
                }
                ++pos.start;
                node.setValue(FilterParser.parseAssertionValue(filter, pos));
                return node;
            }
            AttributeUtils.parseAttribute(filter, pos, false);
            node.setMatchingRuleId(filter.substring(start, pos.start));
            if (StringTools.areEquals(filter, pos.start, ":=")) {
                pos.start += 2;
                node.setValue(FilterParser.parseAssertionValue(filter, pos));
                return node;
            }
            throw new ParseException("AssertionValue expected", pos.start);
        }
        throw new ParseException("Expected MatchingRule or assertionValue", pos.start);
    }

    private static String parseAssertionValue(String filter, Position pos) throws ParseException {
        int start = pos.start;
        char c = StringTools.charAt(filter, pos.start);
        do {
            if (StringTools.isUnicodeSubset(c)) {
                ++pos.start;
                continue;
            }
            if (StringTools.isCharASCII(filter, pos.start, '\\')) {
                ++pos.start;
                if (StringTools.isHex(filter, pos.start)) {
                    ++pos.start;
                } else {
                    throw new ParseException("Not a valid escaped value", pos.start);
                }
                if (StringTools.isHex(filter, pos.start)) {
                    ++pos.start;
                    continue;
                }
                throw new ParseException("Not a valid escaped value", pos.start);
            }
            return filter.substring(start, pos.start);
        } while ((c = StringTools.charAt(filter, pos.start)) != '\u0000');
        return filter.substring(start, pos.start);
    }

    private static ExprNode parseSubstring(String attr, String initial, String filter, Position pos) throws ParseException {
        if (StringTools.isCharASCII(filter, pos.start, '*')) {
            SubstringNode node = new SubstringNode(attr);
            if (!StringTools.isEmpty(initial)) {
                node.setInitial(initial);
            }
            ++pos.start;
            while (true) {
                String assertionValue = FilterParser.parseAssertionValue(filter, pos);
                if (StringTools.isCharASCII(filter, pos.start, ')')) {
                    if (!StringTools.isEmpty(assertionValue)) {
                        node.setFinal(assertionValue);
                    }
                    return node;
                }
                if (!StringTools.isCharASCII(filter, pos.start, '*')) break;
                if (!StringTools.isEmpty(assertionValue)) {
                    node.addAny(assertionValue);
                }
                ++pos.start;
            }
            throw new ParseException("Bad substring", pos.start);
        }
        throw new ParseException("Bad substring", pos.start);
    }

    private static ExprNode parsePresenceEqOrSubstring(String attr, String filter, Position pos) throws ParseException {
        if (StringTools.isCharASCII(filter, pos.start, '*')) {
            ++pos.start;
            if (StringTools.isCharASCII(filter, pos.start, ')')) {
                return new PresenceNode(attr);
            }
            --pos.start;
            return FilterParser.parseSubstring(attr, null, filter, pos);
        }
        if (StringTools.isCharASCII(filter, pos.start, ')')) {
            return new EqualityNode<String>(attr, new ClientStringValue(""));
        }
        String value = FilterParser.parseAssertionValue(filter, pos);
        if (StringTools.isCharASCII(filter, pos.start, ')')) {
            return new EqualityNode<String>(attr, new ClientStringValue(value));
        }
        return FilterParser.parseSubstring(attr, value, filter, pos);
    }

    private static ExprNode parseItem(String filter, Position pos, char c) throws ParseException {
        SimpleNode node = null;
        String attr = null;
        if (c == '\u0000') {
            throw new ParseException("Bad char", pos.start);
        }
        if (c == ':') {
            return FilterParser.parseExtensible(null, filter, pos);
        }
        attr = AttributeUtils.parseAttribute(filter, pos, true);
        c = StringTools.charAt(filter, pos.start);
        switch (c) {
            case '=': {
                ++pos.start;
                return FilterParser.parsePresenceEqOrSubstring(attr, filter, pos);
            }
            case '~': {
                ++pos.start;
                if (!StringTools.isCharASCII(filter, pos.start, '=')) {
                    throw new ParseException("Expecting a '=' ", pos.start);
                }
                ++pos.start;
                node = new ApproximateNode<String>(attr, new ClientStringValue(FilterParser.parseAssertionValue(filter, pos)));
                return node;
            }
            case '>': {
                ++pos.start;
                if (!StringTools.isCharASCII(filter, pos.start, '=')) {
                    throw new ParseException("Expecting a '=' ", pos.start);
                }
                ++pos.start;
                node = new GreaterEqNode<String>(attr, new ClientStringValue(FilterParser.parseAssertionValue(filter, pos)));
                return node;
            }
            case '<': {
                ++pos.start;
                if (!StringTools.isCharASCII(filter, pos.start, '=')) {
                    throw new ParseException("Expecting a '=' ", pos.start);
                }
                ++pos.start;
                node = new LessEqNode<String>(attr, new ClientStringValue(FilterParser.parseAssertionValue(filter, pos)));
                return node;
            }
            case ':': {
                ++pos.start;
                return FilterParser.parseExtensible(attr, filter, pos);
            }
        }
        throw new ParseException("An item is expected", pos.start);
    }

    private static ExprNode parseBranchNode(ExprNode node, String filter, Position pos) throws ParseException {
        BranchNode bNode = (BranchNode)node;
        ExprNode child = FilterParser.parseFilterInternal(filter, pos);
        bNode.addNode(child);
        while ((child = FilterParser.parseFilterInternal(filter, pos)) != null) {
            bNode.addNode(child);
        }
        return node;
    }

    private static ExprNode parseFilterComp(String filter, Position pos) throws ParseException {
        ExprNode node = null;
        if (pos.start == pos.length) {
            throw new ParseException("Empty filterComp", pos.start);
        }
        char c = StringTools.charAt(filter, pos.start);
        switch (c) {
            case '&': {
                ++pos.start;
                node = new AndNode();
                FilterParser.parseBranchNode(node, filter, pos);
                break;
            }
            case '|': {
                ++pos.start;
                node = new OrNode();
                FilterParser.parseBranchNode(node, filter, pos);
                break;
            }
            case '!': {
                ++pos.start;
                node = new NotNode();
                FilterParser.parseBranchNode(node, filter, pos);
                break;
            }
            default: {
                node = FilterParser.parseItem(filter, pos, c);
            }
        }
        return node;
    }

    private static ExprNode parseFilterInternal(String filter, Position pos) throws ParseException {
        if (!StringTools.isCharASCII(filter, pos.start, '(')) {
            if (pos.start == 0 && pos.length != 0) {
                throw new ParseException("No '(' at the begining of the filter", 0);
            }
            return null;
        }
        ++pos.start;
        ExprNode node = FilterParser.parseFilterComp(filter, pos);
        if (node == null) {
            throw new ParseException("Bad filter", pos.start);
        }
        if (!StringTools.isCharASCII(filter, pos.start, ')')) {
            throw new ParseException("The filter has no right parenthese", pos.start);
        }
        ++pos.start;
        return node;
    }

    public static ExprNode parse(String filter) throws ParseException {
        if (StringTools.isEmpty(filter)) {
            throw new ParseException("Empty filter", 0);
        }
        Position pos = new Position();
        pos.start = 0;
        pos.end = 0;
        pos.length = filter.length();
        return FilterParser.parseFilterInternal(filter, pos);
    }

    public void setFilterParserMonitor(FilterParserMonitor monitor) {
    }
}

