/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.AttributeValueAssertion;
import org.apache.directory.shared.ldap.codec.search.Filter;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientBinaryValue;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.util.StringTools;

public class AttributeValueAssertionFilter
extends Filter {
    private AttributeValueAssertion assertion;
    private int filterType;
    private int avaLength;

    public AttributeValueAssertionFilter(int tlvId, int filterType) {
        super(tlvId);
        this.filterType = filterType;
    }

    public AttributeValueAssertionFilter(int filterType) {
        this.filterType = filterType;
    }

    public AttributeValueAssertion getAssertion() {
        return this.assertion;
    }

    public void setAssertion(AttributeValueAssertion assertion) {
        this.assertion = assertion;
    }

    public int getFilterType() {
        return this.filterType;
    }

    public void setFilterType(int filterType) {
        this.filterType = filterType;
    }

    public int computeLength() {
        this.avaLength = 0;
        int attributeDescLength = this.assertion.getAttributeDesc().length();
        this.avaLength = 1 + TLV.getNbBytes(attributeDescLength) + attributeDescLength;
        Value<?> assertionValue = this.assertion.getAssertionValue();
        int assertionValueLength = 0;
        assertionValueLength = assertionValue instanceof ClientStringValue ? StringTools.getBytesUtf8(((ClientStringValue)assertionValue).get()).length : ((byte[])((ClientBinaryValue)assertionValue).get()).length;
        this.avaLength += 1 + TLV.getNbBytes(assertionValueLength) + assertionValueLength;
        return 1 + TLV.getNbBytes(this.avaLength) + this.avaLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            switch (this.filterType) {
                case 0: {
                    buffer.put((byte)-93);
                    break;
                }
                case 2: {
                    buffer.put((byte)-90);
                    break;
                }
                case 1: {
                    buffer.put((byte)-91);
                    break;
                }
                case 3: {
                    buffer.put((byte)-88);
                }
            }
            buffer.put(TLV.getBytes(this.avaLength));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        org.apache.directory.shared.asn1.ber.tlv.Value.encode(buffer, this.assertion.getAttributeDesc());
        if (this.assertion.getAssertionValue().get() instanceof String) {
            org.apache.directory.shared.asn1.ber.tlv.Value.encode(buffer, (String)this.assertion.getAssertionValue().get());
        } else {
            org.apache.directory.shared.asn1.ber.tlv.Value.encode(buffer, (byte[])this.assertion.getAssertionValue().get());
        }
        return buffer;
    }

    public String toString() {
        return this.assertion != null ? this.assertion.toStringRFC2254(this.filterType) : "";
    }
}

