/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlsInitAction
extends GrammarAction {
    private static final Logger log = LoggerFactory.getLogger(ControlsInitAction.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public ControlsInitAction() {
        super("Initialize a control");
    }

    public void action(IAsn1Container container) throws DecoderException {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        LdapMessage message = ldapMessageContainer.getLdapMessage();
        TLV tlv = ldapMessageContainer.getCurrentTLV();
        int expectedLength = tlv.getLength();
        if (expectedLength == 0) {
            log.error("The length of controls must not be null");
            throw new DecoderException("The length of controls must not be null");
        }
        if (IS_DEBUG) {
            log.debug("A new list of controls has been initialized");
        }
        message.initControls();
    }
}

