/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import org.apache.directory.server.core.cursor.Cursor;
import org.apache.directory.server.core.cursor.InvalidCursorPositionException;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.impl.OneLevelScopeEvaluator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneLevelScopeCursor
extends AbstractIndexCursor<Long, ServerEntry> {
    private static final String UNSUPPORTED_MSG = "Scope Cursors are not ordered and do not support positioning by element.";
    private final Store<ServerEntry> db;
    private final OneLevelScopeEvaluator evaluator;
    private final IndexCursor<Long, ServerEntry> scopeCursor;
    private final Cursor<IndexEntry<Long, ServerEntry>> dereferencedCursor;
    private Cursor<IndexEntry<Long, ServerEntry>> cursor;
    private boolean available = false;

    public OneLevelScopeCursor(Store<ServerEntry> db, OneLevelScopeEvaluator evaluator) throws Exception {
        this.db = db;
        this.evaluator = evaluator;
        this.scopeCursor = db.getOneLevelIndex().forwardCursor(evaluator.getBaseId());
        this.dereferencedCursor = evaluator.isDereferencing() ? db.getOneAliasIndex().forwardCursor(evaluator.getBaseId()) : null;
    }

    @Override
    public boolean available() {
        return this.available;
    }

    @Override
    public void beforeValue(Long id, Long value) throws Exception {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public void afterValue(Long id, Long value) throws Exception {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public void before(IndexEntry<Long, ServerEntry> element) throws Exception {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public void after(IndexEntry<Long, ServerEntry> element) throws Exception {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        this.cursor = this.scopeCursor;
        this.cursor.beforeFirst();
        this.available = false;
    }

    @Override
    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        this.cursor = this.evaluator.isDereferencing() ? this.dereferencedCursor : this.scopeCursor;
        this.cursor.afterLast();
        this.available = false;
    }

    @Override
    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    @Override
    public boolean last() throws Exception {
        this.afterLast();
        return this.previous();
    }

    @Override
    public boolean previous() throws Exception {
        this.checkNotClosed("previous()");
        if (this.cursor == null) {
            this.afterLast();
        }
        if (this.cursor == this.scopeCursor) {
            if (this.evaluator.isDereferencing()) {
                do {
                    this.checkNotClosed("previous()");
                    this.available = this.cursor.previous();
                } while ((!this.available || this.db.getAliasIndex().reverseLookup(this.cursor.get().getId()) != null) && this.available);
            } else {
                this.available = this.cursor.previous();
            }
            return this.available;
        }
        this.available = this.cursor.previous();
        if (!this.available) {
            this.cursor = this.scopeCursor;
            this.cursor.afterLast();
            do {
                this.checkNotClosed("previous()");
                this.available = this.cursor.previous();
            } while ((!this.available || this.db.getAliasIndex().reverseLookup(this.cursor.get().getId()) != null) && this.available);
            return this.available;
        }
        return true;
    }

    @Override
    public boolean next() throws Exception {
        this.checkNotClosed("next()");
        if (this.cursor == null) {
            this.beforeFirst();
        }
        if (this.evaluator.isDereferencing()) {
            do {
                this.checkNotClosed("next()");
                this.available = this.cursor.next();
            } while ((!this.available || this.db.getAliasIndex().reverseLookup(this.cursor.get().getId()) != null) && this.available);
        } else {
            this.available = this.cursor.next();
        }
        if (this.cursor == this.dereferencedCursor) {
            return this.available;
        }
        if (!this.available) {
            if (this.dereferencedCursor != null) {
                this.cursor = this.dereferencedCursor;
                this.cursor.beforeFirst();
                this.available = this.cursor.next();
                return this.available;
            }
            return false;
        }
        return true;
    }

    @Override
    public IndexEntry<Long, ServerEntry> get() throws Exception {
        this.checkNotClosed("get()");
        if (this.available) {
            return this.cursor.get();
        }
        throw new InvalidCursorPositionException("Cursor has not been positioned yet.");
    }

    @Override
    public boolean isElementReused() {
        return this.scopeCursor.isElementReused() || this.dereferencedCursor != null && this.dereferencedCursor.isElementReused();
    }
}

