/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.registries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.SyntaxCheckerRegistry;
import org.apache.directory.shared.ldap.schema.syntax.SyntaxChecker;
import org.apache.directory.shared.ldap.schema.syntax.SyntaxCheckerDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSyntaxCheckerRegistry
implements SyntaxCheckerRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSyntaxCheckerRegistry.class);
    private final Map<String, SyntaxChecker> byOid = new HashMap<String, SyntaxChecker>();
    private final Map<String, SyntaxCheckerDescription> oidToDescription = new HashMap<String, SyntaxCheckerDescription>();

    @Override
    public void register(SyntaxCheckerDescription syntaxCheckerDescription, SyntaxChecker syntaxChecker) throws NamingException {
        if (this.byOid.containsKey(syntaxChecker.getSyntaxOid())) {
            throw new NamingException("SyntaxChecker with OID " + syntaxChecker.getSyntaxOid() + " already registered!");
        }
        this.byOid.put(syntaxChecker.getSyntaxOid(), syntaxChecker);
        this.oidToDescription.put(syntaxChecker.getSyntaxOid(), syntaxCheckerDescription);
        if (LOG.isDebugEnabled()) {
            LOG.debug("registered syntaxChecher for OID " + syntaxChecker.getSyntaxOid());
        }
    }

    @Override
    public SyntaxChecker lookup(String oid) throws NamingException {
        if (!this.byOid.containsKey(oid)) {
            throw new NamingException("SyntaxChecker for OID " + oid + " not found!");
        }
        SyntaxChecker syntaxChecker = this.byOid.get(oid);
        if (LOG.isDebugEnabled()) {
            LOG.debug("looked up syntaxChecher with OID " + oid);
        }
        return syntaxChecker;
    }

    @Override
    public boolean hasSyntaxChecker(String oid) {
        return this.byOid.containsKey(oid);
    }

    @Override
    public String getSchemaName(String oid) throws NamingException {
        if (!Character.isDigit(oid.charAt(0))) {
            throw new NamingException("Looks like the arg is not a numeric OID");
        }
        if (this.oidToDescription.containsKey(oid)) {
            return DefaultSyntaxCheckerRegistry.getSchema(this.oidToDescription.get(oid));
        }
        throw new NamingException("OID " + oid + " not found in oid to " + "schema name map!");
    }

    private static String getSchema(SyntaxCheckerDescription desc) {
        List<String> ext = desc.getExtensions().get("X-SCHEMA");
        if (ext == null || ext.size() == 0) {
            return "other";
        }
        return ext.get(0);
    }

    @Override
    public Iterator<SyntaxChecker> iterator() {
        return this.byOid.values().iterator();
    }

    @Override
    public void unregister(String numericOid) throws NamingException {
        if (!Character.isDigit(numericOid.charAt(0))) {
            throw new NamingException("Looks like the arg is not a numeric OID");
        }
        this.byOid.remove(numericOid);
        this.oidToDescription.remove(numericOid);
    }

    @Override
    public void unregisterSchemaElements(String schemaName) {
        ArrayList<String> oids = new ArrayList<String>(this.byOid.keySet());
        for (String oid : oids) {
            SyntaxCheckerDescription description = this.oidToDescription.get(oid);
            String schemaNameForOid = DefaultSyntaxCheckerRegistry.getSchema(description);
            if (!schemaNameForOid.equalsIgnoreCase(schemaName)) continue;
            this.byOid.remove(oid);
            this.oidToDescription.remove(oid);
        }
    }

    @Override
    public void renameSchema(String originalSchemaName, String newSchemaName) {
        ArrayList<String> oids = new ArrayList<String>(this.byOid.keySet());
        for (String oid : oids) {
            SyntaxCheckerDescription description = this.oidToDescription.get(oid);
            String schemaNameForOid = DefaultSyntaxCheckerRegistry.getSchema(description);
            if (!schemaNameForOid.equalsIgnoreCase(originalSchemaName)) continue;
            List<String> values = description.getExtensions().get("X-SCHEMA");
            values.clear();
            values.add(newSchemaName);
        }
    }

    @Override
    public Iterator<SyntaxCheckerDescription> syntaxCheckerDescriptionIterator() {
        return this.oidToDescription.values().iterator();
    }
}

