/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.registries;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.NoSuchAttributeException;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOidRegistry
implements OidRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOidRegistry.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private Map<String, List<String>> byOid = new HashMap<String, List<String>>();
    private Map<String, String> byName = new HashMap<String, String>();

    @Override
    public String getOid(String name) throws NamingException {
        if (StringTools.isEmpty(name)) {
            throw new NamingException("name should not be empty");
        }
        if (StringTools.isDigit(name.charAt(0))) {
            return name;
        }
        if (this.byName.containsKey(name)) {
            String oid = this.byName.get(name);
            if (IS_DEBUG) {
                LOG.debug("looked up OID '" + oid + "' with id '" + name + "'");
            }
            return oid;
        }
        String lowerCase = name.trim().toLowerCase();
        String oid = this.byName.get(lowerCase);
        if (oid != null) {
            if (IS_DEBUG) {
                LOG.debug("looked up OID '" + oid + "' with id '" + name + "'");
            }
            return oid;
        }
        NoSuchAttributeException fault = new NoSuchAttributeException("OID for name '" + name + "' was not " + "found within the OID registry");
        LOG.error(fault.getMessage());
        throw fault;
    }

    @Override
    public boolean hasOid(String name) {
        if (StringTools.isEmpty(name)) {
            return false;
        }
        String normalized = name.trim().toLowerCase();
        return this.byName.containsKey(normalized);
    }

    @Override
    public String getPrimaryName(String oid) throws NamingException {
        List<String> value = this.byOid.get(oid);
        if (null == value) {
            throw new NamingException("OID '" + oid + "' was not found within the OID registry");
        }
        String name = value.get(0);
        if (IS_DEBUG) {
            LOG.debug("looked up primary name '" + name + "' with OID '" + oid + "'");
        }
        return name;
    }

    @Override
    public List<String> getNameSet(String oid) throws NamingException {
        List<String> value = this.byOid.get(oid);
        if (null == value) {
            throw new NamingException("OID '" + oid + "' was not found within the OID registry");
        }
        if (IS_DEBUG) {
            LOG.debug("looked up names '" + value + "' for OID '" + oid + "'");
        }
        return value;
    }

    @Override
    public Iterator list() {
        return Collections.unmodifiableSet(this.byOid.keySet()).iterator();
    }

    @Override
    public Map<String, String> getOidByName() {
        return this.byName;
    }

    @Override
    public Map<String, List<String>> getNameByOid() {
        return this.byOid;
    }

    @Override
    public void register(String name, String oid) throws NamingException {
        List<Object> value;
        if (!OID.isOID(oid)) {
            String message = "Swap the parameter order: the oid does not start with a digit, or is not an OID!";
            LOG.debug(message);
            throw new NamingException(message);
        }
        if (StringTools.isEmpty(name)) {
            String message = "The name is empty";
            LOG.error(message);
            throw new NamingException(message);
        }
        String lowerCase = name.trim().toLowerCase();
        this.byName.put(lowerCase, oid);
        this.byName.put(oid, oid);
        if (!this.byOid.containsKey(oid)) {
            value = new ArrayList<String>(1);
            value.add(lowerCase);
        } else {
            value = this.byOid.get(oid);
            if (value.contains(lowerCase)) {
                return;
            }
            value.add(lowerCase);
        }
        this.byOid.put(oid, value);
        if (IS_DEBUG) {
            LOG.debug("registed name '" + name + "' with OID: " + oid);
        }
    }

    @Override
    public void unregister(String numericOid) throws NamingException {
        List<String> names = this.byOid.remove(numericOid);
        if (names != null) {
            for (String name : names) {
                this.byName.remove(name);
            }
        }
        this.byName.remove(numericOid);
    }
}

