/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.registries;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.NoSuchAttributeException;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.NoOpNormalizer;
import org.apache.directory.shared.ldap.schema.OidNormalizer;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAttributeTypeRegistry
implements AttributeTypeRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAttributeTypeRegistry.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private final Map<String, AttributeType> byOid = new HashMap<String, AttributeType>();
    private final Map<String, Set<AttributeType>> oidToDescendantSet = new HashMap<String, Set<AttributeType>>();
    private final OidRegistry oidRegistry;
    private transient Map<String, OidNormalizer> mapping;

    public DefaultAttributeTypeRegistry(OidRegistry oidRegistry) {
        this.oidRegistry = oidRegistry;
    }

    @Override
    public void register(AttributeType attributeType) throws NamingException {
        String[] names;
        if (this.byOid.containsKey(attributeType.getOid())) {
            throw new NamingException("attributeType w/ OID " + attributeType.getOid() + " has already been registered!");
        }
        for (String name : names = attributeType.getNamesRef()) {
            this.oidRegistry.register(name, attributeType.getOid());
        }
        this.oidRegistry.register(attributeType.getOid(), attributeType.getOid());
        if (this.mapping != null) {
            this.addMappingFor(attributeType);
        }
        this.registerDescendants(attributeType);
        this.byOid.put(attributeType.getOid(), attributeType);
        if (IS_DEBUG) {
            LOG.debug("registed attributeType: " + attributeType);
        }
    }

    @Override
    public Set<String> getBinaryAttributes() throws NamingException {
        HashSet<String> binaries = new HashSet<String>();
        Iterator<AttributeType> list = this.iterator();
        while (list.hasNext()) {
            String[] names;
            AttributeType type = list.next();
            if (type.getSyntax().isHumanReadable()) continue;
            binaries.add(type.getOid());
            for (String name : names = type.getNamesRef()) {
                binaries.add(StringTools.lowerCaseAscii(StringTools.trim(name)));
            }
        }
        return binaries;
    }

    public void registerDescendants(AttributeType attributeType) throws NamingException {
        this.oidToDescendantSet.put(attributeType.getOid(), new HashSet(5));
        this.onRegisterAddToAncestorDescendants(attributeType, attributeType.getSuperior());
    }

    protected void onRegisterAddToAncestorDescendants(AttributeType newType, AttributeType ancestor) throws NamingException {
        if (ancestor == null) {
            return;
        }
        if (ancestor.getName() != null && ancestor.getName().equals("top")) {
            return;
        }
        Set<AttributeType> descendants = this.oidToDescendantSet.get(ancestor.getOid());
        if (descendants == null) {
            descendants = new HashSet<AttributeType>(5);
            this.oidToDescendantSet.put(ancestor.getOid(), descendants);
        }
        descendants.add(newType);
        this.onRegisterAddToAncestorDescendants(newType, ancestor.getSuperior());
    }

    @Override
    public AttributeType lookup(String id) throws NamingException {
        String oid = this.oidRegistry.getOid(id);
        if (!this.byOid.containsKey(oid)) {
            throw new NoSuchAttributeException("attributeType w/ OID " + oid + " not registered!");
        }
        AttributeType attributeType = this.byOid.get(oid);
        if (IS_DEBUG) {
            LOG.debug("lookup with id" + oid + "' of attributeType: " + attributeType);
        }
        return attributeType;
    }

    @Override
    public boolean hasAttributeType(String id) {
        if (this.oidRegistry.hasOid(id)) {
            try {
                return this.byOid.containsKey(this.oidRegistry.getOid(id));
            }
            catch (NamingException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public String getSchemaName(String id) throws NamingException {
        AttributeType at = this.byOid.get(id = this.oidRegistry.getOid(id));
        if (at != null) {
            return at.getSchema();
        }
        throw new NamingException("OID " + id + " not found in oid to " + "AttributeType map!");
    }

    public Iterator list() {
        return this.byOid.values().iterator();
    }

    private void removeMappingFor(AttributeType type) throws NamingException {
        String[] aliases;
        if (type == null) {
            return;
        }
        MatchingRule matchingRule = type.getEquality();
        this.mapping.remove(type.getOid());
        for (String aliase : aliases = type.getNamesRef()) {
            this.mapping.remove(aliase);
            this.mapping.remove(aliase.toLowerCase());
        }
    }

    private void addMappingFor(AttributeType type) throws NamingException {
        String[] aliases;
        OidNormalizer oidNormalizer;
        MatchingRule matchingRule = type.getEquality();
        if (matchingRule == null) {
            LOG.debug("Attribute " + type.getName() + " does not have normalizer : using NoopNormalizer");
            oidNormalizer = new OidNormalizer(type.getOid(), new NoOpNormalizer());
        } else {
            oidNormalizer = new OidNormalizer(type.getOid(), matchingRule.getNormalizer());
        }
        this.mapping.put(type.getOid(), oidNormalizer);
        for (String aliase : aliases = type.getNamesRef()) {
            this.mapping.put(aliase, oidNormalizer);
            this.mapping.put(aliase.toLowerCase(), oidNormalizer);
        }
    }

    @Override
    public Map<String, OidNormalizer> getNormalizerMapping() throws NamingException {
        if (this.mapping == null) {
            this.mapping = new HashMap<String, OidNormalizer>(this.byOid.size() << 1);
            for (AttributeType type : this.byOid.values()) {
                this.addMappingFor(type);
            }
        }
        return Collections.unmodifiableMap(this.mapping);
    }

    @Override
    public Iterator<AttributeType> descendants(String ancestorId) throws NamingException {
        String oid = this.oidRegistry.getOid(ancestorId);
        Set<AttributeType> descendants = this.oidToDescendantSet.get(oid);
        if (descendants == null) {
            return Collections.EMPTY_SET.iterator();
        }
        return descendants.iterator();
    }

    @Override
    public boolean hasDescendants(String ancestorId) throws NamingException {
        String oid = this.oidRegistry.getOid(ancestorId);
        Set<AttributeType> descendants = this.oidToDescendantSet.get(oid);
        return descendants != null && !descendants.isEmpty();
    }

    @Override
    public Iterator<AttributeType> iterator() {
        return this.byOid.values().iterator();
    }

    @Override
    public void unregister(String numericOid) throws NamingException {
        if (!Character.isDigit(numericOid.charAt(0))) {
            throw new NamingException("Looks like the arg is not a numeric OID");
        }
        if (this.mapping != null) {
            this.removeMappingFor(this.byOid.get(numericOid));
        }
        this.byOid.remove(numericOid);
        this.oidToDescendantSet.remove(numericOid);
    }
}

