/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.bootstrap.partition;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.directory.server.schema.bootstrap.partition.DbFileType;
import org.apache.directory.server.schema.bootstrap.partition.UniqueResourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbFileListing {
    Map<String, DbFileType> name2type = new HashMap<String, DbFileType>();
    private static final String BASE_PATH = DbFileListing.class.getName().substring(0, DbFileListing.class.getName().lastIndexOf(".") + 1).replace('.', '/');

    public DbFileListing() throws IOException {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws IOException {
        boolean userIndexMode = false;
        String line = null;
        BufferedReader in = new BufferedReader(new InputStreamReader(DbFileListing.getUniqueResourceAsStream("DBFILES", "bootstrap partition database file list. Be sure there is exactly one bootstrap partition jar in your classpath.")));
        try {
            while ((line = in.readLine()) != null) {
                if (line.indexOf("master.db") != -1) {
                    this.name2type.put(line.trim(), DbFileType.MASTER_FILE);
                    continue;
                }
                if (line.indexOf("USER INDICES") != -1) {
                    userIndexMode = true;
                    continue;
                }
                if (userIndexMode) {
                    this.name2type.put(line.trim(), DbFileType.USER_INDEX);
                    continue;
                }
                this.name2type.put(line.trim(), DbFileType.SYSTEM_INDEX);
            }
        }
        finally {
            in.close();
        }
    }

    public static InputStream getUniqueResourceAsStream(String resourceName, String resourceDescription) throws IOException {
        resourceName = BASE_PATH + resourceName;
        URL result = DbFileListing.getUniqueResource(resourceName, resourceDescription);
        return result.openStream();
    }

    static URL getUniqueResource(String resourceName, String resourceDescription) throws IOException {
        Enumeration<URL> resources = DbFileListing.class.getClassLoader().getResources(resourceName);
        if (!resources.hasMoreElements()) {
            throw new UniqueResourceException(resourceName, resourceDescription);
        }
        URL result = resources.nextElement();
        if (resources.hasMoreElements()) {
            throw new UniqueResourceException(resourceName, result, resources, resourceDescription);
        }
        return result;
    }

    public DbFileType getType(String dbfile) {
        return this.name2type.get(dbfile);
    }

    public Iterator<String> iterator() {
        return this.name2type.keySet().iterator();
    }

    public String getIndexAttributeName(String dbfile) {
        if (dbfile.length() < 10) {
            throw new IllegalArgumentException("db file must have a relative jar path name of over 10 characters");
        }
        String dbfileName = dbfile.substring(7);
        return dbfileName.substring(0, dbfileName.length() - 3);
    }

    public Set<String> getIndexedAttributes() {
        HashSet<String> attributes = new HashSet<String>();
        Iterator<String> ii = this.iterator();
        while (ii.hasNext()) {
            String name = ii.next();
            if (this.name2type.get(name) != DbFileType.USER_INDEX) continue;
            attributes.add(this.getIndexAttributeName(name));
        }
        return attributes;
    }
}

