/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.bind.gssapi;

import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslServer;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.bind.AbstractMechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.gssapi.GssapiCallbackHandler;
import org.apache.directory.shared.ldap.message.BindRequest;

public class GssapiMechanismHandler
extends AbstractMechanismHandler {
    public SaslServer handleMechanism(LdapSession ldapSession, BindRequest bindRequest) throws Exception {
        SaslServer ss = (SaslServer)ldapSession.getSaslProperty("saslServer");
        if (ss == null) {
            Subject subject = (Subject)ldapSession.getIoSession().getAttribute("saslSubject");
            final Map saslProps = (Map)ldapSession.getIoSession().getAttribute("saslProps");
            final String saslHost = (String)ldapSession.getIoSession().getAttribute("saslHost");
            final GssapiCallbackHandler callbackHandler = new GssapiCallbackHandler(ldapSession.getCoreSession().getDirectoryService(), ldapSession, bindRequest);
            ss = Subject.doAs(subject, new PrivilegedExceptionAction<SaslServer>(){

                @Override
                public SaslServer run() throws Exception {
                    return Sasl.createSaslServer("GSSAPI", "ldap", saslHost, saslProps, callbackHandler);
                }
            });
            ldapSession.getIoSession().setAttribute("saslServer", ss);
        }
        return ss;
    }

    public void init(LdapSession ldapSession) {
        String saslHost = ldapSession.getLdapServer().getSaslHost();
        ldapSession.putSaslProperty("host", saslHost);
    }

    public void cleanup(LdapSession ldapSession) {
        this.insertSaslFilter(ldapSession);
        ldapSession.removeSaslProperty("host");
        ldapSession.removeSaslProperty("userBaseDn");
        ldapSession.removeSaslProperty("saslMech");
        ldapSession.removeSaslProperty("saslProps");
        ldapSession.removeSaslProperty("saslAuthentUser");
    }
}

