/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.LdapRequestHandler;
import org.apache.directory.shared.ldap.message.UnbindRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnbindHandler
extends LdapRequestHandler<UnbindRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(UnbindHandler.class);

    @Override
    public void handle(LdapSession session, UnbindRequest request) throws Exception {
        try {
            session.getCoreSession().unbind(request);
            session.getIoSession().close();
            this.ldapService.getLdapSessionManager().removeLdapSession(session.getIoSession());
        }
        catch (Throwable t) {
            LOG.error("failed to unbind session properly", t);
        }
    }
}

