/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import java.util.Map;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.server.kerberos.shared.store.operations.GetPrincipal;
import org.apache.directory.server.ldap.LdapProtocolUtils;
import org.apache.directory.server.ldap.LdapService;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.LdapRequestHandler;
import org.apache.directory.server.ldap.handlers.bind.MechanismHandler;
import org.apache.directory.server.protocol.shared.ServiceConfigurationException;
import org.apache.directory.shared.ldap.exception.LdapAuthenticationException;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.message.BindRequest;
import org.apache.directory.shared.ldap.message.BindResponse;
import org.apache.directory.shared.ldap.message.LdapResult;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.ExceptionUtils;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindHandler
extends LdapRequestHandler<BindRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(BindHandler.class);
    private Map<String, MechanismHandler> handlers;

    public void setSaslMechanismHandlers(Map<String, MechanismHandler> handlers) {
        this.handlers = handlers;
    }

    public void handleSimpleAuth(LdapSession ldapSession, BindRequest bindRequest) throws Exception {
        if (!ldapSession.isAnonymous()) {
            ldapSession.getCoreSession().unbind();
            ldapSession.setAnonymous();
        }
        BindOperationContext opContext = new BindOperationContext(null);
        opContext.setDn(bindRequest.getName());
        opContext.setCredentials(bindRequest.getCredentials());
        LdapProtocolUtils.setRequestControls(opContext, bindRequest);
        try {
            ClonedServerEntry principalEntry = null;
            try {
                principalEntry = this.getLdapServer().getDirectoryService().getAdminSession().lookup(bindRequest.getName());
            }
            catch (NameNotFoundException e) {
                // empty catch block
            }
            if (principalEntry == null || principalEntry.getOriginalEntry().contains("objectClass", "referral")) {
                LdapResult result = bindRequest.getResultResponse().getLdapResult();
                result.setErrorMessage("Bind principalDn points to referral.");
                result.setResultCode(ResultCodeEnum.INVALID_CREDENTIALS);
                ldapSession.getIoSession().write(bindRequest.getResultResponse());
                return;
            }
            this.getLdapServer().getDirectoryService().getOperationManager().bind(opContext);
            ldapSession.setCoreSession(opContext.getSession());
            if (!ldapSession.getCoreSession().isAnonymous()) {
                ldapSession.setAuthenticated();
            }
            this.sendBindSuccess(ldapSession, bindRequest, null);
        }
        catch (Exception e) {
            ResultCodeEnum code = null;
            LdapResult result = bindRequest.getResultResponse().getLdapResult();
            if (e instanceof LdapException) {
                code = ((LdapException)((Object)e)).getResultCode();
                result.setResultCode(code);
            } else {
                code = ResultCodeEnum.getBestEstimate(e, bindRequest.getType());
                result.setResultCode(code);
            }
            String msg = code.toString() + ": Bind failed: " + e.getMessage();
            if (LOG.isDebugEnabled()) {
                msg = msg + ":\n" + ExceptionUtils.getStackTrace(e);
                msg = msg + "\n\nBindRequest = \n" + bindRequest.toString();
            }
            Name name = null;
            if (e instanceof LdapAuthenticationException) {
                name = ((LdapAuthenticationException)e).getResolvedName();
            }
            if (name != null && (code == ResultCodeEnum.NO_SUCH_OBJECT || code == ResultCodeEnum.ALIAS_PROBLEM || code == ResultCodeEnum.INVALID_DN_SYNTAX || code == ResultCodeEnum.ALIAS_DEREFERENCING_PROBLEM)) {
                result.setMatchedDn(new LdapDN(name));
            }
            result.setErrorMessage(msg);
            ldapSession.getIoSession().write(bindRequest.getResultResponse());
        }
    }

    private boolean checkMechanism(LdapSession ldapSession, String saslMechanism) throws Exception {
        if (!this.ldapService.getSupportedMechanisms().contains(saslMechanism)) {
            LOG.error("Bind error : {} mechanism not supported. Please check the server.xml configuration file (supportedMechanisms field)", (Object)saslMechanism);
            return false;
        }
        return true;
    }

    private void generateSaslChallenge(LdapSession ldapSession, SaslServer ss, BindRequest bindRequest) {
        LdapResult result = bindRequest.getResultResponse().getLdapResult();
        if (bindRequest.getCredentials() == null) {
            bindRequest.setCredentials(StringTools.EMPTY_BYTES);
        }
        try {
            byte[] tokenBytes = ss.evaluateResponse(bindRequest.getCredentials());
            if (ss.isComplete()) {
                if (tokenBytes != null) {
                    ldapSession.putSaslProperty("saslCreds", tokenBytes);
                }
                this.sendBindSuccess(ldapSession, bindRequest, tokenBytes);
            } else {
                LOG.info("Continuation token had length " + tokenBytes.length);
                result.setResultCode(ResultCodeEnum.SASL_BIND_IN_PROGRESS);
                BindResponse resp = (BindResponse)bindRequest.getResultResponse();
                resp.setServerSaslCreds(tokenBytes);
                ldapSession.setAuthPending();
                ldapSession.getIoSession().write(resp);
                LOG.debug("Returning final authentication data to client to complete context.");
            }
        }
        catch (SaslException se) {
            LOG.error(se.getMessage());
            result.setResultCode(ResultCodeEnum.INVALID_CREDENTIALS);
            result.setErrorMessage(ResultCodeEnum.INVALID_CREDENTIALS.toString() + ": " + se.getMessage());
            ldapSession.clearSaslProperties();
            ldapSession.setAnonymous();
            ldapSession.getIoSession().write(bindRequest.getResultResponse());
        }
    }

    private void sendAuthMethNotSupported(LdapSession ldapSession, BindRequest bindRequest) {
        ldapSession.clearSaslProperties();
        ldapSession.setAnonymous();
        LdapResult bindResult = bindRequest.getResultResponse().getLdapResult();
        bindResult.setResultCode(ResultCodeEnum.AUTH_METHOD_NOT_SUPPORTED);
        bindResult.setErrorMessage(ResultCodeEnum.AUTH_METHOD_NOT_SUPPORTED.toString() + ": " + bindRequest.getSaslMechanism() + " is not a supported mechanism.");
        ldapSession.getIoSession().write(bindRequest.getResultResponse());
    }

    private void sendInvalidCredentials(LdapSession ldapSession, BindRequest bindRequest, Exception e) {
        LdapResult result = bindRequest.getResultResponse().getLdapResult();
        String message = "";
        message = e != null ? (Object)((Object)ResultCodeEnum.INVALID_CREDENTIALS) + ": " + e.getMessage() : ResultCodeEnum.INVALID_CREDENTIALS.toString();
        LOG.error(message);
        result.setResultCode(ResultCodeEnum.INVALID_CREDENTIALS);
        result.setErrorMessage(message);
        ldapSession.clearSaslProperties();
        ldapSession.setAnonymous();
        ldapSession.getIoSession().write(bindRequest.getResultResponse());
    }

    private void sendBindSuccess(LdapSession ldapSession, BindRequest bindRequest, byte[] tokenBytes) {
        BindResponse response = (BindResponse)bindRequest.getResultResponse();
        response.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
        response.setServerSaslCreds(tokenBytes);
        if (!ldapSession.getCoreSession().isAnonymous()) {
            ldapSession.setAuthenticated();
        } else {
            ldapSession.setAnonymous();
        }
        MechanismHandler handler = (MechanismHandler)ldapSession.getSaslProperty("saslmechHandler");
        if (handler != null) {
            handler.cleanup(ldapSession);
        }
        ldapSession.getIoSession().write(response);
        LOG.debug("Returned SUCCESS message: {}.", response);
    }

    private void handleSaslAuthPending(LdapSession ldapSession, BindRequest bindRequest, DirectoryService ds) throws Exception {
        String saslMechanism = bindRequest.getSaslMechanism();
        if (StringTools.isEmpty(saslMechanism) || !ldapSession.getSaslProperty("saslMech").equals(saslMechanism)) {
            this.sendAuthMethNotSupported(ldapSession, bindRequest);
            return;
        }
        MechanismHandler mechanismHandler = this.handlers.get(saslMechanism);
        if (mechanismHandler == null) {
            String message = "Handler unavailable for " + saslMechanism;
            ldapSession.clearSaslProperties();
            ldapSession.setAnonymous();
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        SaslServer ss = mechanismHandler.handleMechanism(ldapSession, bindRequest);
        if (bindRequest.getCredentials() == null) {
            bindRequest.setCredentials(StringTools.EMPTY_BYTES);
        }
        byte[] tokenBytes = ss.evaluateResponse(bindRequest.getCredentials());
        if (ss.isComplete()) {
            if (tokenBytes != null) {
                ldapSession.putSaslProperty("saslCreds", tokenBytes);
            }
            try {
                LdapPrincipal ldapPrincipal = (LdapPrincipal)ldapSession.getSaslProperty("saslAuthentUser");
                CoreSession userSession = ds.getSession(ldapPrincipal.getJndiName(), ldapPrincipal.getUserPassword(), saslMechanism, null);
                ldapSession.setCoreSession(userSession);
                ldapSession.setAuthenticated();
                MechanismHandler handler = (MechanismHandler)ldapSession.getSaslProperty("saslmechHandler");
                handler.cleanup(ldapSession);
                this.sendBindSuccess(ldapSession, bindRequest, tokenBytes);
            }
            catch (Exception e) {
                LOG.error("Exception encountered while processing Sasl BindRequest", e);
            }
        }
    }

    public void handleSaslAuth(LdapSession ldapSession, BindRequest bindRequest) throws Exception {
        String saslMechanism = bindRequest.getSaslMechanism();
        DirectoryService ds = this.getLdapServer().getDirectoryService();
        if (ldapSession.isAuthenticated()) {
            ldapSession.getCoreSession().unbind();
            ldapSession.setAnonymous();
            ldapSession.clearSaslProperties();
        }
        if (ldapSession.isAnonymous()) {
            if (!StringTools.isEmpty(saslMechanism)) {
                if (!this.checkMechanism(ldapSession, saslMechanism)) {
                    this.sendAuthMethNotSupported(ldapSession, bindRequest);
                    return;
                }
                ldapSession.putSaslProperty("saslMech", saslMechanism);
                MechanismHandler mechanismHandler = this.handlers.get(saslMechanism);
                ldapSession.putSaslProperty("saslmechHandler", mechanismHandler);
                mechanismHandler.init(ldapSession);
                SaslServer ss = mechanismHandler.handleMechanism(ldapSession, bindRequest);
                this.generateSaslChallenge(ldapSession, ss, bindRequest);
                return;
            }
        } else if (ldapSession.isAuthPending()) {
            try {
                this.handleSaslAuthPending(ldapSession, bindRequest, ds);
            }
            catch (SaslException se) {
                this.sendInvalidCredentials(ldapSession, bindRequest, se);
            }
            return;
        }
    }

    private String getActiveRealms(LdapService ldapService) {
        StringBuilder realms = new StringBuilder();
        boolean isFirst = true;
        for (String realm : ldapService.getSaslRealms()) {
            if (isFirst) {
                isFirst = false;
            } else {
                realms.append(' ');
            }
            realms.append(realm);
        }
        return realms.toString();
    }

    private Subject getSubject(LdapService ldapService) throws Exception {
        String servicePrincipalName = ldapService.getSaslPrincipal();
        KerberosPrincipal servicePrincipal = new KerberosPrincipal(servicePrincipalName);
        GetPrincipal getPrincipal = new GetPrincipal(servicePrincipal);
        PrincipalStoreEntry entry = null;
        try {
            entry = this.findPrincipal(ldapService, getPrincipal);
        }
        catch (ServiceConfigurationException sce) {
            String message = "Service principal " + servicePrincipalName + " not found at search base DN " + ldapService.getSearchBaseDn() + ".";
            throw new ServiceConfigurationException(message, sce);
        }
        if (entry == null) {
            String message = "Service principal " + servicePrincipalName + " not found at search base DN " + ldapService.getSearchBaseDn() + ".";
            throw new ServiceConfigurationException(message);
        }
        Subject subject = new Subject();
        for (EncryptionType encryptionType : entry.getKeyMap().keySet()) {
            EncryptionKey key = entry.getKeyMap().get((Object)encryptionType);
            byte[] keyBytes = key.getKeyValue();
            int type = key.getKeyType().getOrdinal();
            int kvno = key.getKeyVersion();
            KerberosKey serviceKey = new KerberosKey(servicePrincipal, keyBytes, type, kvno);
            subject.getPrivateCredentials().add(serviceKey);
        }
        return subject;
    }

    private PrincipalStoreEntry findPrincipal(LdapService ldapService, GetPrincipal getPrincipal) throws Exception {
        CoreSession adminSession = ldapService.getDirectoryService().getAdminSession();
        return (PrincipalStoreEntry)getPrincipal.execute(adminSession, null);
    }

    @Override
    public void handle(LdapSession ldapSession, BindRequest bindRequest) throws Exception {
        LOG.debug("Received: {}", bindRequest);
        if (!bindRequest.getVersion3()) {
            LOG.error("Bind error : Only LDAP v3 is supported.");
            LdapResult bindResult = bindRequest.getResultResponse().getLdapResult();
            bindResult.setResultCode(ResultCodeEnum.PROTOCOL_ERROR);
            bindResult.setErrorMessage("Only LDAP v3 is supported.");
            ldapSession.getIoSession().write(bindRequest.getResultResponse());
            return;
        }
        if (bindRequest.isSimple()) {
            this.handleSimpleAuth(ldapSession, bindRequest);
        } else {
            this.handleSaslAuth(ldapSession, bindRequest);
        }
    }
}

