/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.core.security.CoreKeyStoreSpi;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.LdapProtocolCodecFactory;
import org.apache.directory.server.ldap.LdapProtocolHandler;
import org.apache.directory.server.ldap.LdapSessionManager;
import org.apache.directory.server.ldap.handlers.AbandonHandler;
import org.apache.directory.server.ldap.handlers.AddHandler;
import org.apache.directory.server.ldap.handlers.BindHandler;
import org.apache.directory.server.ldap.handlers.CompareHandler;
import org.apache.directory.server.ldap.handlers.DeleteHandler;
import org.apache.directory.server.ldap.handlers.ExtendedHandler;
import org.apache.directory.server.ldap.handlers.LdapRequestHandler;
import org.apache.directory.server.ldap.handlers.ModifyDnHandler;
import org.apache.directory.server.ldap.handlers.ModifyHandler;
import org.apache.directory.server.ldap.handlers.SearchHandler;
import org.apache.directory.server.ldap.handlers.UnbindHandler;
import org.apache.directory.server.ldap.handlers.bind.MechanismHandler;
import org.apache.directory.server.ldap.handlers.ssl.LdapsInitializer;
import org.apache.directory.server.protocol.shared.DirectoryBackedService;
import org.apache.directory.shared.ldap.exception.LdapConfigurationException;
import org.apache.directory.shared.ldap.message.AbandonRequest;
import org.apache.directory.shared.ldap.message.AddRequest;
import org.apache.directory.shared.ldap.message.BindRequest;
import org.apache.directory.shared.ldap.message.CompareRequest;
import org.apache.directory.shared.ldap.message.DeleteRequest;
import org.apache.directory.shared.ldap.message.ExtendedRequest;
import org.apache.directory.shared.ldap.message.ModifyDnRequest;
import org.apache.directory.shared.ldap.message.ModifyRequest;
import org.apache.directory.shared.ldap.message.SearchRequest;
import org.apache.directory.shared.ldap.message.UnbindRequest;
import org.apache.directory.shared.ldap.message.extended.NoticeOfDisconnect;
import org.apache.mina.common.DefaultIoFilterChainBuilder;
import org.apache.mina.common.IoFilterChainBuilder;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.handler.demux.MessageHandler;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapService
extends DirectoryBackedService {
    public static final int NO_SIZE_LIMIT = 0;
    public static final int NO_TIME_LIMIT = 0;
    public static final String SERVICE_NAME = "ldap";
    private static final long serialVersionUID = 3757127143811666817L;
    private static final Logger LOG = LoggerFactory.getLogger(LdapService.class.getName());
    private static final int MAX_SIZE_LIMIT_DEFAULT = 100;
    private static final int MAX_TIME_LIMIT_DEFAULT = 10000;
    private static final String SERVICE_PID_DEFAULT = "org.apache.directory.server.ldap";
    private static final String SERVICE_NAME_DEFAULT = "ApacheDS LDAP Service";
    private static final int IP_PORT_DEFAULT = 389;
    private LdapSessionManager ldapSessionManager = new LdapSessionManager();
    private Set<String> supportedControls;
    private int maxSizeLimit = 100;
    private int maxTimeLimit = 10000;
    private boolean enableLdaps;
    private boolean allowAnonymousAccess = true;
    private final Collection<ExtendedOperationHandler> extendedOperationHandlers = new ArrayList<ExtendedOperationHandler>();
    private Map<String, MechanismHandler> saslMechanismHandlers = new HashMap<String, MechanismHandler>();
    private String saslHost = "ldap.example.com";
    private String saslPrincipal = "ldap/ldap.example.com@EXAMPLE.COM";
    private Set<String> saslQop;
    private String saslQopString;
    private List<String> saslRealms;
    private LdapRequestHandler<AbandonRequest> abandonHandler;
    private LdapRequestHandler<AddRequest> addHandler;
    private LdapRequestHandler<BindRequest> bindHandler;
    private LdapRequestHandler<CompareRequest> compareHandler;
    private LdapRequestHandler<DeleteRequest> deleteHandler;
    private LdapRequestHandler<ExtendedRequest> extendedHandler;
    private LdapRequestHandler<ModifyRequest> modifyHandler;
    private LdapRequestHandler<ModifyDnRequest> modifyDnHandler;
    private LdapRequestHandler<SearchRequest> searchHandler;
    private LdapRequestHandler<UnbindRequest> unbindHandler;
    private ProtocolCodecFactory codecFactory;
    private final LdapProtocolHandler handler = new LdapProtocolHandler(this);
    private boolean started;
    private boolean confidentialityRequired;

    public LdapService() {
        super.setIpPort(389);
        super.setEnabled(true);
        super.setServiceId(SERVICE_PID_DEFAULT);
        super.setServiceName(SERVICE_NAME_DEFAULT);
        this.saslQop = new HashSet<String>();
        this.saslQop.add("auth");
        this.saslQop.add("auth-int");
        this.saslQop.add("auth-conf");
        this.saslQopString = "auth,auth-int,auth-conf";
        this.saslRealms = new ArrayList<String>();
        this.saslRealms.add("example.com");
        this.supportedControls = new HashSet<String>();
        this.supportedControls.add("2.16.840.1.113730.3.4.3");
        this.supportedControls.add("2.16.840.1.113730.3.4.7");
        this.supportedControls.add("1.3.6.1.4.1.4203.1.10.1");
        this.supportedControls.add("2.16.840.1.113730.3.4.2");
        this.supportedControls.add("1.3.6.1.4.1.18060.0.0.1");
    }

    private void installDefaultHandlers() {
        if (this.getAbandonHandler() == null) {
            this.setAbandonHandler(new AbandonHandler());
        }
        if (this.getAddHandler() == null) {
            this.setAddHandler(new AddHandler());
        }
        if (this.getBindHandler() == null) {
            BindHandler handler = new BindHandler();
            handler.setSaslMechanismHandlers(this.saslMechanismHandlers);
            this.setBindHandler(handler);
        }
        if (this.getCompareHandler() == null) {
            this.setCompareHandler(new CompareHandler());
        }
        if (this.getDeleteHandler() == null) {
            this.setDeleteHandler(new DeleteHandler());
        }
        if (this.getExtendedHandler() == null) {
            this.setExtendedHandler(new ExtendedHandler());
        }
        if (this.getModifyHandler() == null) {
            this.setModifyHandler(new ModifyHandler());
        }
        if (this.getModifyDnHandler() == null) {
            this.setModifyDnHandler(new ModifyDnHandler());
        }
        if (this.getSearchHandler() == null) {
            this.setSearchHandler(new SearchHandler());
        }
        if (this.getUnbindHandler() == null) {
            this.setUnbindHandler(new UnbindHandler());
        }
    }

    @Override
    public void start() throws Exception {
        IoFilterChainBuilder chain;
        if (!this.isEnabled()) {
            return;
        }
        if (this.isEnableLdaps()) {
            Provider provider = Security.getProvider("SUN");
            LOG.debug("provider = {}", provider);
            CoreKeyStoreSpi coreKeyStoreSpi = new CoreKeyStoreSpi(this.getDirectoryService());
            KeyStore keyStore = new KeyStore(coreKeyStoreSpi, provider, "JKS"){};
            try {
                keyStore.load(null, null);
            }
            catch (Exception e) {
                // empty catch block
            }
            chain = LdapsInitializer.init(keyStore);
        } else {
            chain = new DefaultIoFilterChainBuilder();
        }
        this.installDefaultHandlers();
        this.startLDAP0(this.getIpPort(), chain);
        this.started = true;
    }

    @Override
    public void stop() {
        try {
            ArrayList<IoSession> sessions;
            ArrayList<WriteFuture> writeFutures = new ArrayList<WriteFuture>();
            try {
                sessions = new ArrayList<IoSession>(this.getSocketAcceptor().getManagedSessions(new InetSocketAddress(this.getIpPort())));
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Seems like the LDAP service (" + this.getIpPort() + ") has already been unbound.");
                return;
            }
            this.getSocketAcceptor().unbind(new InetSocketAddress(this.getIpPort()));
            if (LOG.isInfoEnabled()) {
                LOG.info("Unbind of an LDAP service (" + this.getIpPort() + ") is complete.");
                LOG.info("Sending notice of disconnect to existing clients sessions.");
            }
            if (sessions != null) {
                for (IoSession session : sessions) {
                    writeFutures.add(session.write(NoticeOfDisconnect.UNAVAILABLE));
                }
            }
            Iterator sessionIt = sessions.iterator();
            for (WriteFuture future : writeFutures) {
                future.join(1000L);
                ((IoSession)sessionIt.next()).close();
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to sent NoD.", e);
        }
    }

    private void startLDAP0(int port, IoFilterChainBuilder chainBuilder) throws Exception {
        PartitionNexus nexus = this.getDirectoryService().getPartitionNexus();
        for (ExtendedOperationHandler h : this.extendedOperationHandlers) {
            LOG.info("Added Extended Request Handler: " + h.getOid());
            h.setLdapServer(this);
            nexus.registerSupportedExtensions(h.getExtensionOids());
        }
        nexus.registerSupportedSaslMechanisms(this.saslMechanismHandlers.keySet());
        try {
            SocketAcceptorConfig acceptorCfg = new SocketAcceptorConfig();
            acceptorCfg.setDisconnectOnUnbind(false);
            acceptorCfg.setReuseAddress(true);
            acceptorCfg.setFilterChainBuilder(chainBuilder);
            acceptorCfg.setThreadModel(ThreadModel.MANUAL);
            acceptorCfg.getSessionConfig().setTcpNoDelay(true);
            this.getSocketAcceptor().bind(new InetSocketAddress(port), this.getHandler(), acceptorCfg);
            this.started = true;
            if (LOG.isInfoEnabled()) {
                LOG.info("Successful bind of an LDAP Service (" + port + ") is complete.");
            }
        }
        catch (IOException e) {
            String msg = "Failed to bind an LDAP service (" + port + ") to the service registry.";
            LdapConfigurationException lce = new LdapConfigurationException(msg);
            lce.setRootCause(e);
            LOG.error(msg, e);
            throw lce;
        }
    }

    public String getName() {
        return SERVICE_NAME;
    }

    public IoHandler getHandler() {
        return this.handler;
    }

    public LdapSessionManager getLdapSessionManager() {
        return this.ldapSessionManager;
    }

    public ProtocolCodecFactory getProtocolCodecFactory() {
        return this.codecFactory;
    }

    public void addExtendedOperationHandler(ExtendedOperationHandler eoh) throws Exception {
        if (this.started) {
            eoh.setLdapServer(this);
            PartitionNexus nexus = this.getDirectoryService().getPartitionNexus();
            nexus.registerSupportedExtensions(eoh.getExtensionOids());
        } else {
            this.extendedOperationHandlers.add(eoh);
        }
    }

    public void removeExtendedOperationHandler(String oid) {
        ExtendedOperationHandler handler = null;
        for (ExtendedOperationHandler h : this.extendedOperationHandlers) {
            if (!h.getOid().equals(oid)) continue;
            handler = h;
            break;
        }
        this.extendedOperationHandlers.remove(handler);
    }

    public ExtendedOperationHandler getExtendedOperationHandler(String oid) {
        for (ExtendedOperationHandler h : this.extendedOperationHandlers) {
            if (!h.getOid().equals(oid)) continue;
            return h;
        }
        return null;
    }

    public void setConfidentialityRequired(boolean confidentialityRequired) {
        this.confidentialityRequired = confidentialityRequired;
    }

    public boolean isConfidentialityRequired() {
        return this.confidentialityRequired;
    }

    public boolean isEnableLdaps() {
        return this.enableLdaps;
    }

    public void setEnableLdaps(boolean enableLdaps) {
        this.enableLdaps = enableLdaps;
    }

    public boolean isAllowAnonymousAccess() {
        return this.allowAnonymousAccess;
    }

    public void setAllowAnonymousAccess(boolean enableAnonymousAccess) {
        this.allowAnonymousAccess = enableAnonymousAccess;
    }

    public void setMaxSizeLimit(int maxSizeLimit) {
        this.maxSizeLimit = maxSizeLimit;
    }

    public int getMaxSizeLimit() {
        return this.maxSizeLimit;
    }

    public void setMaxTimeLimit(int maxTimeLimit) {
        this.maxTimeLimit = maxTimeLimit;
    }

    public int getMaxTimeLimit() {
        return this.maxTimeLimit;
    }

    public Collection<ExtendedOperationHandler> getExtendedOperationHandlers() {
        return new ArrayList<ExtendedOperationHandler>(this.extendedOperationHandlers);
    }

    public void setExtendedOperationHandlers(Collection<ExtendedOperationHandler> handlers) {
        this.extendedOperationHandlers.clear();
        this.extendedOperationHandlers.addAll(handlers);
    }

    public String getSaslHost() {
        return this.saslHost;
    }

    public void setSaslHost(String saslHost) {
        this.saslHost = saslHost;
    }

    public String getSaslPrincipal() {
        return this.saslPrincipal;
    }

    public void setSaslPrincipal(String saslPrincipal) {
        this.saslPrincipal = saslPrincipal;
    }

    public String getSaslQopString() {
        return this.saslQopString;
    }

    public Set<String> getSaslQop() {
        return this.saslQop;
    }

    public void setSaslQop(Set<String> saslQop) {
        StringBuilder qopList = new StringBuilder();
        boolean isFirst = true;
        for (String qop : saslQop) {
            if (isFirst) {
                isFirst = false;
            } else {
                qopList.append(',');
            }
            qopList.append(qop);
        }
        this.saslQopString = qopList.toString();
        this.saslQop = saslQop;
    }

    public List<String> getSaslRealms() {
        return this.saslRealms;
    }

    public void setSaslRealms(List<String> saslRealms) {
        this.saslRealms = saslRealms;
    }

    public Map<String, MechanismHandler> getSaslMechanismHandlers() {
        return this.saslMechanismHandlers;
    }

    public void setSaslMechanismHandlers(Map<String, MechanismHandler> saslMechanismHandlers) {
        this.saslMechanismHandlers = saslMechanismHandlers;
    }

    public MechanismHandler addSaslMechanismHandler(String mechanism, MechanismHandler handler) {
        return this.saslMechanismHandlers.put(mechanism, handler);
    }

    public MechanismHandler removeSaslMechanismHandler(String mechanism) {
        return this.saslMechanismHandlers.remove(mechanism);
    }

    public MechanismHandler getMechanismHandler(String mechanism) {
        return this.saslMechanismHandlers.get(mechanism);
    }

    public Set<String> getSupportedMechanisms() {
        return this.saslMechanismHandlers.keySet();
    }

    @Override
    public void setDirectoryService(DirectoryService directoryService) {
        super.setDirectoryService(directoryService);
        this.codecFactory = new LdapProtocolCodecFactory(directoryService);
    }

    public Set<String> getSupportedControls() {
        return this.supportedControls;
    }

    public void setSupportedControls(Set<String> supportedControls) {
        this.supportedControls = supportedControls;
    }

    public MessageHandler<AbandonRequest> getAbandonHandler() {
        return this.abandonHandler;
    }

    public void setAbandonHandler(LdapRequestHandler<AbandonRequest> abandonHandler) {
        this.handler.removeMessageHandler(AbandonRequest.class);
        this.abandonHandler = abandonHandler;
        this.abandonHandler.setLdapServer(this);
        this.handler.addMessageHandler(AbandonRequest.class, this.abandonHandler);
    }

    public LdapRequestHandler<AddRequest> getAddHandler() {
        return this.addHandler;
    }

    public void setAddHandler(LdapRequestHandler<AddRequest> addHandler) {
        this.handler.removeMessageHandler(AddRequest.class);
        this.addHandler = addHandler;
        this.addHandler.setLdapServer(this);
        this.handler.addMessageHandler(AddRequest.class, this.addHandler);
    }

    public LdapRequestHandler<BindRequest> getBindHandler() {
        return this.bindHandler;
    }

    public void setBindHandler(LdapRequestHandler<BindRequest> bindHandler) {
        this.handler.removeMessageHandler(BindRequest.class);
        this.bindHandler = bindHandler;
        this.bindHandler.setLdapServer(this);
        this.handler.addMessageHandler(BindRequest.class, this.bindHandler);
    }

    public LdapRequestHandler<CompareRequest> getCompareHandler() {
        return this.compareHandler;
    }

    public void setCompareHandler(LdapRequestHandler<CompareRequest> compareHandler) {
        this.handler.removeMessageHandler(CompareRequest.class);
        this.compareHandler = compareHandler;
        this.compareHandler.setLdapServer(this);
        this.handler.addMessageHandler(CompareRequest.class, this.compareHandler);
    }

    public LdapRequestHandler<DeleteRequest> getDeleteHandler() {
        return this.deleteHandler;
    }

    public void setDeleteHandler(LdapRequestHandler<DeleteRequest> deleteHandler) {
        this.handler.removeMessageHandler(DeleteRequest.class);
        this.deleteHandler = deleteHandler;
        this.deleteHandler.setLdapServer(this);
        this.handler.addMessageHandler(DeleteRequest.class, this.deleteHandler);
    }

    public LdapRequestHandler<ExtendedRequest> getExtendedHandler() {
        return this.extendedHandler;
    }

    public void setExtendedHandler(LdapRequestHandler<ExtendedRequest> extendedHandler) {
        this.handler.removeMessageHandler(ExtendedRequest.class);
        this.extendedHandler = extendedHandler;
        this.extendedHandler.setLdapServer(this);
        this.handler.addMessageHandler(ExtendedRequest.class, this.extendedHandler);
    }

    public LdapRequestHandler<ModifyRequest> getModifyHandler() {
        return this.modifyHandler;
    }

    public void setModifyHandler(LdapRequestHandler<ModifyRequest> modifyHandler) {
        this.handler.removeMessageHandler(ModifyRequest.class);
        this.modifyHandler = modifyHandler;
        this.modifyHandler.setLdapServer(this);
        this.handler.addMessageHandler(ModifyRequest.class, this.modifyHandler);
    }

    public LdapRequestHandler<ModifyDnRequest> getModifyDnHandler() {
        return this.modifyDnHandler;
    }

    public void setModifyDnHandler(LdapRequestHandler<ModifyDnRequest> modifyDnHandler) {
        this.handler.removeMessageHandler(ModifyDnRequest.class);
        this.modifyDnHandler = modifyDnHandler;
        this.modifyDnHandler.setLdapServer(this);
        this.handler.addMessageHandler(ModifyDnRequest.class, this.modifyDnHandler);
    }

    public LdapRequestHandler<SearchRequest> getSearchHandler() {
        return this.searchHandler;
    }

    public void setSearchHandler(LdapRequestHandler<SearchRequest> searchHandler) {
        this.handler.removeMessageHandler(SearchRequest.class);
        this.searchHandler = searchHandler;
        this.searchHandler.setLdapServer(this);
        this.handler.addMessageHandler(SearchRequest.class, this.searchHandler);
    }

    public LdapRequestHandler<UnbindRequest> getUnbindHandler() {
        return this.unbindHandler;
    }

    public void setUnbindHandler(LdapRequestHandler<UnbindRequest> unbindHandler) {
        this.handler.removeMessageHandler(UnbindRequest.class);
        this.unbindHandler = unbindHandler;
        this.unbindHandler.setLdapServer(this);
        this.handler.addMessageHandler(UnbindRequest.class, this.unbindHandler);
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void setStarted(boolean started) {
        this.started = started;
    }
}

