/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.store.operations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.InvalidAttributeValueException;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.entry.ServerStringValue;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.messages.value.SamType;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntryModifier;
import org.apache.directory.server.protocol.shared.store.DirectoryServiceOperation;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;

public class GetAllPrincipals
implements DirectoryServiceOperation {
    private static final long serialVersionUID = -1214321426487445132L;
    private ExprNode filter;

    private ExprNode getFilter(CoreSession session) throws Exception {
        if (this.filter != null) {
            return this.filter;
        }
        AttributeTypeRegistry registry = session.getDirectoryService().getRegistries().getAttributeTypeRegistry();
        AttributeType type = registry.lookup("objectClass");
        ServerStringValue value = new ServerStringValue(type, "krb5Principal");
        this.filter = new EqualityNode<String>("objectClass", value);
        return this.filter;
    }

    public Object execute(CoreSession session, LdapDN searchBaseDn) throws Exception {
        ArrayList<PrincipalStoreEntry> answers = new ArrayList<PrincipalStoreEntry>();
        try {
            EntryFilteringCursor cursor = session.search(searchBaseDn, SearchScope.ONELEVEL, this.getFilter(session), AliasDerefMode.DEREF_ALWAYS, null);
            cursor.beforeFirst();
            while (cursor.next()) {
                ServerEntry result = (ServerEntry)cursor.get();
                PrincipalStoreEntry entry = this.getEntry(result);
                answers.add(entry);
            }
            cursor.close();
            PrincipalStoreEntry[] entries = new PrincipalStoreEntry[answers.size()];
            return answers.toArray(entries);
        }
        catch (NamingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private PrincipalStoreEntry getEntry(ServerEntry attrs) throws Exception {
        PrincipalStoreEntryModifier modifier = new PrincipalStoreEntryModifier();
        String principal = (String)attrs.get("krb5PrincipalName").get().get();
        String keyVersionNumber = (String)attrs.get("krb5KeyVersionNumber").get().get();
        String commonName = (String)attrs.get("cn").get().get();
        if (attrs.get("apacheSamType") != null) {
            String samType = (String)attrs.get("apacheSamType").get().get();
            modifier.setSamType(SamType.getTypeByOrdinal(Integer.parseInt(samType)));
        }
        if (attrs.get("krb5Key") != null) {
            ServerAttribute krb5key = (ServerAttribute)attrs.get("krb5Key");
            try {
                Map<EncryptionType, EncryptionKey> keyMap = modifier.reconstituteKeyMap(krb5key);
                modifier.setKeyMap(keyMap);
            }
            catch (IOException ioe) {
                throw new InvalidAttributeValueException("Account Kerberos key attribute 'krb5Key' contained an invalid value for krb5key.");
            }
        }
        modifier.setCommonName(commonName);
        modifier.setPrincipal(new KerberosPrincipal(principal));
        modifier.setKeyVersionNumber(Integer.parseInt(keyVersionNumber));
        return modifier.getEntry();
    }
}

