/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.subtree;

import javax.naming.Name;
import javax.naming.NamingException;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.event.Evaluator;
import org.apache.directory.server.core.event.ExpressionEvaluator;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.subtree.SubtreeSpecification;
import org.apache.directory.shared.ldap.util.NamespaceTools;

public class SubtreeEvaluator {
    private final Evaluator evaluator;

    public SubtreeEvaluator(OidRegistry oidRegistry, AttributeTypeRegistry attrRegistry) {
        this.evaluator = new ExpressionEvaluator(oidRegistry, attrRegistry);
    }

    public boolean evaluate(SubtreeSpecification subtree, Name apDn, Name entryDn, ServerEntry entry) throws NamingException {
        Name baseRelativeRdn;
        LdapDN entryLdapDn = (LdapDN)entryDn;
        if (!NamespaceTools.isDescendant(apDn, entryDn)) {
            return false;
        }
        Name apRelativeRdn = apDn.equals(entryDn) ? new LdapDN() : NamespaceTools.getRelativeName(apDn, entryDn);
        if (subtree.getBase() != null && subtree.getBase().size() == 0) {
            baseRelativeRdn = apRelativeRdn;
        } else if (apRelativeRdn.equals(subtree.getBase())) {
            baseRelativeRdn = new LdapDN();
        } else {
            if (!NamespaceTools.isDescendant(subtree.getBase(), apRelativeRdn)) {
                return false;
            }
            baseRelativeRdn = NamespaceTools.getRelativeName(subtree.getBase(), apRelativeRdn);
        }
        if (subtree.getMaxBaseDistance() != -1 && subtree.getMaxBaseDistance() < baseRelativeRdn.size()) {
            return false;
        }
        if (subtree.getMinBaseDistance() > 0 && baseRelativeRdn.size() < subtree.getMinBaseDistance()) {
            return false;
        }
        for (Name name : subtree.getChopBeforeExclusions()) {
            if (!NamespaceTools.isDescendant(name, baseRelativeRdn)) continue;
            return false;
        }
        for (Name name : subtree.getChopAfterExclusions()) {
            if (!NamespaceTools.isDescendant(name, baseRelativeRdn) || name.equals(baseRelativeRdn)) continue;
            return false;
        }
        if (subtree.getRefinement() != null) {
            return this.evaluator.evaluate(subtree.getRefinement(), entryLdapDn.toNormName(), entry);
        }
        return true;
    }
}

