/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.subtree;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.directory.server.core.subtree.Subentry;
import org.apache.directory.shared.ldap.subtree.SubtreeSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubentryCache {
    private final Map<String, Subentry> name2subentry = new HashMap<String, Subentry>();

    final Subentry getSubentry(String normalizedName) {
        return this.name2subentry.get(normalizedName);
    }

    final Subentry removeSubentry(String normalizedName) {
        return this.name2subentry.remove(normalizedName);
    }

    final Subentry setSubentry(String normalizedName, SubtreeSpecification ss, int types) {
        Subentry old = this.name2subentry.get(normalizedName);
        Subentry subentry = new Subentry();
        subentry.setSubtreeSpecification(ss);
        subentry.setTypes(types);
        this.name2subentry.put(normalizedName, subentry);
        return old;
    }

    final boolean hasSubentry(String normalizedName) {
        return this.name2subentry.containsKey(normalizedName);
    }

    final Iterator<String> nameIterator() {
        return this.name2subentry.keySet().iterator();
    }
}

