/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.naming.NamingException;
import org.apache.directory.server.core.authn.AuthenticationInterceptor;
import org.apache.directory.server.core.authz.AciAuthorizationInterceptor;
import org.apache.directory.server.core.authz.DefaultAuthorizationInterceptor;
import org.apache.directory.server.core.entry.DefaultServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.exception.ExceptionInterceptor;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.schema.SchemaInterceptor;
import org.apache.directory.server.core.schema.SchemaPartitionDao;
import org.apache.directory.server.schema.bootstrap.Schema;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.server.utils.AttributesFactory;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.DITContentRule;
import org.apache.directory.shared.ldap.schema.DITStructureRule;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.MatchingRuleUse;
import org.apache.directory.shared.ldap.schema.NameForm;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.SchemaObject;
import org.apache.directory.shared.ldap.schema.Syntax;
import org.apache.directory.shared.ldap.schema.syntax.AbstractSchemaDescription;
import org.apache.directory.shared.ldap.schema.syntax.ComparatorDescription;
import org.apache.directory.shared.ldap.schema.syntax.NormalizerDescription;
import org.apache.directory.shared.ldap.schema.syntax.SyntaxCheckerDescription;
import org.apache.directory.shared.ldap.util.Base64;

public class SchemaSubentryModifier {
    private static final Collection<String> BYPASS;
    private AttributesFactory factory = new AttributesFactory();
    private final SchemaPartitionDao dao;
    private Registries registries;

    public SchemaSubentryModifier(Registries registries, SchemaPartitionDao dao) {
        this.registries = registries;
        this.dao = dao;
    }

    private LdapDN getDn(SchemaObject obj) throws NamingException {
        StringBuffer buf = new StringBuffer();
        buf.append("m-oid=").append(obj.getOid()).append(",ou=");
        if (obj instanceof Syntax) {
            buf.append("syntaxes");
        } else if (obj instanceof MatchingRule) {
            buf.append("matchingRules");
        } else if (obj instanceof AttributeType) {
            buf.append("attributeTypes");
        } else if (obj instanceof ObjectClass) {
            buf.append("objectClasses");
        } else if (obj instanceof MatchingRuleUse) {
            buf.append("matchingRuleUse");
        } else if (obj instanceof DITStructureRule) {
            buf.append("ditStructureRules");
        } else if (obj instanceof DITContentRule) {
            buf.append("ditContentRules");
        } else if (obj instanceof NameForm) {
            buf.append("nameForms");
        }
        buf.append(",cn=").append(obj.getSchema()).append(",ou=schema");
        return new LdapDN(buf.toString());
    }

    public void add(OperationContext opContext, ComparatorDescription comparatorDescription) throws Exception {
        String schemaName = this.getSchema(comparatorDescription);
        LdapDN dn = new LdapDN("m-oid=" + comparatorDescription.getNumericOid() + ",ou=comparators,cn=" + schemaName + ",ou=schema");
        Entry entry = this.getEntry(dn, comparatorDescription);
        opContext.add((ServerEntry)entry, BYPASS);
    }

    public void add(OperationContext opContext, NormalizerDescription normalizerDescription) throws Exception {
        String schemaName = this.getSchema(normalizerDescription);
        LdapDN dn = new LdapDN("m-oid=" + normalizerDescription.getNumericOid() + ",ou=normalizers,cn=" + schemaName + ",ou=schema");
        Entry entry = this.getEntry(dn, normalizerDescription);
        opContext.add((ServerEntry)entry, BYPASS);
    }

    public void add(OperationContext opContext, SyntaxCheckerDescription syntaxCheckerDescription) throws Exception {
        String schemaName = this.getSchema(syntaxCheckerDescription);
        LdapDN dn = new LdapDN("m-oid=" + syntaxCheckerDescription.getNumericOid() + ",ou=syntaxCheckers,cn=" + schemaName + ",ou=schema");
        Entry entry = this.getEntry(dn, syntaxCheckerDescription);
        opContext.add((ServerEntry)entry, BYPASS);
    }

    public void addSchemaObject(OperationContext opContext, SchemaObject obj) throws Exception {
        Schema schema = this.dao.getSchema(obj.getSchema());
        LdapDN dn = this.getDn(obj);
        ServerEntry entry = this.factory.getAttributes(obj, schema, opContext.getSession().getDirectoryService().getRegistries());
        entry.setDn(dn);
        opContext.add(entry, BYPASS);
    }

    public void deleteSchemaObject(OperationContext opContext, SchemaObject obj) throws Exception {
        LdapDN dn = this.getDn(obj);
        opContext.delete(dn, BYPASS);
    }

    public void delete(OperationContext opContext, NormalizerDescription normalizerDescription) throws Exception {
        String schemaName = this.getSchema(normalizerDescription);
        LdapDN dn = new LdapDN("m-oid=" + normalizerDescription.getNumericOid() + ",ou=normalizers,cn=" + schemaName + ",ou=schema");
        opContext.delete(dn, BYPASS);
    }

    public void delete(OperationContext opContext, SyntaxCheckerDescription syntaxCheckerDescription) throws Exception {
        String schemaName = this.getSchema(syntaxCheckerDescription);
        LdapDN dn = new LdapDN("m-oid=" + syntaxCheckerDescription.getNumericOid() + ",ou=syntaxCheckers,cn=" + schemaName + ",ou=schema");
        opContext.delete(dn, BYPASS);
    }

    public void delete(OperationContext opContext, ComparatorDescription comparatorDescription) throws Exception {
        String schemaName = this.getSchema(comparatorDescription);
        LdapDN dn = new LdapDN("m-oid=" + comparatorDescription.getNumericOid() + ",ou=comparators,cn=" + schemaName + ",ou=schema");
        opContext.delete(dn, BYPASS);
    }

    private Entry getEntry(LdapDN dn, ComparatorDescription comparatorDescription) {
        DefaultServerEntry entry = new DefaultServerEntry(this.registries, dn);
        entry.put("objectClass", "top", "metaTop", "metaComparator");
        entry.put("m-oid", comparatorDescription.getNumericOid());
        entry.put("m-fqcn", comparatorDescription.getFqcn());
        if (comparatorDescription.getBytecode() != null) {
            entry.put("m-bytecode", (byte[][])new byte[][]{Base64.decode(comparatorDescription.getBytecode().toCharArray())});
        }
        if (comparatorDescription.getDescription() != null) {
            entry.put("m-description", comparatorDescription.getDescription());
        }
        return entry;
    }

    private Entry getEntry(LdapDN dn, NormalizerDescription normalizerDescription) {
        DefaultServerEntry entry = new DefaultServerEntry(this.registries, dn);
        entry.put("objectClass", "top", "metaTop", "metaNormalizer");
        entry.put("m-oid", normalizerDescription.getNumericOid());
        entry.put("m-fqcn", normalizerDescription.getFqcn());
        if (normalizerDescription.getBytecode() != null) {
            entry.put("m-bytecode", (byte[][])new byte[][]{Base64.decode(normalizerDescription.getBytecode().toCharArray())});
        }
        if (normalizerDescription.getDescription() != null) {
            entry.put("m-description", normalizerDescription.getDescription());
        }
        return entry;
    }

    private String getSchema(AbstractSchemaDescription desc) {
        if (desc.getExtensions().containsKey("X-SCHEMA")) {
            return desc.getExtensions().get("X-SCHEMA").get(0);
        }
        return "other";
    }

    private Entry getEntry(LdapDN dn, SyntaxCheckerDescription syntaxCheckerDescription) {
        DefaultServerEntry entry = new DefaultServerEntry(this.registries, dn);
        entry.put("objectClass", "top", "metaTop", "metaSyntaxChecker");
        entry.put("m-oid", syntaxCheckerDescription.getNumericOid());
        entry.put("m-fqcn", syntaxCheckerDescription.getFqcn());
        if (syntaxCheckerDescription.getBytecode() != null) {
            entry.put("m-bytecode", (byte[][])new byte[][]{Base64.decode(syntaxCheckerDescription.getBytecode().toCharArray())});
        }
        if (syntaxCheckerDescription.getDescription() != null) {
            entry.put("m-description", syntaxCheckerDescription.getDescription());
        }
        return entry;
    }

    static {
        HashSet<String> c = new HashSet<String>();
        c.add(AuthenticationInterceptor.class.getName());
        c.add(AciAuthorizationInterceptor.class.getName());
        c.add(DefaultAuthorizationInterceptor.class.getName());
        c.add(ExceptionInterceptor.class.getName());
        c.add(SchemaInterceptor.class.getName());
        BYPASS = Collections.unmodifiableCollection(c);
    }
}

