/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.Set;
import javax.naming.NamingException;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.schema.AbstractSchemaChangeHandler;
import org.apache.directory.server.core.schema.PartitionSchemaLoader;
import org.apache.directory.server.core.schema.SchemaPartitionDao;
import org.apache.directory.server.schema.bootstrap.Schema;
import org.apache.directory.server.schema.registries.MatchingRuleRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.exception.LdapInvalidNameException;
import org.apache.directory.shared.ldap.exception.LdapOperationNotSupportedException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.schema.MatchingRule;

public class MetaMatchingRuleHandler
extends AbstractSchemaChangeHandler {
    private final SchemaPartitionDao dao;
    private final MatchingRuleRegistry matchingRuleRegistry;

    public MetaMatchingRuleHandler(Registries targetRegistries, PartitionSchemaLoader loader, SchemaPartitionDao dao) throws Exception {
        super(targetRegistries, loader);
        this.dao = dao;
        this.matchingRuleRegistry = targetRegistries.getMatchingRuleRegistry();
    }

    protected void modify(LdapDN name, ServerEntry entry, ServerEntry targetEntry, boolean cascade) throws Exception {
        String oid = this.getOid(entry);
        Schema schema = this.getSchema(name);
        MatchingRule mr = this.factory.getMatchingRule(targetEntry, this.targetRegistries, schema.getSchemaName());
        if (!schema.isDisabled()) {
            this.matchingRuleRegistry.unregister(oid);
            this.matchingRuleRegistry.register(mr);
        }
    }

    public void add(LdapDN name, ServerEntry entry) throws Exception {
        LdapDN parentDn = (LdapDN)name.clone();
        parentDn.remove(parentDn.size() - 1);
        this.checkNewParent(parentDn);
        this.checkOidIsUnique(entry);
        String schemaName = this.getSchemaName(name);
        MatchingRule mr = this.factory.getMatchingRule(entry, this.targetRegistries, schemaName);
        this.add(mr);
    }

    public void delete(LdapDN name, ServerEntry entry, boolean cascade) throws Exception {
        String schemaName = this.getSchemaName(name);
        MatchingRule mr = this.factory.getMatchingRule(entry, this.targetRegistries, schemaName);
        Set<ServerEntry> dependees = this.dao.listMatchingRuleDependents(mr);
        if (dependees != null && dependees.size() > 0) {
            throw new LdapOperationNotSupportedException("The matchingRule with OID " + mr.getOid() + " cannot be deleted until all entities" + " using this matchingRule have also been deleted.  The following dependees exist: " + this.getOids(dependees), ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        this.delete(mr, cascade);
    }

    public void delete(MatchingRule mr, boolean cascade) throws Exception {
        Schema schema = this.loader.getSchema(mr.getSchema());
        if (!schema.isDisabled()) {
            this.matchingRuleRegistry.unregister(mr.getOid());
        }
        this.unregisterOids(mr.getOid());
    }

    public void rename(LdapDN name, ServerEntry entry, Rdn newRdn, boolean cascade) throws Exception {
        Schema schema = this.getSchema(name);
        MatchingRule oldMr = this.factory.getMatchingRule(entry, this.targetRegistries, schema.getSchemaName());
        Set<ServerEntry> dependees = this.dao.listMatchingRuleDependents(oldMr);
        if (dependees != null && dependees.size() > 0) {
            throw new LdapOperationNotSupportedException("The matchingRule with OID " + oldMr.getOid() + " cannot be deleted until all entities" + " using this matchingRule have also been deleted.  The following dependees exist: " + this.getOids(dependees), ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        ServerEntry targetEntry = (ServerEntry)entry.clone();
        String newOid = (String)newRdn.getValue();
        this.checkOidIsUnique(newOid);
        targetEntry.put("m-oid", newOid);
        MatchingRule mr = this.factory.getMatchingRule(targetEntry, this.targetRegistries, schema.getSchemaName());
        if (!schema.isDisabled()) {
            this.matchingRuleRegistry.unregister(oldMr.getOid());
            this.matchingRuleRegistry.register(mr);
        } else {
            this.registerOids(mr);
        }
        this.unregisterOids(oldMr.getOid());
    }

    public void move(LdapDN oriChildName, LdapDN newParentName, Rdn newRdn, boolean deleteOldRn, ServerEntry entry, boolean cascade) throws Exception {
        this.checkNewParent(newParentName);
        Schema oldSchema = this.getSchema(oriChildName);
        MatchingRule oldMr = this.factory.getMatchingRule(entry, this.targetRegistries, oldSchema.getSchemaName());
        Set<ServerEntry> dependees = this.dao.listMatchingRuleDependents(oldMr);
        if (dependees != null && dependees.size() > 0) {
            throw new LdapOperationNotSupportedException("The matchingRule with OID " + oldMr.getOid() + " cannot be deleted until all entities" + " using this matchingRule have also been deleted.  The following dependees exist: " + this.getOids(dependees), ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        Schema newSchema = this.getSchema(newParentName);
        ServerEntry targetEntry = (ServerEntry)entry.clone();
        String newOid = (String)newRdn.getValue();
        this.checkOidIsUnique(newOid);
        targetEntry.put("m-oid", newOid);
        MatchingRule mr = this.factory.getMatchingRule(targetEntry, this.targetRegistries, newSchema.getSchemaName());
        if (!oldSchema.isDisabled()) {
            this.matchingRuleRegistry.unregister(oldMr.getOid());
        }
        this.unregisterOids(oldMr.getOid());
        if (!newSchema.isDisabled()) {
            this.matchingRuleRegistry.register(mr);
        } else {
            this.registerOids(mr);
        }
    }

    public void replace(LdapDN oriChildName, LdapDN newParentName, ServerEntry entry, boolean cascade) throws Exception {
        this.checkNewParent(newParentName);
        Schema oldSchema = this.getSchema(oriChildName);
        MatchingRule oldMr = this.factory.getMatchingRule(entry, this.targetRegistries, oldSchema.getSchemaName());
        Set<ServerEntry> dependees = this.dao.listMatchingRuleDependents(oldMr);
        if (dependees != null && dependees.size() > 0) {
            throw new LdapOperationNotSupportedException("The matchingRule with OID " + oldMr.getOid() + " cannot be deleted until all entities" + " using this matchingRule have also been deleted.  The following dependees exist: " + this.getOids(dependees), ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        Schema newSchema = this.getSchema(newParentName);
        MatchingRule mr = this.factory.getMatchingRule(entry, this.targetRegistries, newSchema.getSchemaName());
        if (!oldSchema.isDisabled()) {
            this.matchingRuleRegistry.unregister(oldMr.getOid());
        }
        if (!newSchema.isDisabled()) {
            this.matchingRuleRegistry.register(mr);
        }
    }

    private void checkNewParent(LdapDN newParent) throws NamingException {
        if (newParent.size() != 3) {
            throw new LdapInvalidNameException("The parent dn of a matchingRule should be at most 3 name components in length.", ResultCodeEnum.NAMING_VIOLATION);
        }
        Rdn rdn = newParent.getRdn();
        if (!this.targetRegistries.getOidRegistry().getOid(rdn.getNormType()).equals("2.5.4.11")) {
            throw new LdapInvalidNameException("The parent entry of a matchingRule should be an organizationalUnit.", ResultCodeEnum.NAMING_VIOLATION);
        }
        if (!((String)rdn.getValue()).equalsIgnoreCase("matchingRules")) {
            throw new LdapInvalidNameException("The parent entry of a syntax should have a relative name of ou=matchingRules.", ResultCodeEnum.NAMING_VIOLATION);
        }
    }

    public void add(MatchingRule mr) throws Exception {
        Schema schema = this.loader.getSchema(mr.getSchema());
        if (!schema.isDisabled()) {
            this.matchingRuleRegistry.register(mr);
        } else {
            this.registerOids(mr);
        }
    }
}

