/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import org.apache.directory.server.core.avltree.AvlTree;
import org.apache.directory.server.core.avltree.AvlTreeCursor;
import org.apache.directory.server.core.cursor.InvalidCursorPositionException;
import org.apache.directory.server.xdbm.AbstractTupleCursor;
import org.apache.directory.server.xdbm.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyTupleAvlCursor<K, V>
extends AbstractTupleCursor<K, V> {
    private final AvlTreeCursor<V> wrapped;
    private final K key;
    private Tuple<K, V> returnedTuple = new Tuple();
    private boolean valueAvailable;

    public KeyTupleAvlCursor(AvlTree<V> avlTree, K key) {
        this.key = key;
        this.wrapped = new AvlTreeCursor<V>(avlTree);
    }

    private void clearValue() {
        this.returnedTuple.setKey(this.key);
        this.returnedTuple.setValue(null);
        this.valueAvailable = false;
    }

    @Override
    public boolean available() {
        return this.valueAvailable;
    }

    @Override
    public void beforeKey(K key) throws Exception {
        throw new UnsupportedOperationException("This cursor locks down the key so keywise advances are not allowed.");
    }

    @Override
    public void afterKey(K key) throws Exception {
        throw new UnsupportedOperationException("This cursor locks down the key so keywise advances are not allowed.");
    }

    @Override
    public void beforeValue(K key, V value) throws Exception {
        this.checkNotClosed("beforeValue()");
        if (key != null && !key.equals(this.key)) {
            throw new UnsupportedOperationException("This cursor locks down the key so keywise advances are not allowed.");
        }
        this.wrapped.before(value);
        this.clearValue();
    }

    @Override
    public void afterValue(K key, V value) throws Exception {
        this.checkNotClosed("afterValue()");
        if (key != null && !key.equals(this.key)) {
            throw new UnsupportedOperationException("This cursor locks down the key so keywise advances are not allowed.");
        }
        this.wrapped.after(value);
        this.clearValue();
    }

    @Override
    public void before(Tuple<K, V> element) throws Exception {
        this.checkNotClosed("before()");
        this.wrapped.before(element.getValue());
        this.clearValue();
    }

    @Override
    public void after(Tuple<K, V> element) throws Exception {
        this.checkNotClosed("after()");
        this.wrapped.after(element.getValue());
        this.clearValue();
    }

    @Override
    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        this.wrapped.beforeFirst();
        this.clearValue();
    }

    @Override
    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        this.wrapped.afterLast();
        this.clearValue();
    }

    @Override
    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    @Override
    public boolean last() throws Exception {
        this.afterLast();
        return this.previous();
    }

    @Override
    public boolean previous() throws Exception {
        this.checkNotClosed("previous()");
        if (this.wrapped.previous()) {
            this.returnedTuple.setKey(this.key);
            this.returnedTuple.setValue(this.wrapped.get());
            this.valueAvailable = true;
            return true;
        }
        this.clearValue();
        return false;
    }

    @Override
    public boolean next() throws Exception {
        this.checkNotClosed("next()");
        if (this.wrapped.next()) {
            this.returnedTuple.setKey(this.key);
            this.returnedTuple.setValue(this.wrapped.get());
            this.valueAvailable = true;
            return true;
        }
        this.clearValue();
        return false;
    }

    @Override
    public Tuple<K, V> get() throws Exception {
        this.checkNotClosed("get()");
        if (this.valueAvailable) {
            return this.returnedTuple;
        }
        throw new InvalidCursorPositionException();
    }

    @Override
    public boolean isElementReused() {
        return true;
    }
}

