/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import java.util.Iterator;
import org.apache.directory.server.core.cursor.ClosureMonitor;
import org.apache.directory.server.core.cursor.Cursor;
import org.apache.directory.server.core.cursor.CursorIterator;
import org.apache.directory.server.xdbm.ForwardIndexEntry;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.ReverseIndexEntry;
import org.apache.directory.server.xdbm.Tuple;
import org.apache.directory.server.xdbm.TupleCursor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexCursorAdaptor<K, O>
implements IndexCursor<K, O> {
    final Cursor<Tuple> wrappedCursor;
    final ForwardIndexEntry<K, O> forwardEntry;
    final ReverseIndexEntry<K, O> reverseEntry;

    public IndexCursorAdaptor(Cursor<Tuple> wrappedCursor, boolean forwardIndex) {
        this.wrappedCursor = wrappedCursor;
        if (forwardIndex) {
            this.forwardEntry = new ForwardIndexEntry();
            this.reverseEntry = null;
        } else {
            this.forwardEntry = null;
            this.reverseEntry = new ReverseIndexEntry();
        }
    }

    @Override
    public boolean available() {
        return this.wrappedCursor.available();
    }

    @Override
    public void beforeValue(Long id, K key) throws Exception {
        if (this.wrappedCursor instanceof TupleCursor) {
            ((TupleCursor)this.wrappedCursor).beforeValue(key, id);
        }
    }

    @Override
    public void afterValue(Long id, K key) throws Exception {
        if (this.wrappedCursor instanceof TupleCursor) {
            ((TupleCursor)this.wrappedCursor).afterValue(key, id);
        }
    }

    @Override
    public void before(IndexEntry<K, O> element) throws Exception {
        this.wrappedCursor.before(element.getTuple());
    }

    @Override
    public void after(IndexEntry<K, O> element) throws Exception {
        this.wrappedCursor.after(element.getTuple());
    }

    @Override
    public void beforeFirst() throws Exception {
        this.wrappedCursor.beforeFirst();
    }

    @Override
    public void afterLast() throws Exception {
        this.wrappedCursor.afterLast();
    }

    @Override
    public boolean first() throws Exception {
        return this.wrappedCursor.first();
    }

    @Override
    public boolean last() throws Exception {
        return this.wrappedCursor.last();
    }

    @Override
    public boolean isClosed() throws Exception {
        return this.wrappedCursor.isClosed();
    }

    @Override
    public boolean previous() throws Exception {
        return this.wrappedCursor.previous();
    }

    @Override
    public boolean next() throws Exception {
        return this.wrappedCursor.next();
    }

    @Override
    public IndexEntry<K, O> get() throws Exception {
        if (this.forwardEntry != null) {
            Tuple tuple = this.wrappedCursor.get();
            this.forwardEntry.setTuple(tuple, null);
            return this.forwardEntry;
        }
        Tuple tuple = this.wrappedCursor.get();
        this.reverseEntry.setTuple(tuple, null);
        return this.reverseEntry;
    }

    @Override
    public boolean isElementReused() {
        return true;
    }

    @Override
    public final void setClosureMonitor(ClosureMonitor monitor) {
        this.wrappedCursor.setClosureMonitor(monitor);
    }

    @Override
    public void close() throws Exception {
        this.wrappedCursor.close();
    }

    @Override
    public void close(Exception reason) throws Exception {
        this.wrappedCursor.close(reason);
    }

    @Override
    public Iterator<IndexEntry<K, O>> iterator() {
        return new CursorIterator<IndexEntry<K, O>>(this);
    }
}

