/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.normalization;

import java.util.Map;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.cursor.EmptyCursor;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.filtering.BaseEntryFilteringCursor;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddContextPartitionOperationContext;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.GetMatchedNameOperationContext;
import org.apache.directory.server.core.interceptor.context.GetSuffixOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RemoveContextPartitionOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.normalization.NormalizingVisitor;
import org.apache.directory.server.schema.ConcreteNameComponentNormalizer;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.OidNormalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NormalizationInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(NormalizationInterceptor.class);
    private NormalizingVisitor normVisitor;
    private Map<String, OidNormalizer> attrNormalizers;
    private AttributeTypeRegistry attributeRegistry;

    public void init(DirectoryService directoryService) throws Exception {
        OidRegistry oidRegistry = directoryService.getRegistries().getOidRegistry();
        this.attributeRegistry = directoryService.getRegistries().getAttributeTypeRegistry();
        ConcreteNameComponentNormalizer ncn = new ConcreteNameComponentNormalizer(this.attributeRegistry, oidRegistry);
        this.normVisitor = new NormalizingVisitor(ncn, directoryService.getRegistries());
        this.attrNormalizers = this.attributeRegistry.getNormalizerMapping();
    }

    public void destroy() {
    }

    public void add(NextInterceptor nextInterceptor, AddOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.attrNormalizers);
        opContext.getEntry().getDn().normalize(this.attrNormalizers);
        nextInterceptor.add(opContext);
    }

    public void delete(NextInterceptor nextInterceptor, DeleteOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.attrNormalizers);
        nextInterceptor.delete(opContext);
    }

    public void modify(NextInterceptor nextInterceptor, ModifyOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.attrNormalizers);
        nextInterceptor.modify(opContext);
    }

    public void rename(NextInterceptor nextInterceptor, RenameOperationContext opContext) throws Exception {
        LdapDN rdn = new LdapDN();
        rdn.add(opContext.getNewRdn());
        rdn.normalize(this.attrNormalizers);
        opContext.setNewRdn(rdn.getRdn());
        opContext.getDn().normalize(this.attrNormalizers);
        nextInterceptor.rename(opContext);
    }

    public void move(NextInterceptor nextInterceptor, MoveOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.attrNormalizers);
        opContext.getParent().normalize(this.attrNormalizers);
        nextInterceptor.move(opContext);
    }

    public void moveAndRename(NextInterceptor nextInterceptor, MoveAndRenameOperationContext opContext) throws Exception {
        LdapDN rdn = new LdapDN();
        rdn.add(opContext.getNewRdn());
        rdn.normalize(this.attrNormalizers);
        opContext.setNewRdn(rdn.getRdn());
        opContext.getDn().normalize(this.attrNormalizers);
        opContext.getParent().normalize(this.attrNormalizers);
        nextInterceptor.moveAndRename(opContext);
    }

    public EntryFilteringCursor search(NextInterceptor nextInterceptor, SearchOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.attrNormalizers);
        ExprNode filter = opContext.getFilter();
        ExprNode result = (ExprNode)filter.accept(this.normVisitor);
        if (result == null) {
            LOG.warn("undefined filter based on undefined attributeType not evaluted at all.  Returning empty enumeration.");
            return new BaseEntryFilteringCursor(new EmptyCursor<ServerEntry>(), opContext);
        }
        opContext.setFilter(result);
        return nextInterceptor.search(opContext);
    }

    public boolean hasEntry(NextInterceptor nextInterceptor, EntryOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.attrNormalizers);
        return nextInterceptor.hasEntry(opContext);
    }

    public EntryFilteringCursor list(NextInterceptor nextInterceptor, ListOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.attrNormalizers);
        return nextInterceptor.list(opContext);
    }

    private String[] normalizeAttrsId(String[] attrIds) throws Exception {
        if (attrIds == null) {
            return attrIds;
        }
        String[] normalizedAttrIds = new String[attrIds.length];
        int pos = 0;
        for (String id : attrIds) {
            String oid = this.attributeRegistry.lookup(id).getOid();
            normalizedAttrIds[pos++] = oid;
        }
        return normalizedAttrIds;
    }

    public ClonedServerEntry lookup(NextInterceptor nextInterceptor, LookupOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.attrNormalizers);
        if (opContext.getAttrsId() != null) {
            opContext.setAttrsId(this.normalizeAttrsId(opContext.getAttrsIdArray()));
        }
        return nextInterceptor.lookup(opContext);
    }

    public LdapDN getMatchedName(NextInterceptor nextInterceptor, GetMatchedNameOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.attrNormalizers);
        return nextInterceptor.getMatchedName(opContext);
    }

    public LdapDN getSuffix(NextInterceptor nextInterceptor, GetSuffixOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.attrNormalizers);
        return nextInterceptor.getSuffix(opContext);
    }

    public boolean compare(NextInterceptor next, CompareOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.attrNormalizers);
        return next.compare(opContext);
    }

    public void bind(NextInterceptor next, BindOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.attrNormalizers);
        next.bind(opContext);
    }

    public void addContextPartition(NextInterceptor next, AddContextPartitionOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.attrNormalizers);
        next.addContextPartition(opContext);
    }

    public void removeContextPartition(NextInterceptor next, RemoveContextPartitionOperationContext opContext) throws Exception {
        opContext.getDn().normalize(this.attrNormalizers);
        next.removeContextPartition(opContext);
    }
}

