/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.interceptor.context;

import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.interceptor.context.AbstractChangeOperationContext;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.ModifyDnRequest;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;

public class RenameOperationContext
extends AbstractChangeOperationContext {
    private Rdn newRdn;
    private LdapDN newDn;
    private boolean delOldDn;
    private ClonedServerEntry alteredEntry;

    public RenameOperationContext(CoreSession session) {
        super(session);
    }

    public RenameOperationContext(CoreSession session, LdapDN oldDn, Rdn newRdn, boolean delOldDn) {
        super(session, oldDn);
        this.newRdn = newRdn;
        this.delOldDn = delOldDn;
    }

    public RenameOperationContext(CoreSession session, ModifyDnRequest modifyDnRequest) {
        super(session, modifyDnRequest.getName());
        this.newRdn = modifyDnRequest.getNewRdn();
        if (this.newRdn == null) {
            throw new IllegalStateException("newRdn must not be null for a rename: " + modifyDnRequest);
        }
        this.delOldDn = modifyDnRequest.getDeleteOldRdn();
        this.requestControls = modifyDnRequest.getControls();
    }

    public boolean getDelOldDn() {
        return this.delOldDn;
    }

    public void setDelOldDn(boolean delOldDn) {
        this.delOldDn = delOldDn;
    }

    public LdapDN getNewDn() throws Exception {
        if (this.newDn == null) {
            this.newDn = new LdapDN(this.getDn().getUpName());
            this.newDn.remove(this.newDn.size() - 1);
            this.newDn.add(this.newRdn.getUpName());
            this.newDn.normalize(this.session.getDirectoryService().getRegistries().getAttributeTypeRegistry().getNormalizerMapping());
        }
        return this.newDn;
    }

    public Rdn getNewRdn() {
        return this.newRdn;
    }

    public void setNewRdn(Rdn newRdn) {
        this.newRdn = newRdn;
    }

    public String getName() {
        return MessageTypeEnum.MOD_DN_REQUEST.name();
    }

    public ClonedServerEntry getAlteredEntry() {
        return this.alteredEntry;
    }

    public void setAlteredEntry(ClonedServerEntry alteredEntry) {
        this.alteredEntry = alteredEntry;
    }

    public String toString() {
        return "RenameContext for old DN '" + this.getDn().getUpName() + "'" + ", new RDN '" + this.newRdn + "'" + (this.delOldDn ? ", delete old Dn" : "");
    }
}

