/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.event;

import javax.naming.NamingException;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.event.Evaluator;
import org.apache.directory.server.core.event.LeafEvaluator;
import org.apache.directory.server.core.event.SubstringEvaluator;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.shared.ldap.filter.AndNode;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.NotNode;
import org.apache.directory.shared.ldap.filter.OrNode;

public class ExpressionEvaluator
implements Evaluator {
    private LeafEvaluator leafEvaluator;

    public ExpressionEvaluator(LeafEvaluator leafEvaluator) {
        this.leafEvaluator = leafEvaluator;
    }

    public ExpressionEvaluator(OidRegistry oidRegistry, AttributeTypeRegistry attributeTypeRegistry) {
        SubstringEvaluator substringEvaluator = null;
        substringEvaluator = new SubstringEvaluator(oidRegistry, attributeTypeRegistry);
        this.leafEvaluator = new LeafEvaluator(oidRegistry, attributeTypeRegistry, substringEvaluator);
    }

    public LeafEvaluator getLeafEvaluator() {
        return this.leafEvaluator;
    }

    public boolean evaluate(ExprNode node, String dn, ServerEntry entry) throws NamingException {
        if (node.isLeaf()) {
            return this.leafEvaluator.evaluate(node, dn, entry);
        }
        BranchNode bnode = (BranchNode)node;
        if (bnode instanceof OrNode) {
            for (ExprNode child : bnode.getChildren()) {
                if (!this.evaluate(child, dn, entry)) continue;
                return true;
            }
            return false;
        }
        if (bnode instanceof AndNode) {
            for (ExprNode child : bnode.getChildren()) {
                if (this.evaluate(child, dn, entry)) continue;
                return false;
            }
            return true;
        }
        if (bnode instanceof NotNode) {
            if (null != bnode.getFirstChild()) {
                return !this.evaluate(bnode.getFirstChild(), dn, entry);
            }
            throw new NamingException("Negation has no child: " + node);
        }
        throw new NamingException("Unrecognized branch node operator: " + bnode);
    }
}

