/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.cursor;

import java.util.Iterator;
import org.apache.directory.server.core.cursor.AbstractCursor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IteratorCursor<E>
extends AbstractCursor<E> {
    private final Iterator<E> values;
    private E current;

    public IteratorCursor(Iterator<E> values) {
        this.values = values;
    }

    @Override
    public boolean available() {
        return this.current != null;
    }

    @Override
    public void before(E element) {
        throw new UnsupportedOperationException("Cannot advance before an element on the underlying Iterator.");
    }

    @Override
    public void after(E element) {
        throw new UnsupportedOperationException("Cannot advance after an element on the underlying Iterator.");
    }

    @Override
    public void beforeFirst() {
        throw new UnsupportedOperationException("Cannot advance before first on the underlying Iterator.");
    }

    @Override
    public void afterLast() {
        throw new UnsupportedOperationException("Cannot adanvce after last on the underlying Iterator.");
    }

    @Override
    public boolean first() {
        throw new UnsupportedOperationException("Cannot advance to first position on the underlying Iterator.");
    }

    @Override
    public boolean last() {
        throw new UnsupportedOperationException("Cannot advance to last position on the underlying Iterator.");
    }

    @Override
    public boolean previous() {
        throw new UnsupportedOperationException("Cannot back up on the underlying Iterator.");
    }

    @Override
    public boolean next() throws Exception {
        this.checkNotClosed("next()");
        if (this.values.hasNext()) {
            this.current = this.values.next();
            return true;
        }
        return false;
    }

    @Override
    public E get() throws Exception {
        this.checkNotClosed("get()");
        return this.current;
    }

    @Override
    public boolean isElementReused() {
        return false;
    }
}

