/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.tools.lint;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import org.apache.directory.scim.tools.lint.LintException;

public class Lint {
    JsonNode convert(InputStream inputStream) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        return objectMapper.readTree(inputStream);
    }

    boolean hasMeta(JsonNode jsonNode) {
        return jsonNode.has("meta");
    }

    boolean hasSchemas(JsonNode jsonNode) {
        return jsonNode.has("schemas");
    }

    boolean isSchema(JsonNode jsonNode) {
        boolean schema = false;
        JsonNode metaJsonNode = jsonNode.get("meta");
        if (metaJsonNode != null) {
            schema = "Schema".equals(metaJsonNode.get("resourceType").asText());
        }
        return schema;
    }

    public boolean lint(InputStream inputStream) throws LintException, IOException {
        return this.lint(this.convert(inputStream));
    }

    boolean lint(JsonNode jsonNode) throws LintException {
        boolean output = true;
        if (jsonNode.isArray()) {
            output = this.lintArray(jsonNode);
        } else if (jsonNode.isObject()) {
            output = this.lintObject(jsonNode);
        } else {
            throw new LintException("Unsupported JSON node type: " + jsonNode.getNodeType().name());
        }
        return output;
    }

    boolean lintArray(JsonNode arrayJsonNode) throws LintException {
        boolean output = true;
        for (JsonNode jsonNode : arrayJsonNode) {
            if (jsonNode.isObject()) {
                output = output && this.lintObject(jsonNode);
                continue;
            }
            throw new LintException("Unsupported JSON node type, expected Object, found " + jsonNode.getNodeType().name());
        }
        return output;
    }

    boolean lintObject(JsonNode objectJsonNode) throws LintException {
        boolean output = true;
        if (objectJsonNode.isObject()) {
            output = this.isSchema(objectJsonNode) ? this.lintSchema(objectJsonNode) : this.lintResource(objectJsonNode);
        } else {
            throw new LintException("Unsupported JSON node type, expected Object, found " + objectJsonNode.getNodeType().name());
        }
        return output;
    }

    boolean lintResource(JsonNode resourceJsonNode) {
        return false;
    }

    boolean lintSchema(JsonNode schemaJsonNode) {
        return false;
    }
}

