/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.protocol;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.apache.directory.scim.protocol.data.PatchRequest;
import org.apache.directory.scim.protocol.exception.ScimException;
import org.apache.directory.scim.spec.exception.ResourceException;
import org.apache.directory.scim.spec.filter.attribute.AttributeReferenceListWrapper;
import org.apache.directory.scim.spec.resources.ScimResource;
import org.apache.directory.scim.spec.resources.ScimUser;

@Path(value="Me")
@Tag(name="SCIM")
public interface SelfResource {
    public static final String PATH = "Me";

    @GET
    @Produces(value={"application/scim+json", "application/json"})
    @Operation(description="Get self record")
    @ApiResponses(value={@ApiResponse(content={@Content(mediaType="application/scim+json", schema=@Schema(implementation=ScimResource.class))}), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="500", description="Internal Server Error"), @ApiResponse(responseCode="501", description="Not Implemented")})
    default public Response getSelf(@Parameter(name="attributes") @QueryParam(value="attributes") AttributeReferenceListWrapper attributes, @Parameter(name="excludedAttributes") @QueryParam(value="excludedAttributes") AttributeReferenceListWrapper excludedAttributes) throws ScimException, ResourceException {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }

    @POST
    @Consumes(value={"application/scim+json", "application/json"})
    @Produces(value={"application/scim+json", "application/json"})
    @Operation(description="Create self record")
    @ApiResponses(value={@ApiResponse(responseCode="201", content={@Content(mediaType="application/scim+json", schema=@Schema(implementation=ScimResource.class))}), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="409", description="Conflict"), @ApiResponse(responseCode="500", description="Internal Server Error"), @ApiResponse(responseCode="501", description="Not Implemented")})
    default public Response create(@RequestBody(content={@Content(mediaType="application/scim+json", schema=@Schema(implementation=ScimResource.class))}, required=true) ScimUser resource, @Parameter(name="attributes") @QueryParam(value="attributes") AttributeReferenceListWrapper attributes, @Parameter(name="excludedAttributes") @QueryParam(value="excludedAttributes") AttributeReferenceListWrapper excludedAttributes) throws ScimException, ResourceException {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }

    @PUT
    @Consumes(value={"application/scim+json", "application/json"})
    @Produces(value={"application/scim+json", "application/json"})
    @Operation(description="Update self record")
    @ApiResponses(value={@ApiResponse(content={@Content(mediaType="application/scim+json", schema=@Schema(implementation=ScimResource.class))}), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="500", description="Internal Server Error"), @ApiResponse(responseCode="501", description="Not Implemented")})
    default public Response update(@RequestBody(content={@Content(mediaType="application/scim+json", schema=@Schema(implementation=ScimUser.class))}, required=true) ScimUser resource, @Parameter(name="attributes") @QueryParam(value="attributes") AttributeReferenceListWrapper attributes, @Parameter(name="excludedAttributes") @QueryParam(value="excludedAttributes") AttributeReferenceListWrapper excludedAttributes) throws ScimException, ResourceException {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }

    @PATCH
    @Consumes(value={"application/scim+json", "application/json"})
    @Produces(value={"application/scim+json", "application/json"})
    @Operation(description="Patch a portion of the backing store")
    @ApiResponses(value={@ApiResponse(responseCode="204", content={@Content(mediaType="application/scim+json", schema=@Schema(implementation=ScimResource.class))}), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="500", description="Internal Server Error"), @ApiResponse(responseCode="501", description="Not Implemented")})
    default public Response patch(@RequestBody(content={@Content(mediaType="application/scim+json", schema=@Schema(implementation=PatchRequest.class))}, required=true) PatchRequest patchRequest, @Parameter(name="attributes") @QueryParam(value="attributes") AttributeReferenceListWrapper attributes, @Parameter(name="excludedAttributes") @QueryParam(value="excludedAttributes") AttributeReferenceListWrapper excludedAttributes) throws ScimException, ResourceException {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }

    @DELETE
    @Operation(description="Delete self record")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="400", description="Bad Request"), @ApiResponse(responseCode="404", description="Not found"), @ApiResponse(responseCode="500", description="Internal Server Error"), @ApiResponse(responseCode="501", description="Not Implemented")})
    default public Response delete() throws ScimException, ResourceException {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }
}

