/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.protocol;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;

@Path(value="Schemas")
@Tag(name="SCIM-Configuration")
public interface SchemaResource {
    @GET
    @Produces(value={"application/scim+json", "application/json"})
    @Operation(description="Get All Schemas")
    @ApiResponse(content={@Content(mediaType="application/scim+json", array=@ArraySchema(schema=@Schema(implementation=org.apache.directory.scim.spec.schema.Schema.class)))})
    default public Response getAllSchemas(@QueryParam(value="filter") String filter, @Context UriInfo uriInfo) {
        if (filter != null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }

    @GET
    @Path(value="{uri}")
    @Produces(value={"application/scim+json", "application/json"})
    @Operation(description="Get Schemas by URN")
    @ApiResponse(content={@Content(mediaType="application/scim+json", schema=@Schema(implementation=org.apache.directory.scim.spec.schema.Schema.class))})
    default public Response getSchema(@PathParam(value="uri") String uri, @Context UriInfo uriInfo) {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }
}

