/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.protocol;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.apache.directory.scim.spec.schema.ResourceType;

@Path(value="ResourceTypes")
@Tag(name="SCIM-Configuration")
public interface ResourceTypesResource {
    @GET
    @Produces(value={"application/scim+json", "application/json"})
    @Operation(description="Get All Resource Types")
    @ApiResponse(content={@Content(mediaType="application/scim+json", array=@ArraySchema(schema=@Schema(implementation=ResourceType.class)))})
    default public Response getAllResourceTypes(@QueryParam(value="filter") String filter) throws Exception {
        if (filter != null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }

    @GET
    @Path(value="{name}")
    @Produces(value={"application/scim+json", "application/json"})
    @Operation(description="Get Resource Type by URN")
    @ApiResponse(content={@Content(mediaType="application/scim+json", schema=@Schema(implementation=ResourceType.class))})
    default public Response getResourceType(@PathParam(value="name") String name) throws Exception {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }
}

