/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.server.spi;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.build.compatible.spi.BeanInfo;
import jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension;
import jakarta.enterprise.inject.build.compatible.spi.Messages;
import jakarta.enterprise.inject.build.compatible.spi.Parameters;
import jakarta.enterprise.inject.build.compatible.spi.Registration;
import jakarta.enterprise.inject.build.compatible.spi.Synthesis;
import jakarta.enterprise.inject.build.compatible.spi.SyntheticBeanCreator;
import jakarta.enterprise.inject.build.compatible.spi.SyntheticComponents;
import org.apache.directory.scim.server.configuration.ServerConfiguration;

public class ScimServerBuildCompatibleExtension
implements BuildCompatibleExtension {
    private boolean serverConfigFound = false;

    @Registration(types={ServerConfiguration.class})
    public void registration(BeanInfo beanInfo) {
        this.serverConfigFound = true;
    }

    @Synthesis
    public void synthesise(SyntheticComponents syn, Messages messages) {
        if (!this.serverConfigFound) {
            messages.warn("It is recommended to provide a ServerConfiguration bean to configure SCIMple, a default instance will be used.");
            syn.addBean(ServerConfiguration.class).type(ServerConfiguration.class).scope(ApplicationScoped.class).createWith(DefaultServerConfigurationCreator.class);
        }
    }

    public static class DefaultServerConfigurationCreator
    implements SyntheticBeanCreator<ServerConfiguration> {
        public ServerConfiguration create(Instance<Object> lookup, Parameters params) {
            return new ServerConfiguration();
        }
    }
}

