/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.scim.server.rest;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.directory.scim.server.exception.FilterParseExceptionMapper;
import org.apache.directory.scim.server.exception.GenericExceptionMapper;
import org.apache.directory.scim.server.exception.MutabilityExceptionMapper;
import org.apache.directory.scim.server.exception.ResourceExceptionMapper;
import org.apache.directory.scim.server.exception.ScimExceptionMapper;
import org.apache.directory.scim.server.exception.UnsupportedFilterExceptionMapper;
import org.apache.directory.scim.server.exception.UnsupportedOperationExceptionMapper;
import org.apache.directory.scim.server.exception.WebApplicationExceptionMapper;
import org.apache.directory.scim.server.rest.BulkResourceImpl;
import org.apache.directory.scim.server.rest.GroupResourceImpl;
import org.apache.directory.scim.server.rest.ResourceTypesResourceImpl;
import org.apache.directory.scim.server.rest.SchemaResourceImpl;
import org.apache.directory.scim.server.rest.ScimJacksonXmlBindJsonProvider;
import org.apache.directory.scim.server.rest.ScimpleFeature;
import org.apache.directory.scim.server.rest.SearchResourceImpl;
import org.apache.directory.scim.server.rest.SelfResourceImpl;
import org.apache.directory.scim.server.rest.ServiceProviderConfigResourceImpl;
import org.apache.directory.scim.server.rest.UserResourceImpl;

public final class ScimResourceHelper {
    static final Set<Class<?>> RESOURCE_CLASSES = Set.of(BulkResourceImpl.class, GroupResourceImpl.class, ResourceTypesResourceImpl.class, SchemaResourceImpl.class, SearchResourceImpl.class, SelfResourceImpl.class, ServiceProviderConfigResourceImpl.class, UserResourceImpl.class);
    static final Set<Class<?>> EXCEPTION_MAPPER_CLASSES = Set.of(UnsupportedFilterExceptionMapper.class, ResourceExceptionMapper.class, ScimExceptionMapper.class, FilterParseExceptionMapper.class, WebApplicationExceptionMapper.class, UnsupportedOperationExceptionMapper.class, MutabilityExceptionMapper.class, GenericExceptionMapper.class);
    static final Set<Class<?>> MEDIA_TYPE_SUPPORT_CLASSES = Set.of(ScimJacksonXmlBindJsonProvider.class);
    static final Set<Class<?>> SCIMPLE_CLASSES = Stream.of(RESOURCE_CLASSES, EXCEPTION_MAPPER_CLASSES, MEDIA_TYPE_SUPPORT_CLASSES).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());

    private ScimResourceHelper() {
    }

    public static Set<Class<?>> scimpleFeatureAndResourceClasses() {
        HashSet classes = new HashSet(RESOURCE_CLASSES);
        classes.add(ScimpleFeature.class);
        return Collections.unmodifiableSet(classes);
    }
}

